// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The object representing the state of the migration between the backup policies. </summary>
    public partial class BackupPolicyMigrationState
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupPolicyMigrationState"/>. </summary>
        public BackupPolicyMigrationState()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupPolicyMigrationState"/>. </summary>
        /// <param name="status"> Describes the status of migration between backup policy types. </param>
        /// <param name="targetType"> Describes the target backup policy type of the backup policy migration. </param>
        /// <param name="startOn"> Time at which the backup policy migration started (ISO-8601 format). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupPolicyMigrationState(BackupPolicyMigrationStatus? status, BackupPolicyType? targetType, DateTimeOffset? startOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            TargetType = targetType;
            StartOn = startOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describes the status of migration between backup policy types. </summary>
        [WirePath("status")]
        public BackupPolicyMigrationStatus? Status { get; set; }
        /// <summary> Describes the target backup policy type of the backup policy migration. </summary>
        [WirePath("targetType")]
        public BackupPolicyType? TargetType { get; set; }
        /// <summary> Time at which the backup policy migration started (ISO-8601 format). </summary>
        [WirePath("startTime")]
        public DateTimeOffset? StartOn { get; set; }
    }
}
