// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Cosmos DB resource auto-upgrade policy. </summary>
    internal partial class AutoUpgradePolicyResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoUpgradePolicyResourceInfo"/>. </summary>
        public AutoUpgradePolicyResourceInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutoUpgradePolicyResourceInfo"/>. </summary>
        /// <param name="throughputPolicy"> Represents throughput policy which service must adhere to for auto-upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoUpgradePolicyResourceInfo(ThroughputPolicyResourceInfo throughputPolicy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ThroughputPolicy = throughputPolicy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents throughput policy which service must adhere to for auto-upgrade. </summary>
        [WirePath("throughputPolicy")]
        public ThroughputPolicyResourceInfo ThroughputPolicy { get; set; }
    }
}
