// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class AuthenticationMethodLdapProperties : IUtf8JsonSerializable, IJsonModel<AuthenticationMethodLdapProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AuthenticationMethodLdapProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AuthenticationMethodLdapProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthenticationMethodLdapProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AuthenticationMethodLdapProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ServerHostname))
            {
                writer.WritePropertyName("serverHostname"u8);
                writer.WriteStringValue(ServerHostname);
            }
            if (Optional.IsDefined(ServerPort))
            {
                writer.WritePropertyName("serverPort"u8);
                writer.WriteNumberValue(ServerPort.Value);
            }
            if (Optional.IsDefined(ServiceUserDistinguishedName))
            {
                writer.WritePropertyName("serviceUserDistinguishedName"u8);
                writer.WriteStringValue(ServiceUserDistinguishedName);
            }
            if (Optional.IsDefined(ServiceUserPassword))
            {
                writer.WritePropertyName("serviceUserPassword"u8);
                writer.WriteStringValue(ServiceUserPassword);
            }
            if (Optional.IsDefined(SearchBaseDistinguishedName))
            {
                writer.WritePropertyName("searchBaseDistinguishedName"u8);
                writer.WriteStringValue(SearchBaseDistinguishedName);
            }
            if (Optional.IsDefined(SearchFilterTemplate))
            {
                writer.WritePropertyName("searchFilterTemplate"u8);
                writer.WriteStringValue(SearchFilterTemplate);
            }
            if (Optional.IsCollectionDefined(ServerCertificates))
            {
                writer.WritePropertyName("serverCertificates"u8);
                writer.WriteStartArray();
                foreach (var item in ServerCertificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ConnectionTimeoutInMs))
            {
                writer.WritePropertyName("connectionTimeoutInMs"u8);
                writer.WriteNumberValue(ConnectionTimeoutInMs.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AuthenticationMethodLdapProperties IJsonModel<AuthenticationMethodLdapProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthenticationMethodLdapProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AuthenticationMethodLdapProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAuthenticationMethodLdapProperties(document.RootElement, options);
        }

        internal static AuthenticationMethodLdapProperties DeserializeAuthenticationMethodLdapProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serverHostname = default;
            int? serverPort = default;
            string serviceUserDistinguishedName = default;
            string serviceUserPassword = default;
            string searchBaseDistinguishedName = default;
            string searchFilterTemplate = default;
            IList<CassandraCertificate> serverCertificates = default;
            int? connectionTimeoutInMs = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serverHostname"u8))
                {
                    serverHostname = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    serverPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("serviceUserDistinguishedName"u8))
                {
                    serviceUserDistinguishedName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serviceUserPassword"u8))
                {
                    serviceUserPassword = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("searchBaseDistinguishedName"u8))
                {
                    searchBaseDistinguishedName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("searchFilterTemplate"u8))
                {
                    searchFilterTemplate = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverCertificates"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CassandraCertificate> array = new List<CassandraCertificate>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CassandraCertificate.DeserializeCassandraCertificate(item, options));
                    }
                    serverCertificates = array;
                    continue;
                }
                if (property.NameEquals("connectionTimeoutInMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectionTimeoutInMs = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AuthenticationMethodLdapProperties(
                serverHostname,
                serverPort,
                serviceUserDistinguishedName,
                serviceUserPassword,
                searchBaseDistinguishedName,
                searchFilterTemplate,
                serverCertificates ?? new ChangeTrackingList<CassandraCertificate>(),
                connectionTimeoutInMs,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServerHostname), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serverHostname: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServerHostname))
                {
                    builder.Append("  serverHostname: ");
                    if (ServerHostname.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ServerHostname}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ServerHostname}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServerPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serverPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServerPort))
                {
                    builder.Append("  serverPort: ");
                    builder.AppendLine($"{ServerPort.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceUserDistinguishedName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serviceUserDistinguishedName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServiceUserDistinguishedName))
                {
                    builder.Append("  serviceUserDistinguishedName: ");
                    if (ServiceUserDistinguishedName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ServiceUserDistinguishedName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ServiceUserDistinguishedName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceUserPassword), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serviceUserPassword: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServiceUserPassword))
                {
                    builder.Append("  serviceUserPassword: ");
                    if (ServiceUserPassword.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ServiceUserPassword}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ServiceUserPassword}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SearchBaseDistinguishedName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  searchBaseDistinguishedName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SearchBaseDistinguishedName))
                {
                    builder.Append("  searchBaseDistinguishedName: ");
                    if (SearchBaseDistinguishedName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SearchBaseDistinguishedName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SearchBaseDistinguishedName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SearchFilterTemplate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  searchFilterTemplate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SearchFilterTemplate))
                {
                    builder.Append("  searchFilterTemplate: ");
                    if (SearchFilterTemplate.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SearchFilterTemplate}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SearchFilterTemplate}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServerCertificates), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serverCertificates: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ServerCertificates))
                {
                    if (ServerCertificates.Any())
                    {
                        builder.Append("  serverCertificates: ");
                        builder.AppendLine("[");
                        foreach (var item in ServerCertificates)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  serverCertificates: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectionTimeoutInMs), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  connectionTimeoutInMs: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConnectionTimeoutInMs))
                {
                    builder.Append("  connectionTimeoutInMs: ");
                    builder.AppendLine($"{ConnectionTimeoutInMs.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<AuthenticationMethodLdapProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthenticationMethodLdapProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(AuthenticationMethodLdapProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AuthenticationMethodLdapProperties IPersistableModel<AuthenticationMethodLdapProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AuthenticationMethodLdapProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAuthenticationMethodLdapProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AuthenticationMethodLdapProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AuthenticationMethodLdapProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
