// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Describes the types of schema for analytical storage. </summary>
    public readonly partial struct AnalyticalStorageSchemaType : IEquatable<AnalyticalStorageSchemaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyticalStorageSchemaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyticalStorageSchemaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WellDefinedValue = "WellDefined";
        private const string FullFidelityValue = "FullFidelity";

        /// <summary> WellDefined. </summary>
        public static AnalyticalStorageSchemaType WellDefined { get; } = new AnalyticalStorageSchemaType(WellDefinedValue);
        /// <summary> FullFidelity. </summary>
        public static AnalyticalStorageSchemaType FullFidelity { get; } = new AnalyticalStorageSchemaType(FullFidelityValue);
        /// <summary> Determines if two <see cref="AnalyticalStorageSchemaType"/> values are the same. </summary>
        public static bool operator ==(AnalyticalStorageSchemaType left, AnalyticalStorageSchemaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyticalStorageSchemaType"/> values are not the same. </summary>
        public static bool operator !=(AnalyticalStorageSchemaType left, AnalyticalStorageSchemaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyticalStorageSchemaType"/>. </summary>
        public static implicit operator AnalyticalStorageSchemaType(string value) => new AnalyticalStorageSchemaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyticalStorageSchemaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyticalStorageSchemaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
