// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class MongoDBUserDefinitionOperationSource : IOperationSource<MongoDBUserDefinitionResource>
    {
        private readonly ArmClient _client;

        internal MongoDBUserDefinitionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MongoDBUserDefinitionResource IOperationSource<MongoDBUserDefinitionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MongoDBUserDefinitionData.DeserializeMongoDBUserDefinitionData(document.RootElement);
            return new MongoDBUserDefinitionResource(_client, data);
        }

        async ValueTask<MongoDBUserDefinitionResource> IOperationSource<MongoDBUserDefinitionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MongoDBUserDefinitionData.DeserializeMongoDBUserDefinitionData(document.RootElement);
            return new MongoDBUserDefinitionResource(_client, data);
        }
    }
}
