// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class MongoDBRoleDefinitionOperationSource : IOperationSource<MongoDBRoleDefinitionResource>
    {
        private readonly ArmClient _client;

        internal MongoDBRoleDefinitionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MongoDBRoleDefinitionResource IOperationSource<MongoDBRoleDefinitionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MongoDBRoleDefinitionData.DeserializeMongoDBRoleDefinitionData(document.RootElement);
            return new MongoDBRoleDefinitionResource(_client, data);
        }

        async ValueTask<MongoDBRoleDefinitionResource> IOperationSource<MongoDBRoleDefinitionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MongoDBRoleDefinitionData.DeserializeMongoDBRoleDefinitionData(document.RootElement);
            return new MongoDBRoleDefinitionResource(_client, data);
        }
    }
}
