// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class MongoDBCollectionOperationSource : IOperationSource<MongoDBCollectionResource>
    {
        private readonly ArmClient _client;

        internal MongoDBCollectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MongoDBCollectionResource IOperationSource<MongoDBCollectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MongoDBCollectionData.DeserializeMongoDBCollectionData(document.RootElement);
            return new MongoDBCollectionResource(_client, data);
        }

        async ValueTask<MongoDBCollectionResource> IOperationSource<MongoDBCollectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MongoDBCollectionData.DeserializeMongoDBCollectionData(document.RootElement);
            return new MongoDBCollectionResource(_client, data);
        }
    }
}
