// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class GremlinGraphOperationSource : IOperationSource<GremlinGraphResource>
    {
        private readonly ArmClient _client;

        internal GremlinGraphOperationSource(ArmClient client)
        {
            _client = client;
        }

        GremlinGraphResource IOperationSource<GremlinGraphResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GremlinGraphData.DeserializeGremlinGraphData(document.RootElement);
            return new GremlinGraphResource(_client, data);
        }

        async ValueTask<GremlinGraphResource> IOperationSource<GremlinGraphResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GremlinGraphData.DeserializeGremlinGraphData(document.RootElement);
            return new GremlinGraphResource(_client, data);
        }
    }
}
