// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class GraphResourceGetResultOperationSource : IOperationSource<GraphResourceGetResultResource>
    {
        private readonly ArmClient _client;

        internal GraphResourceGetResultOperationSource(ArmClient client)
        {
            _client = client;
        }

        GraphResourceGetResultResource IOperationSource<GraphResourceGetResultResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GraphResourceGetResultData.DeserializeGraphResourceGetResultData(document.RootElement);
            return new GraphResourceGetResultResource(_client, data);
        }

        async ValueTask<GraphResourceGetResultResource> IOperationSource<GraphResourceGetResultResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GraphResourceGetResultData.DeserializeGraphResourceGetResultData(document.RootElement);
            return new GraphResourceGetResultResource(_client, data);
        }
    }
}
