// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBThroughputPoolOperationSource : IOperationSource<CosmosDBThroughputPoolResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBThroughputPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBThroughputPoolResource IOperationSource<CosmosDBThroughputPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBThroughputPoolData.DeserializeCosmosDBThroughputPoolData(document.RootElement);
            return new CosmosDBThroughputPoolResource(_client, data);
        }

        async ValueTask<CosmosDBThroughputPoolResource> IOperationSource<CosmosDBThroughputPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBThroughputPoolData.DeserializeCosmosDBThroughputPoolData(document.RootElement);
            return new CosmosDBThroughputPoolResource(_client, data);
        }
    }
}
