// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBThroughputPoolAccountOperationSource : IOperationSource<CosmosDBThroughputPoolAccountResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBThroughputPoolAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBThroughputPoolAccountResource IOperationSource<CosmosDBThroughputPoolAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBThroughputPoolAccountData.DeserializeCosmosDBThroughputPoolAccountData(document.RootElement);
            return new CosmosDBThroughputPoolAccountResource(_client, data);
        }

        async ValueTask<CosmosDBThroughputPoolAccountResource> IOperationSource<CosmosDBThroughputPoolAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBThroughputPoolAccountData.DeserializeCosmosDBThroughputPoolAccountData(document.RootElement);
            return new CosmosDBThroughputPoolAccountResource(_client, data);
        }
    }
}
