// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBSqlRoleDefinitionOperationSource : IOperationSource<CosmosDBSqlRoleDefinitionResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBSqlRoleDefinitionOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBSqlRoleDefinitionResource IOperationSource<CosmosDBSqlRoleDefinitionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBSqlRoleDefinitionData.DeserializeCosmosDBSqlRoleDefinitionData(document.RootElement);
            return new CosmosDBSqlRoleDefinitionResource(_client, data);
        }

        async ValueTask<CosmosDBSqlRoleDefinitionResource> IOperationSource<CosmosDBSqlRoleDefinitionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBSqlRoleDefinitionData.DeserializeCosmosDBSqlRoleDefinitionData(document.RootElement);
            return new CosmosDBSqlRoleDefinitionResource(_client, data);
        }
    }
}
