// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBSqlRoleAssignmentOperationSource : IOperationSource<CosmosDBSqlRoleAssignmentResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBSqlRoleAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBSqlRoleAssignmentResource IOperationSource<CosmosDBSqlRoleAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBSqlRoleAssignmentData.DeserializeCosmosDBSqlRoleAssignmentData(document.RootElement);
            return new CosmosDBSqlRoleAssignmentResource(_client, data);
        }

        async ValueTask<CosmosDBSqlRoleAssignmentResource> IOperationSource<CosmosDBSqlRoleAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBSqlRoleAssignmentData.DeserializeCosmosDBSqlRoleAssignmentData(document.RootElement);
            return new CosmosDBSqlRoleAssignmentResource(_client, data);
        }
    }
}
