// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBSqlDatabaseOperationSource : IOperationSource<CosmosDBSqlDatabaseResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBSqlDatabaseOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBSqlDatabaseResource IOperationSource<CosmosDBSqlDatabaseResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBSqlDatabaseData.DeserializeCosmosDBSqlDatabaseData(document.RootElement);
            return new CosmosDBSqlDatabaseResource(_client, data);
        }

        async ValueTask<CosmosDBSqlDatabaseResource> IOperationSource<CosmosDBSqlDatabaseResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBSqlDatabaseData.DeserializeCosmosDBSqlDatabaseData(document.RootElement);
            return new CosmosDBSqlDatabaseResource(_client, data);
        }
    }
}
