// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBSqlContainerOperationSource : IOperationSource<CosmosDBSqlContainerResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBSqlContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBSqlContainerResource IOperationSource<CosmosDBSqlContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBSqlContainerData.DeserializeCosmosDBSqlContainerData(document.RootElement);
            return new CosmosDBSqlContainerResource(_client, data);
        }

        async ValueTask<CosmosDBSqlContainerResource> IOperationSource<CosmosDBSqlContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBSqlContainerData.DeserializeCosmosDBSqlContainerData(document.RootElement);
            return new CosmosDBSqlContainerResource(_client, data);
        }
    }
}
