// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBSqlClientEncryptionKeyOperationSource : IOperationSource<CosmosDBSqlClientEncryptionKeyResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBSqlClientEncryptionKeyOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBSqlClientEncryptionKeyResource IOperationSource<CosmosDBSqlClientEncryptionKeyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBSqlClientEncryptionKeyData.DeserializeCosmosDBSqlClientEncryptionKeyData(document.RootElement);
            return new CosmosDBSqlClientEncryptionKeyResource(_client, data);
        }

        async ValueTask<CosmosDBSqlClientEncryptionKeyResource> IOperationSource<CosmosDBSqlClientEncryptionKeyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBSqlClientEncryptionKeyData.DeserializeCosmosDBSqlClientEncryptionKeyData(document.RootElement);
            return new CosmosDBSqlClientEncryptionKeyResource(_client, data);
        }
    }
}
