// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CosmosDBChaosFaultResourceOperationSource : IOperationSource<CosmosDBChaosFaultResource>
    {
        private readonly ArmClient _client;

        internal CosmosDBChaosFaultResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        CosmosDBChaosFaultResource IOperationSource<CosmosDBChaosFaultResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CosmosDBChaosFaultResourceData.DeserializeCosmosDBChaosFaultResourceData(document.RootElement);
            return new CosmosDBChaosFaultResource(_client, data);
        }

        async ValueTask<CosmosDBChaosFaultResource> IOperationSource<CosmosDBChaosFaultResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CosmosDBChaosFaultResourceData.DeserializeCosmosDBChaosFaultResourceData(document.RootElement);
            return new CosmosDBChaosFaultResource(_client, data);
        }
    }
}
