// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CassandraViewThroughputSettingOperationSource : IOperationSource<CassandraViewThroughputSettingResource>
    {
        private readonly ArmClient _client;

        internal CassandraViewThroughputSettingOperationSource(ArmClient client)
        {
            _client = client;
        }

        CassandraViewThroughputSettingResource IOperationSource<CassandraViewThroughputSettingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ThroughputSettingData.DeserializeThroughputSettingData(document.RootElement);
            return new CassandraViewThroughputSettingResource(_client, data);
        }

        async ValueTask<CassandraViewThroughputSettingResource> IOperationSource<CassandraViewThroughputSettingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ThroughputSettingData.DeserializeThroughputSettingData(document.RootElement);
            return new CassandraViewThroughputSettingResource(_client, data);
        }
    }
}
