// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CassandraViewGetResultOperationSource : IOperationSource<CassandraViewGetResultResource>
    {
        private readonly ArmClient _client;

        internal CassandraViewGetResultOperationSource(ArmClient client)
        {
            _client = client;
        }

        CassandraViewGetResultResource IOperationSource<CassandraViewGetResultResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CassandraViewGetResultData.DeserializeCassandraViewGetResultData(document.RootElement);
            return new CassandraViewGetResultResource(_client, data);
        }

        async ValueTask<CassandraViewGetResultResource> IOperationSource<CassandraViewGetResultResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CassandraViewGetResultData.DeserializeCassandraViewGetResultData(document.RootElement);
            return new CassandraViewGetResultResource(_client, data);
        }
    }
}
