// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CassandraTableOperationSource : IOperationSource<CassandraTableResource>
    {
        private readonly ArmClient _client;

        internal CassandraTableOperationSource(ArmClient client)
        {
            _client = client;
        }

        CassandraTableResource IOperationSource<CassandraTableResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CassandraTableData.DeserializeCassandraTableData(document.RootElement);
            return new CassandraTableResource(_client, data);
        }

        async ValueTask<CassandraTableResource> IOperationSource<CassandraTableResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CassandraTableData.DeserializeCassandraTableData(document.RootElement);
            return new CassandraTableResource(_client, data);
        }
    }
}
