// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.CosmosDB.Models;

namespace Azure.ResourceManager.CosmosDB
{
    internal class CassandraCommandOutputOperationSource : IOperationSource<CassandraCommandOutput>
    {
        CassandraCommandOutput IOperationSource<CassandraCommandOutput>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return CassandraCommandOutput.DeserializeCassandraCommandOutput(document.RootElement);
        }

        async ValueTask<CassandraCommandOutput> IOperationSource<CassandraCommandOutput>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return CassandraCommandOutput.DeserializeCassandraCommandOutput(document.RootElement);
        }
    }
}
