// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CosmosDB.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CosmosDB
{
    /// <summary>
    /// A class representing the DataTransferJobGetResult data model.
    /// A Cosmos DB Data Transfer Job
    /// </summary>
    public partial class DataTransferJobGetResultData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataTransferJobGetResultData"/>. </summary>
        public DataTransferJobGetResultData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataTransferJobGetResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="jobName"> Job Name. </param>
        /// <param name="source">
        /// Source DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </param>
        /// <param name="destination">
        /// Destination DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </param>
        /// <param name="status"> Job Status. </param>
        /// <param name="processedCount"> Processed Count. </param>
        /// <param name="totalCount"> Total Count. </param>
        /// <param name="lastUpdatedUtcOn"> Last Updated Time (ISO-8601 format). </param>
        /// <param name="workerCount"> Worker count. </param>
        /// <param name="error"> Error response for Faulted job. </param>
        /// <param name="duration"> Total Duration of Job. </param>
        /// <param name="mode"> Mode of job execution. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataTransferJobGetResultData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string jobName, DataTransferDataSourceSink source, DataTransferDataSourceSink destination, string status, long? processedCount, long? totalCount, DateTimeOffset? lastUpdatedUtcOn, int? workerCount, CosmosDBErrorResult error, TimeSpan? duration, DataTransferJobMode? mode, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            JobName = jobName;
            Source = source;
            Destination = destination;
            Status = status;
            ProcessedCount = processedCount;
            TotalCount = totalCount;
            LastUpdatedUtcOn = lastUpdatedUtcOn;
            WorkerCount = workerCount;
            Error = error;
            Duration = duration;
            Mode = mode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Job Name. </summary>
        [WirePath("properties.jobName")]
        public string JobName { get; }
        /// <summary>
        /// Source DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </summary>
        [WirePath("properties.source")]
        public DataTransferDataSourceSink Source { get; set; }
        /// <summary>
        /// Destination DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </summary>
        [WirePath("properties.destination")]
        public DataTransferDataSourceSink Destination { get; set; }
        /// <summary> Job Status. </summary>
        [WirePath("properties.status")]
        public string Status { get; }
        /// <summary> Processed Count. </summary>
        [WirePath("properties.processedCount")]
        public long? ProcessedCount { get; }
        /// <summary> Total Count. </summary>
        [WirePath("properties.totalCount")]
        public long? TotalCount { get; }
        /// <summary> Last Updated Time (ISO-8601 format). </summary>
        [WirePath("properties.lastUpdatedUtcTime")]
        public DateTimeOffset? LastUpdatedUtcOn { get; }
        /// <summary> Worker count. </summary>
        [WirePath("properties.workerCount")]
        public int? WorkerCount { get; set; }
        /// <summary> Error response for Faulted job. </summary>
        [WirePath("properties.error")]
        public CosmosDBErrorResult Error { get; }
        /// <summary> Total Duration of Job. </summary>
        [WirePath("properties.duration")]
        public TimeSpan? Duration { get; }
        /// <summary> Mode of job execution. </summary>
        [WirePath("properties.mode")]
        public DataTransferJobMode? Mode { get; set; }
    }
}
