// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CosmosDB.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CosmosDB
{
    /// <summary>
    /// A class representing the CosmosDBThroughputPoolAccount data model.
    /// An Azure Cosmos DB Throughputpool Account
    /// </summary>
    public partial class CosmosDBThroughputPoolAccountData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CosmosDBThroughputPoolAccountData"/>. </summary>
        public CosmosDBThroughputPoolAccountData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBThroughputPoolAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> A provisioning state of the ThroughputPool Account. </param>
        /// <param name="accountResourceIdentifier"> The resource identifier of global database account in the throughputPool. </param>
        /// <param name="accountLocation"> The location of  global database account in the throughputPool. </param>
        /// <param name="accountInstanceId"> The instance id of global database account in the throughputPool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CosmosDBThroughputPoolAccountData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, CosmosDBStatus? provisioningState, ResourceIdentifier accountResourceIdentifier, AzureLocation? accountLocation, string accountInstanceId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            AccountResourceIdentifier = accountResourceIdentifier;
            AccountLocation = accountLocation;
            AccountInstanceId = accountInstanceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A provisioning state of the ThroughputPool Account. </summary>
        [WirePath("properties.provisioningState")]
        public CosmosDBStatus? ProvisioningState { get; set; }
        /// <summary> The resource identifier of global database account in the throughputPool. </summary>
        [WirePath("properties.accountResourceIdentifier")]
        public ResourceIdentifier AccountResourceIdentifier { get; set; }
        /// <summary> The location of  global database account in the throughputPool. </summary>
        [WirePath("properties.accountLocation")]
        public AzureLocation? AccountLocation { get; set; }
        /// <summary> The instance id of global database account in the throughputPool. </summary>
        [WirePath("properties.accountInstanceId")]
        public string AccountInstanceId { get; }
    }
}
