// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.CosmosDB
{
    /// <summary>
    /// A class representing a collection of <see cref="CosmosDBThroughputPoolAccountResource"/> and their operations.
    /// Each <see cref="CosmosDBThroughputPoolAccountResource"/> in the collection will belong to the same instance of <see cref="CosmosDBThroughputPoolResource"/>.
    /// To get a <see cref="CosmosDBThroughputPoolAccountCollection"/> instance call the GetCosmosDBThroughputPoolAccounts method from an instance of <see cref="CosmosDBThroughputPoolResource"/>.
    /// </summary>
    public partial class CosmosDBThroughputPoolAccountCollection : ArmCollection, IEnumerable<CosmosDBThroughputPoolAccountResource>, IAsyncEnumerable<CosmosDBThroughputPoolAccountResource>
    {
        private readonly ClientDiagnostics _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics;
        private readonly ThroughputPoolAccountRestOperations _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient;
        private readonly ClientDiagnostics _cosmosDBThroughputPoolAccountThroughputPoolAccountsClientDiagnostics;
        private readonly ThroughputPoolAccountsRestOperations _cosmosDBThroughputPoolAccountThroughputPoolAccountsRestClient;

        /// <summary> Initializes a new instance of the <see cref="CosmosDBThroughputPoolAccountCollection"/> class for mocking. </summary>
        protected CosmosDBThroughputPoolAccountCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="CosmosDBThroughputPoolAccountCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal CosmosDBThroughputPoolAccountCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CosmosDB", CosmosDBThroughputPoolAccountResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(CosmosDBThroughputPoolAccountResource.ResourceType, out string cosmosDBThroughputPoolAccountThroughputPoolAccountApiVersion);
            _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient = new ThroughputPoolAccountRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, cosmosDBThroughputPoolAccountThroughputPoolAccountApiVersion);
            _cosmosDBThroughputPoolAccountThroughputPoolAccountsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.CosmosDB", CosmosDBThroughputPoolAccountResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(CosmosDBThroughputPoolAccountResource.ResourceType, out string cosmosDBThroughputPoolAccountThroughputPoolAccountsApiVersion);
            _cosmosDBThroughputPoolAccountThroughputPoolAccountsRestClient = new ThroughputPoolAccountsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, cosmosDBThroughputPoolAccountThroughputPoolAccountsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != CosmosDBThroughputPoolResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, CosmosDBThroughputPoolResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates an Azure Cosmos DB ThroughputPool account. The "Update" method is preferred when performing updates on an account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="data"> The parameters to provide for the current ThroughputPoolAccount. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<CosmosDBThroughputPoolAccountResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string throughputPoolAccountName, CosmosDBThroughputPoolAccountData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, data, cancellationToken).ConfigureAwait(false);
                var operation = new CosmosDBArmOperation<CosmosDBThroughputPoolAccountResource>(new CosmosDBThroughputPoolAccountOperationSource(Client), _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics, Pipeline, _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates an Azure Cosmos DB ThroughputPool account. The "Update" method is preferred when performing updates on an account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="data"> The parameters to provide for the current ThroughputPoolAccount. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<CosmosDBThroughputPoolAccountResource> CreateOrUpdate(WaitUntil waitUntil, string throughputPoolAccountName, CosmosDBThroughputPoolAccountData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, data, cancellationToken);
                var operation = new CosmosDBArmOperation<CosmosDBThroughputPoolAccountResource>(new CosmosDBThroughputPoolAccountOperationSource(Client), _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics, Pipeline, _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieves the properties of an existing Azure Cosmos DB Throughput Pool
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> is null. </exception>
        public virtual async Task<Response<CosmosDBThroughputPoolAccountResource>> GetAsync(string throughputPoolAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.Get");
            scope.Start();
            try
            {
                var response = await _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new CosmosDBThroughputPoolAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieves the properties of an existing Azure Cosmos DB Throughput Pool
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> is null. </exception>
        public virtual Response<CosmosDBThroughputPoolAccountResource> Get(string throughputPoolAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.Get");
            scope.Start();
            try
            {
                var response = _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new CosmosDBThroughputPoolAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the Azure Cosmos DB accounts available under the subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccounts_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="CosmosDBThroughputPoolAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<CosmosDBThroughputPoolAccountResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cosmosDBThroughputPoolAccountThroughputPoolAccountsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cosmosDBThroughputPoolAccountThroughputPoolAccountsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new CosmosDBThroughputPoolAccountResource(Client, CosmosDBThroughputPoolAccountData.DeserializeCosmosDBThroughputPoolAccountData(e)), _cosmosDBThroughputPoolAccountThroughputPoolAccountsClientDiagnostics, Pipeline, "CosmosDBThroughputPoolAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the Azure Cosmos DB accounts available under the subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccounts_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="CosmosDBThroughputPoolAccountResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<CosmosDBThroughputPoolAccountResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cosmosDBThroughputPoolAccountThroughputPoolAccountsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cosmosDBThroughputPoolAccountThroughputPoolAccountsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new CosmosDBThroughputPoolAccountResource(Client, CosmosDBThroughputPoolAccountData.DeserializeCosmosDBThroughputPoolAccountData(e)), _cosmosDBThroughputPoolAccountThroughputPoolAccountsClientDiagnostics, Pipeline, "CosmosDBThroughputPoolAccountCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string throughputPoolAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = await _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> is null. </exception>
        public virtual Response<bool> Exists(string throughputPoolAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.Exists");
            scope.Start();
            try
            {
                var response = _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> is null. </exception>
        public virtual async Task<NullableResponse<CosmosDBThroughputPoolAccountResource>> GetIfExistsAsync(string throughputPoolAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<CosmosDBThroughputPoolAccountResource>(response.GetRawResponse());
                return Response.FromValue(new CosmosDBThroughputPoolAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ThroughputPoolAccount_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CosmosDBThroughputPoolAccountResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="throughputPoolAccountName"> Cosmos DB global database account in a Throughput Pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="throughputPoolAccountName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="throughputPoolAccountName"/> is null. </exception>
        public virtual NullableResponse<CosmosDBThroughputPoolAccountResource> GetIfExists(string throughputPoolAccountName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(throughputPoolAccountName, nameof(throughputPoolAccountName));

            using var scope = _cosmosDBThroughputPoolAccountThroughputPoolAccountClientDiagnostics.CreateScope("CosmosDBThroughputPoolAccountCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _cosmosDBThroughputPoolAccountThroughputPoolAccountRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, throughputPoolAccountName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<CosmosDBThroughputPoolAccountResource>(response.GetRawResponse());
                return Response.FromValue(new CosmosDBThroughputPoolAccountResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<CosmosDBThroughputPoolAccountResource> IEnumerable<CosmosDBThroughputPoolAccountResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<CosmosDBThroughputPoolAccountResource> IAsyncEnumerable<CosmosDBThroughputPoolAccountResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
