// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.CosmosDB.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CosmosDB
{
    /// <summary>
    /// A class representing the CosmosDBAccount data model.
    /// An Azure Cosmos DB database account.
    /// </summary>
    public partial class CosmosDBAccountData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountData"/>. </summary>
        /// <param name="location"> The location. </param>
        public CosmosDBAccountData(AzureLocation location) : base(location)
        {
            IPRules = new ChangeTrackingList<CosmosDBIPAddressOrRange>();
            Capabilities = new ChangeTrackingList<CosmosDBAccountCapability>();
            WriteLocations = new ChangeTrackingList<CosmosDBAccountLocation>();
            ReadLocations = new ChangeTrackingList<CosmosDBAccountLocation>();
            Locations = new ChangeTrackingList<CosmosDBAccountLocation>();
            FailoverPolicies = new ChangeTrackingList<CosmosDBFailoverPolicy>();
            VirtualNetworkRules = new ChangeTrackingList<CosmosDBVirtualNetworkRule>();
            PrivateEndpointConnections = new ChangeTrackingList<CosmosDBPrivateEndpointConnectionData>();
            Cors = new ChangeTrackingList<CosmosDBAccountCorsPolicy>();
            NetworkAclBypassResourceIds = new ChangeTrackingList<ResourceIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> Indicates the type of database account. This can only be set at database account creation. </param>
        /// <param name="provisioningState"> The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed. </param>
        /// <param name="documentEndpoint"> The connection endpoint for the Cosmos DB database account. </param>
        /// <param name="databaseAccountOfferType"> The offer type for the Cosmos DB database account. Default value: Standard. </param>
        /// <param name="ipRules"> List of IpRules. </param>
        /// <param name="isVirtualNetworkFilterEnabled"> Flag to indicate whether to enable/disable Virtual Network ACL rules. </param>
        /// <param name="enableAutomaticFailover"> Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account. </param>
        /// <param name="consistencyPolicy"> The consistency policy for the Cosmos DB database account. </param>
        /// <param name="capabilities"> List of Cosmos DB capabilities for the account. </param>
        /// <param name="writeLocations"> An array that contains the write location for the Cosmos DB account. </param>
        /// <param name="readLocations"> An array that contains of the read locations enabled for the Cosmos DB account. </param>
        /// <param name="locations"> An array that contains all of the locations enabled for the Cosmos DB account. </param>
        /// <param name="failoverPolicies"> An array that contains the regions ordered by their failover priorities. </param>
        /// <param name="virtualNetworkRules"> List of Virtual Network ACL rules configured for the Cosmos DB account. </param>
        /// <param name="privateEndpointConnections"> List of Private Endpoint Connections configured for the Cosmos DB account. </param>
        /// <param name="enableMultipleWriteLocations"> Enables the account to write in multiple locations. </param>
        /// <param name="enableCassandraConnector"> Enables the cassandra connector on the Cosmos DB C* account. </param>
        /// <param name="connectorOffer"> The cassandra connector offer type for the Cosmos DB database C* account. </param>
        /// <param name="disableKeyBasedMetadataWriteAccess"> Disable write operations on metadata resources (databases, containers, throughput) via account keys. </param>
        /// <param name="keyVaultKeyUri"> The URI of the key vault. </param>
        /// <param name="defaultIdentity"> The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more. </param>
        /// <param name="publicNetworkAccess"> Whether requests from Public Network are allowed. </param>
        /// <param name="isFreeTierEnabled"> Flag to indicate whether Free Tier is enabled. </param>
        /// <param name="apiProperties"> API specific properties. </param>
        /// <param name="isAnalyticalStorageEnabled"> Flag to indicate whether to enable storage analytics. </param>
        /// <param name="analyticalStorageConfiguration"> Analytical storage specific properties. </param>
        /// <param name="instanceId"> A unique identifier assigned to the database account. </param>
        /// <param name="createMode"> Enum to indicate the mode of account creation. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="backupPolicy">
        /// The object representing the policy for taking backups on an account.
        /// Please note <see cref="CosmosDBAccountBackupPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContinuousModeBackupPolicy"/> and <see cref="PeriodicModeBackupPolicy"/>.
        /// </param>
        /// <param name="cors"> The CORS policy for the Cosmos DB database account. </param>
        /// <param name="networkAclBypass"> Indicates what services are allowed to bypass firewall checks. </param>
        /// <param name="networkAclBypassResourceIds"> An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account. </param>
        /// <param name="diagnosticLogSettings"> The Object representing the different Diagnostic log settings for the Cosmos DB Account. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </param>
        /// <param name="capacity"> The object that represents all properties related to capacity enforcement on an account. </param>
        /// <param name="capacityMode"> Indicates the capacityMode of the Cosmos DB account. </param>
        /// <param name="capacityModeChangeTransitionState"> The object that represents the migration state for the CapacityMode of the Cosmos DB account. </param>
        /// <param name="enableMaterializedViews"> Flag to indicate whether to enable MaterializedViews on the Cosmos DB account. </param>
        /// <param name="keysMetadata"> The object that represents the metadata for the Account Keys of the Cosmos DB account. </param>
        /// <param name="enablePartitionMerge"> Flag to indicate enabling/disabling of Partition Merge feature on the account. </param>
        /// <param name="enableBurstCapacity"> Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account. </param>
        /// <param name="minimalTlsVersion"> Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work with Tls 1.2. </param>
        /// <param name="customerManagedKeyStatus"> Indicates the status of the Customer Managed Key feature on the account. In case there are errors, the property provides troubleshooting guidance. </param>
        /// <param name="enablePriorityBasedExecution"> Flag to indicate enabling/disabling of Priority Based Execution Preview feature on the account. </param>
        /// <param name="defaultPriorityLevel"> Enum to indicate default Priority Level of request for Priority Based Execution. </param>
        /// <param name="enablePerRegionPerPartitionAutoscale"> Flag to indicate enabling/disabling of Per-Region Per-partition autoscale Preview feature on the account. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CosmosDBAccountData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, CosmosDBAccountKind? kind, string provisioningState, string documentEndpoint, CosmosDBAccountOfferType? databaseAccountOfferType, IList<CosmosDBIPAddressOrRange> ipRules, bool? isVirtualNetworkFilterEnabled, bool? enableAutomaticFailover, ConsistencyPolicy consistencyPolicy, IList<CosmosDBAccountCapability> capabilities, IReadOnlyList<CosmosDBAccountLocation> writeLocations, IReadOnlyList<CosmosDBAccountLocation> readLocations, IReadOnlyList<CosmosDBAccountLocation> locations, IReadOnlyList<CosmosDBFailoverPolicy> failoverPolicies, IList<CosmosDBVirtualNetworkRule> virtualNetworkRules, IReadOnlyList<CosmosDBPrivateEndpointConnectionData> privateEndpointConnections, bool? enableMultipleWriteLocations, bool? enableCassandraConnector, ConnectorOffer? connectorOffer, bool? disableKeyBasedMetadataWriteAccess, Uri keyVaultKeyUri, string defaultIdentity, CosmosDBPublicNetworkAccess? publicNetworkAccess, bool? isFreeTierEnabled, ApiProperties apiProperties, bool? isAnalyticalStorageEnabled, AnalyticalStorageConfiguration analyticalStorageConfiguration, Guid? instanceId, CosmosDBAccountCreateMode? createMode, CosmosDBAccountRestoreParameters restoreParameters, CosmosDBAccountBackupPolicy backupPolicy, IList<CosmosDBAccountCorsPolicy> cors, NetworkAclBypass? networkAclBypass, IList<ResourceIdentifier> networkAclBypassResourceIds, DiagnosticLogSettings diagnosticLogSettings, bool? disableLocalAuth, CosmosDBAccountCapacity capacity, CapacityMode? capacityMode, CapacityModeChangeTransitionState capacityModeChangeTransitionState, bool? enableMaterializedViews, DatabaseAccountKeysMetadata keysMetadata, bool? enablePartitionMerge, bool? enableBurstCapacity, CosmosDBMinimalTlsVersion? minimalTlsVersion, string customerManagedKeyStatus, bool? enablePriorityBasedExecution, DefaultPriorityLevel? defaultPriorityLevel, bool? enablePerRegionPerPartitionAutoscale, ManagedServiceIdentity identity, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Kind = kind;
            ProvisioningState = provisioningState;
            DocumentEndpoint = documentEndpoint;
            DatabaseAccountOfferType = databaseAccountOfferType;
            IPRules = ipRules;
            IsVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
            EnableAutomaticFailover = enableAutomaticFailover;
            ConsistencyPolicy = consistencyPolicy;
            Capabilities = capabilities;
            WriteLocations = writeLocations;
            ReadLocations = readLocations;
            Locations = locations;
            FailoverPolicies = failoverPolicies;
            VirtualNetworkRules = virtualNetworkRules;
            PrivateEndpointConnections = privateEndpointConnections;
            EnableMultipleWriteLocations = enableMultipleWriteLocations;
            EnableCassandraConnector = enableCassandraConnector;
            ConnectorOffer = connectorOffer;
            DisableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
            KeyVaultKeyUri = keyVaultKeyUri;
            DefaultIdentity = defaultIdentity;
            PublicNetworkAccess = publicNetworkAccess;
            IsFreeTierEnabled = isFreeTierEnabled;
            ApiProperties = apiProperties;
            IsAnalyticalStorageEnabled = isAnalyticalStorageEnabled;
            AnalyticalStorageConfiguration = analyticalStorageConfiguration;
            InstanceId = instanceId;
            CreateMode = createMode;
            RestoreParameters = restoreParameters;
            BackupPolicy = backupPolicy;
            Cors = cors;
            NetworkAclBypass = networkAclBypass;
            NetworkAclBypassResourceIds = networkAclBypassResourceIds;
            DiagnosticLogSettings = diagnosticLogSettings;
            DisableLocalAuth = disableLocalAuth;
            Capacity = capacity;
            CapacityMode = capacityMode;
            CapacityModeChangeTransitionState = capacityModeChangeTransitionState;
            EnableMaterializedViews = enableMaterializedViews;
            KeysMetadata = keysMetadata;
            EnablePartitionMerge = enablePartitionMerge;
            EnableBurstCapacity = enableBurstCapacity;
            MinimalTlsVersion = minimalTlsVersion;
            CustomerManagedKeyStatus = customerManagedKeyStatus;
            EnablePriorityBasedExecution = enablePriorityBasedExecution;
            DefaultPriorityLevel = defaultPriorityLevel;
            EnablePerRegionPerPartitionAutoscale = enablePerRegionPerPartitionAutoscale;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountData"/> for deserialization. </summary>
        internal CosmosDBAccountData()
        {
        }

        /// <summary> Indicates the type of database account. This can only be set at database account creation. </summary>
        [WirePath("kind")]
        public CosmosDBAccountKind? Kind { get; set; }
        /// <summary> The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed. </summary>
        [WirePath("properties.provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> The connection endpoint for the Cosmos DB database account. </summary>
        [WirePath("properties.documentEndpoint")]
        public string DocumentEndpoint { get; }
        /// <summary> The offer type for the Cosmos DB database account. Default value: Standard. </summary>
        [WirePath("properties.databaseAccountOfferType")]
        public CosmosDBAccountOfferType? DatabaseAccountOfferType { get; }
        /// <summary> List of IpRules. </summary>
        [WirePath("properties.ipRules")]
        public IList<CosmosDBIPAddressOrRange> IPRules { get; }
        /// <summary> Flag to indicate whether to enable/disable Virtual Network ACL rules. </summary>
        [WirePath("properties.isVirtualNetworkFilterEnabled")]
        public bool? IsVirtualNetworkFilterEnabled { get; set; }
        /// <summary> Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account. </summary>
        [WirePath("properties.enableAutomaticFailover")]
        public bool? EnableAutomaticFailover { get; set; }
        /// <summary> The consistency policy for the Cosmos DB database account. </summary>
        [WirePath("properties.consistencyPolicy")]
        public ConsistencyPolicy ConsistencyPolicy { get; set; }
        /// <summary> List of Cosmos DB capabilities for the account. </summary>
        [WirePath("properties.capabilities")]
        public IList<CosmosDBAccountCapability> Capabilities { get; }
        /// <summary> An array that contains the write location for the Cosmos DB account. </summary>
        [WirePath("properties.writeLocations")]
        public IReadOnlyList<CosmosDBAccountLocation> WriteLocations { get; }
        /// <summary> An array that contains of the read locations enabled for the Cosmos DB account. </summary>
        [WirePath("properties.readLocations")]
        public IReadOnlyList<CosmosDBAccountLocation> ReadLocations { get; }
        /// <summary> An array that contains all of the locations enabled for the Cosmos DB account. </summary>
        [WirePath("properties.locations")]
        public IReadOnlyList<CosmosDBAccountLocation> Locations { get; }
        /// <summary> An array that contains the regions ordered by their failover priorities. </summary>
        [WirePath("properties.failoverPolicies")]
        public IReadOnlyList<CosmosDBFailoverPolicy> FailoverPolicies { get; }
        /// <summary> List of Virtual Network ACL rules configured for the Cosmos DB account. </summary>
        [WirePath("properties.virtualNetworkRules")]
        public IList<CosmosDBVirtualNetworkRule> VirtualNetworkRules { get; }
        /// <summary> List of Private Endpoint Connections configured for the Cosmos DB account. </summary>
        [WirePath("properties.privateEndpointConnections")]
        public IReadOnlyList<CosmosDBPrivateEndpointConnectionData> PrivateEndpointConnections { get; }
        /// <summary> Enables the account to write in multiple locations. </summary>
        [WirePath("properties.enableMultipleWriteLocations")]
        public bool? EnableMultipleWriteLocations { get; set; }
        /// <summary> Enables the cassandra connector on the Cosmos DB C* account. </summary>
        [WirePath("properties.enableCassandraConnector")]
        public bool? EnableCassandraConnector { get; set; }
        /// <summary> The cassandra connector offer type for the Cosmos DB database C* account. </summary>
        [WirePath("properties.connectorOffer")]
        public ConnectorOffer? ConnectorOffer { get; set; }
        /// <summary> Disable write operations on metadata resources (databases, containers, throughput) via account keys. </summary>
        [WirePath("properties.disableKeyBasedMetadataWriteAccess")]
        public bool? DisableKeyBasedMetadataWriteAccess { get; set; }
        /// <summary> The URI of the key vault. </summary>
        [WirePath("properties.keyVaultKeyUri")]
        public Uri KeyVaultKeyUri { get; set; }
        /// <summary> The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more. </summary>
        [WirePath("properties.defaultIdentity")]
        public string DefaultIdentity { get; set; }
        /// <summary> Whether requests from Public Network are allowed. </summary>
        [WirePath("properties.publicNetworkAccess")]
        public CosmosDBPublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> Flag to indicate whether Free Tier is enabled. </summary>
        [WirePath("properties.enableFreeTier")]
        public bool? IsFreeTierEnabled { get; set; }
        /// <summary> API specific properties. </summary>
        internal ApiProperties ApiProperties { get; set; }
        /// <summary> Describes the version of the MongoDB account. </summary>
        [WirePath("properties.apiProperties.serverVersion")]
        public CosmosDBServerVersion? ApiServerVersion
        {
            get => ApiProperties is null ? default : ApiProperties.ServerVersion;
            set
            {
                if (ApiProperties is null)
                    ApiProperties = new ApiProperties();
                ApiProperties.ServerVersion = value;
            }
        }

        /// <summary> Flag to indicate whether to enable storage analytics. </summary>
        [WirePath("properties.enableAnalyticalStorage")]
        public bool? IsAnalyticalStorageEnabled { get; set; }
        /// <summary> Analytical storage specific properties. </summary>
        internal AnalyticalStorageConfiguration AnalyticalStorageConfiguration { get; set; }
        /// <summary> Describes the types of schema for analytical storage. </summary>
        [WirePath("properties.analyticalStorageConfiguration.schemaType")]
        public AnalyticalStorageSchemaType? AnalyticalStorageSchemaType
        {
            get => AnalyticalStorageConfiguration is null ? default : AnalyticalStorageConfiguration.SchemaType;
            set
            {
                if (AnalyticalStorageConfiguration is null)
                    AnalyticalStorageConfiguration = new AnalyticalStorageConfiguration();
                AnalyticalStorageConfiguration.SchemaType = value;
            }
        }

        /// <summary> A unique identifier assigned to the database account. </summary>
        [WirePath("properties.instanceId")]
        public Guid? InstanceId { get; }
        /// <summary> Enum to indicate the mode of account creation. </summary>
        [WirePath("properties.createMode")]
        public CosmosDBAccountCreateMode? CreateMode { get; set; }
        /// <summary> Parameters to indicate the information about the restore. </summary>
        [WirePath("properties.restoreParameters")]
        public CosmosDBAccountRestoreParameters RestoreParameters { get; set; }
        /// <summary>
        /// The object representing the policy for taking backups on an account.
        /// Please note <see cref="CosmosDBAccountBackupPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContinuousModeBackupPolicy"/> and <see cref="PeriodicModeBackupPolicy"/>.
        /// </summary>
        [WirePath("properties.backupPolicy")]
        public CosmosDBAccountBackupPolicy BackupPolicy { get; set; }
        /// <summary> The CORS policy for the Cosmos DB database account. </summary>
        [WirePath("properties.cors")]
        public IList<CosmosDBAccountCorsPolicy> Cors { get; }
        /// <summary> Indicates what services are allowed to bypass firewall checks. </summary>
        [WirePath("properties.networkAclBypass")]
        public NetworkAclBypass? NetworkAclBypass { get; set; }
        /// <summary> An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account. </summary>
        [WirePath("properties.networkAclBypassResourceIds")]
        public IList<ResourceIdentifier> NetworkAclBypassResourceIds { get; }
        /// <summary> The Object representing the different Diagnostic log settings for the Cosmos DB Account. </summary>
        internal DiagnosticLogSettings DiagnosticLogSettings { get; set; }
        /// <summary> Describe the level of detail with which queries are to be logged. </summary>
        [WirePath("properties.diagnosticLogSettings.enableFullTextQuery")]
        public EnableFullTextQuery? DiagnosticLogEnableFullTextQuery
        {
            get => DiagnosticLogSettings is null ? default : DiagnosticLogSettings.EnableFullTextQuery;
            set
            {
                if (DiagnosticLogSettings is null)
                    DiagnosticLogSettings = new DiagnosticLogSettings();
                DiagnosticLogSettings.EnableFullTextQuery = value;
            }
        }

        /// <summary> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </summary>
        [WirePath("properties.disableLocalAuth")]
        public bool? DisableLocalAuth { get; set; }
        /// <summary> The object that represents all properties related to capacity enforcement on an account. </summary>
        internal CosmosDBAccountCapacity Capacity { get; set; }
        /// <summary> The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput. </summary>
        [WirePath("properties.capacity.totalThroughputLimit")]
        public int? CapacityTotalThroughputLimit
        {
            get => Capacity is null ? default : Capacity.TotalThroughputLimit;
            set
            {
                if (Capacity is null)
                    Capacity = new CosmosDBAccountCapacity();
                Capacity.TotalThroughputLimit = value;
            }
        }

        /// <summary> Indicates the capacityMode of the Cosmos DB account. </summary>
        [WirePath("properties.capacityMode")]
        public CapacityMode? CapacityMode { get; set; }
        /// <summary> The object that represents the migration state for the CapacityMode of the Cosmos DB account. </summary>
        [WirePath("properties.capacityModeChangeTransitionState")]
        public CapacityModeChangeTransitionState CapacityModeChangeTransitionState { get; set; }
        /// <summary> Flag to indicate whether to enable MaterializedViews on the Cosmos DB account. </summary>
        [WirePath("properties.enableMaterializedViews")]
        public bool? EnableMaterializedViews { get; set; }
        /// <summary> The object that represents the metadata for the Account Keys of the Cosmos DB account. </summary>
        [WirePath("properties.keysMetadata")]
        public DatabaseAccountKeysMetadata KeysMetadata { get; }
        /// <summary> Flag to indicate enabling/disabling of Partition Merge feature on the account. </summary>
        [WirePath("properties.enablePartitionMerge")]
        public bool? EnablePartitionMerge { get; set; }
        /// <summary> Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account. </summary>
        [WirePath("properties.enableBurstCapacity")]
        public bool? EnableBurstCapacity { get; set; }
        /// <summary> Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work with Tls 1.2. </summary>
        [WirePath("properties.minimalTlsVersion")]
        public CosmosDBMinimalTlsVersion? MinimalTlsVersion { get; set; }
        /// <summary> Indicates the status of the Customer Managed Key feature on the account. In case there are errors, the property provides troubleshooting guidance. </summary>
        [WirePath("properties.customerManagedKeyStatus")]
        public string CustomerManagedKeyStatus { get; set; }
        /// <summary> Flag to indicate enabling/disabling of Priority Based Execution Preview feature on the account. </summary>
        [WirePath("properties.enablePriorityBasedExecution")]
        public bool? EnablePriorityBasedExecution { get; set; }
        /// <summary> Enum to indicate default Priority Level of request for Priority Based Execution. </summary>
        [WirePath("properties.defaultPriorityLevel")]
        public DefaultPriorityLevel? DefaultPriorityLevel { get; set; }
        /// <summary> Flag to indicate enabling/disabling of Per-Region Per-partition autoscale Preview feature on the account. </summary>
        [WirePath("properties.enablePerRegionPerPartitionAutoscale")]
        public bool? EnablePerRegionPerPartitionAutoscale { get; set; }
        /// <summary> Identity for the resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
    }
}
