// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.CosmosDB.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CosmosDB
{
    public partial class CosmosDBAccountData : IUtf8JsonSerializable, IJsonModel<CosmosDBAccountData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CosmosDBAccountData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CosmosDBAccountData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CosmosDBAccountData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind.Value.ToString());
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                var serializeOptions = new JsonSerializerOptions { Converters = { new ManagedServiceIdentityTypeV3Converter() } };
                JsonSerializer.Serialize(writer, Identity, serializeOptions);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (options.Format != "W" && Optional.IsDefined(DocumentEndpoint))
            {
                writer.WritePropertyName("documentEndpoint"u8);
                writer.WriteStringValue(DocumentEndpoint);
            }
            if (options.Format != "W" && Optional.IsDefined(DatabaseAccountOfferType))
            {
                writer.WritePropertyName("databaseAccountOfferType"u8);
                writer.WriteStringValue(DatabaseAccountOfferType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(IPRules))
            {
                writer.WritePropertyName("ipRules"u8);
                writer.WriteStartArray();
                foreach (var item in IPRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsVirtualNetworkFilterEnabled))
            {
                writer.WritePropertyName("isVirtualNetworkFilterEnabled"u8);
                writer.WriteBooleanValue(IsVirtualNetworkFilterEnabled.Value);
            }
            if (Optional.IsDefined(EnableAutomaticFailover))
            {
                writer.WritePropertyName("enableAutomaticFailover"u8);
                writer.WriteBooleanValue(EnableAutomaticFailover.Value);
            }
            if (Optional.IsDefined(ConsistencyPolicy))
            {
                writer.WritePropertyName("consistencyPolicy"u8);
                writer.WriteObjectValue(ConsistencyPolicy, options);
            }
            if (Optional.IsCollectionDefined(Capabilities))
            {
                writer.WritePropertyName("capabilities"u8);
                writer.WriteStartArray();
                foreach (var item in Capabilities)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(WriteLocations))
            {
                writer.WritePropertyName("writeLocations"u8);
                writer.WriteStartArray();
                foreach (var item in WriteLocations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ReadLocations))
            {
                writer.WritePropertyName("readLocations"u8);
                writer.WriteStartArray();
                foreach (var item in ReadLocations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Locations))
            {
                writer.WritePropertyName("locations"u8);
                writer.WriteStartArray();
                foreach (var item in Locations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(FailoverPolicies))
            {
                writer.WritePropertyName("failoverPolicies"u8);
                writer.WriteStartArray();
                foreach (var item in FailoverPolicies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VirtualNetworkRules))
            {
                writer.WritePropertyName("virtualNetworkRules"u8);
                writer.WriteStartArray();
                foreach (var item in VirtualNetworkRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                writer.WritePropertyName("privateEndpointConnections"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpointConnections)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(EnableMultipleWriteLocations))
            {
                writer.WritePropertyName("enableMultipleWriteLocations"u8);
                writer.WriteBooleanValue(EnableMultipleWriteLocations.Value);
            }
            if (Optional.IsDefined(EnableCassandraConnector))
            {
                writer.WritePropertyName("enableCassandraConnector"u8);
                writer.WriteBooleanValue(EnableCassandraConnector.Value);
            }
            if (Optional.IsDefined(ConnectorOffer))
            {
                writer.WritePropertyName("connectorOffer"u8);
                writer.WriteStringValue(ConnectorOffer.Value.ToString());
            }
            if (Optional.IsDefined(DisableKeyBasedMetadataWriteAccess))
            {
                writer.WritePropertyName("disableKeyBasedMetadataWriteAccess"u8);
                writer.WriteBooleanValue(DisableKeyBasedMetadataWriteAccess.Value);
            }
            if (Optional.IsDefined(KeyVaultKeyUri))
            {
                writer.WritePropertyName("keyVaultKeyUri"u8);
                writer.WriteStringValue(KeyVaultKeyUri.AbsoluteUri);
            }
            if (Optional.IsDefined(DefaultIdentity))
            {
                writer.WritePropertyName("defaultIdentity"u8);
                writer.WriteStringValue(DefaultIdentity);
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsDefined(IsFreeTierEnabled))
            {
                writer.WritePropertyName("enableFreeTier"u8);
                writer.WriteBooleanValue(IsFreeTierEnabled.Value);
            }
            if (Optional.IsDefined(ApiProperties))
            {
                writer.WritePropertyName("apiProperties"u8);
                writer.WriteObjectValue(ApiProperties, options);
            }
            if (Optional.IsDefined(IsAnalyticalStorageEnabled))
            {
                writer.WritePropertyName("enableAnalyticalStorage"u8);
                writer.WriteBooleanValue(IsAnalyticalStorageEnabled.Value);
            }
            if (Optional.IsDefined(AnalyticalStorageConfiguration))
            {
                writer.WritePropertyName("analyticalStorageConfiguration"u8);
                writer.WriteObjectValue(AnalyticalStorageConfiguration, options);
            }
            if (options.Format != "W" && Optional.IsDefined(InstanceId))
            {
                writer.WritePropertyName("instanceId"u8);
                writer.WriteStringValue(InstanceId.Value);
            }
            if (Optional.IsDefined(CreateMode))
            {
                writer.WritePropertyName("createMode"u8);
                writer.WriteStringValue(CreateMode.Value.ToString());
            }
            if (Optional.IsDefined(RestoreParameters))
            {
                writer.WritePropertyName("restoreParameters"u8);
                writer.WriteObjectValue(RestoreParameters, options);
            }
            if (Optional.IsDefined(BackupPolicy))
            {
                writer.WritePropertyName("backupPolicy"u8);
                writer.WriteObjectValue(BackupPolicy, options);
            }
            if (Optional.IsCollectionDefined(Cors))
            {
                writer.WritePropertyName("cors"u8);
                writer.WriteStartArray();
                foreach (var item in Cors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(NetworkAclBypass))
            {
                writer.WritePropertyName("networkAclBypass"u8);
                writer.WriteStringValue(NetworkAclBypass.Value.ToSerialString());
            }
            if (Optional.IsCollectionDefined(NetworkAclBypassResourceIds))
            {
                writer.WritePropertyName("networkAclBypassResourceIds"u8);
                writer.WriteStartArray();
                foreach (var item in NetworkAclBypassResourceIds)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DiagnosticLogSettings))
            {
                writer.WritePropertyName("diagnosticLogSettings"u8);
                writer.WriteObjectValue(DiagnosticLogSettings, options);
            }
            if (Optional.IsDefined(DisableLocalAuth))
            {
                writer.WritePropertyName("disableLocalAuth"u8);
                writer.WriteBooleanValue(DisableLocalAuth.Value);
            }
            if (Optional.IsDefined(Capacity))
            {
                writer.WritePropertyName("capacity"u8);
                writer.WriteObjectValue(Capacity, options);
            }
            if (Optional.IsDefined(CapacityMode))
            {
                writer.WritePropertyName("capacityMode"u8);
                writer.WriteStringValue(CapacityMode.Value.ToString());
            }
            if (Optional.IsDefined(CapacityModeChangeTransitionState))
            {
                writer.WritePropertyName("capacityModeChangeTransitionState"u8);
                writer.WriteObjectValue(CapacityModeChangeTransitionState, options);
            }
            if (Optional.IsDefined(EnableMaterializedViews))
            {
                writer.WritePropertyName("enableMaterializedViews"u8);
                writer.WriteBooleanValue(EnableMaterializedViews.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(KeysMetadata))
            {
                writer.WritePropertyName("keysMetadata"u8);
                writer.WriteObjectValue(KeysMetadata, options);
            }
            if (Optional.IsDefined(EnablePartitionMerge))
            {
                writer.WritePropertyName("enablePartitionMerge"u8);
                writer.WriteBooleanValue(EnablePartitionMerge.Value);
            }
            if (Optional.IsDefined(EnableBurstCapacity))
            {
                writer.WritePropertyName("enableBurstCapacity"u8);
                writer.WriteBooleanValue(EnableBurstCapacity.Value);
            }
            if (Optional.IsDefined(MinimalTlsVersion))
            {
                writer.WritePropertyName("minimalTlsVersion"u8);
                writer.WriteStringValue(MinimalTlsVersion.Value.ToString());
            }
            if (Optional.IsDefined(CustomerManagedKeyStatus))
            {
                writer.WritePropertyName("customerManagedKeyStatus"u8);
                writer.WriteStringValue(CustomerManagedKeyStatus);
            }
            if (Optional.IsDefined(EnablePriorityBasedExecution))
            {
                writer.WritePropertyName("enablePriorityBasedExecution"u8);
                writer.WriteBooleanValue(EnablePriorityBasedExecution.Value);
            }
            if (Optional.IsDefined(DefaultPriorityLevel))
            {
                writer.WritePropertyName("defaultPriorityLevel"u8);
                writer.WriteStringValue(DefaultPriorityLevel.Value.ToString());
            }
            if (Optional.IsDefined(EnablePerRegionPerPartitionAutoscale))
            {
                writer.WritePropertyName("enablePerRegionPerPartitionAutoscale"u8);
                writer.WriteBooleanValue(EnablePerRegionPerPartitionAutoscale.Value);
            }
            writer.WriteEndObject();
        }

        CosmosDBAccountData IJsonModel<CosmosDBAccountData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CosmosDBAccountData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCosmosDBAccountData(document.RootElement, options);
        }

        internal static CosmosDBAccountData DeserializeCosmosDBAccountData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CosmosDBAccountKind? kind = default;
            ManagedServiceIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string provisioningState = default;
            string documentEndpoint = default;
            CosmosDBAccountOfferType? databaseAccountOfferType = default;
            IList<CosmosDBIPAddressOrRange> ipRules = default;
            bool? isVirtualNetworkFilterEnabled = default;
            bool? enableAutomaticFailover = default;
            ConsistencyPolicy consistencyPolicy = default;
            IList<CosmosDBAccountCapability> capabilities = default;
            IReadOnlyList<CosmosDBAccountLocation> writeLocations = default;
            IReadOnlyList<CosmosDBAccountLocation> readLocations = default;
            IReadOnlyList<CosmosDBAccountLocation> locations = default;
            IReadOnlyList<CosmosDBFailoverPolicy> failoverPolicies = default;
            IList<CosmosDBVirtualNetworkRule> virtualNetworkRules = default;
            IReadOnlyList<CosmosDBPrivateEndpointConnectionData> privateEndpointConnections = default;
            bool? enableMultipleWriteLocations = default;
            bool? enableCassandraConnector = default;
            ConnectorOffer? connectorOffer = default;
            bool? disableKeyBasedMetadataWriteAccess = default;
            Uri keyVaultKeyUri = default;
            string defaultIdentity = default;
            CosmosDBPublicNetworkAccess? publicNetworkAccess = default;
            bool? enableFreeTier = default;
            ApiProperties apiProperties = default;
            bool? enableAnalyticalStorage = default;
            AnalyticalStorageConfiguration analyticalStorageConfiguration = default;
            Guid? instanceId = default;
            CosmosDBAccountCreateMode? createMode = default;
            CosmosDBAccountRestoreParameters restoreParameters = default;
            CosmosDBAccountBackupPolicy backupPolicy = default;
            IList<CosmosDBAccountCorsPolicy> cors = default;
            NetworkAclBypass? networkAclBypass = default;
            IList<ResourceIdentifier> networkAclBypassResourceIds = default;
            DiagnosticLogSettings diagnosticLogSettings = default;
            bool? disableLocalAuth = default;
            CosmosDBAccountCapacity capacity = default;
            CapacityMode? capacityMode = default;
            CapacityModeChangeTransitionState capacityModeChangeTransitionState = default;
            bool? enableMaterializedViews = default;
            DatabaseAccountKeysMetadata keysMetadata = default;
            bool? enablePartitionMerge = default;
            bool? enableBurstCapacity = default;
            CosmosDBMinimalTlsVersion? minimalTlsVersion = default;
            string customerManagedKeyStatus = default;
            bool? enablePriorityBasedExecution = default;
            DefaultPriorityLevel? defaultPriorityLevel = default;
            bool? enablePerRegionPerPartitionAutoscale = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kind = new CosmosDBAccountKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    var serializeOptions = new JsonSerializerOptions { Converters = { new ManagedServiceIdentityTypeV3Converter() } };
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText(), serializeOptions);
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("documentEndpoint"u8))
                        {
                            documentEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("databaseAccountOfferType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            databaseAccountOfferType = new CosmosDBAccountOfferType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("ipRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBIPAddressOrRange> array = new List<CosmosDBIPAddressOrRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBIPAddressOrRange.DeserializeCosmosDBIPAddressOrRange(item, options));
                            }
                            ipRules = array;
                            continue;
                        }
                        if (property0.NameEquals("isVirtualNetworkFilterEnabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isVirtualNetworkFilterEnabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableAutomaticFailover"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableAutomaticFailover = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("consistencyPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            consistencyPolicy = ConsistencyPolicy.DeserializeConsistencyPolicy(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("capabilities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBAccountCapability> array = new List<CosmosDBAccountCapability>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBAccountCapability.DeserializeCosmosDBAccountCapability(item, options));
                            }
                            capabilities = array;
                            continue;
                        }
                        if (property0.NameEquals("writeLocations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBAccountLocation> array = new List<CosmosDBAccountLocation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBAccountLocation.DeserializeCosmosDBAccountLocation(item, options));
                            }
                            writeLocations = array;
                            continue;
                        }
                        if (property0.NameEquals("readLocations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBAccountLocation> array = new List<CosmosDBAccountLocation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBAccountLocation.DeserializeCosmosDBAccountLocation(item, options));
                            }
                            readLocations = array;
                            continue;
                        }
                        if (property0.NameEquals("locations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBAccountLocation> array = new List<CosmosDBAccountLocation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBAccountLocation.DeserializeCosmosDBAccountLocation(item, options));
                            }
                            locations = array;
                            continue;
                        }
                        if (property0.NameEquals("failoverPolicies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBFailoverPolicy> array = new List<CosmosDBFailoverPolicy>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBFailoverPolicy.DeserializeCosmosDBFailoverPolicy(item, options));
                            }
                            failoverPolicies = array;
                            continue;
                        }
                        if (property0.NameEquals("virtualNetworkRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBVirtualNetworkRule> array = new List<CosmosDBVirtualNetworkRule>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBVirtualNetworkRule.DeserializeCosmosDBVirtualNetworkRule(item, options));
                            }
                            virtualNetworkRules = array;
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointConnections"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBPrivateEndpointConnectionData> array = new List<CosmosDBPrivateEndpointConnectionData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBPrivateEndpointConnectionData.DeserializeCosmosDBPrivateEndpointConnectionData(item, options));
                            }
                            privateEndpointConnections = array;
                            continue;
                        }
                        if (property0.NameEquals("enableMultipleWriteLocations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableMultipleWriteLocations = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableCassandraConnector"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableCassandraConnector = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("connectorOffer"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            connectorOffer = new ConnectorOffer(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("disableKeyBasedMetadataWriteAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableKeyBasedMetadataWriteAccess = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("keyVaultKeyUri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            keyVaultKeyUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("defaultIdentity"u8))
                        {
                            defaultIdentity = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccess = new CosmosDBPublicNetworkAccess(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("enableFreeTier"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableFreeTier = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("apiProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            apiProperties = ApiProperties.DeserializeApiProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enableAnalyticalStorage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableAnalyticalStorage = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("analyticalStorageConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            analyticalStorageConfiguration = AnalyticalStorageConfiguration.DeserializeAnalyticalStorageConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("instanceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            instanceId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("createMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createMode = new CosmosDBAccountCreateMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("restoreParameters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            restoreParameters = CosmosDBAccountRestoreParameters.DeserializeCosmosDBAccountRestoreParameters(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("backupPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            backupPolicy = CosmosDBAccountBackupPolicy.DeserializeCosmosDBAccountBackupPolicy(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("cors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CosmosDBAccountCorsPolicy> array = new List<CosmosDBAccountCorsPolicy>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CosmosDBAccountCorsPolicy.DeserializeCosmosDBAccountCorsPolicy(item, options));
                            }
                            cors = array;
                            continue;
                        }
                        if (property0.NameEquals("networkAclBypass"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            networkAclBypass = property0.Value.GetString().ToNetworkAclBypass();
                            continue;
                        }
                        if (property0.NameEquals("networkAclBypassResourceIds"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceIdentifier> array = new List<ResourceIdentifier>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    array.Add(new ResourceIdentifier(item.GetString()));
                                }
                            }
                            networkAclBypassResourceIds = array;
                            continue;
                        }
                        if (property0.NameEquals("diagnosticLogSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            diagnosticLogSettings = DiagnosticLogSettings.DeserializeDiagnosticLogSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("disableLocalAuth"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableLocalAuth = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("capacity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            capacity = CosmosDBAccountCapacity.DeserializeCosmosDBAccountCapacity(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("capacityMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            capacityMode = new CapacityMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("capacityModeChangeTransitionState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            capacityModeChangeTransitionState = CapacityModeChangeTransitionState.DeserializeCapacityModeChangeTransitionState(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enableMaterializedViews"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableMaterializedViews = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("keysMetadata"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            keysMetadata = DatabaseAccountKeysMetadata.DeserializeDatabaseAccountKeysMetadata(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enablePartitionMerge"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enablePartitionMerge = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableBurstCapacity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableBurstCapacity = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("minimalTlsVersion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minimalTlsVersion = new CosmosDBMinimalTlsVersion(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customerManagedKeyStatus"u8))
                        {
                            customerManagedKeyStatus = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enablePriorityBasedExecution"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enablePriorityBasedExecution = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("defaultPriorityLevel"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            defaultPriorityLevel = new DefaultPriorityLevel(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("enablePerRegionPerPartitionAutoscale"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enablePerRegionPerPartitionAutoscale = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CosmosDBAccountData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                kind,
                provisioningState,
                documentEndpoint,
                databaseAccountOfferType,
                ipRules ?? new ChangeTrackingList<CosmosDBIPAddressOrRange>(),
                isVirtualNetworkFilterEnabled,
                enableAutomaticFailover,
                consistencyPolicy,
                capabilities ?? new ChangeTrackingList<CosmosDBAccountCapability>(),
                writeLocations ?? new ChangeTrackingList<CosmosDBAccountLocation>(),
                readLocations ?? new ChangeTrackingList<CosmosDBAccountLocation>(),
                locations ?? new ChangeTrackingList<CosmosDBAccountLocation>(),
                failoverPolicies ?? new ChangeTrackingList<CosmosDBFailoverPolicy>(),
                virtualNetworkRules ?? new ChangeTrackingList<CosmosDBVirtualNetworkRule>(),
                privateEndpointConnections ?? new ChangeTrackingList<CosmosDBPrivateEndpointConnectionData>(),
                enableMultipleWriteLocations,
                enableCassandraConnector,
                connectorOffer,
                disableKeyBasedMetadataWriteAccess,
                keyVaultKeyUri,
                defaultIdentity,
                publicNetworkAccess,
                enableFreeTier,
                apiProperties,
                enableAnalyticalStorage,
                analyticalStorageConfiguration,
                instanceId,
                createMode,
                restoreParameters,
                backupPolicy,
                cors ?? new ChangeTrackingList<CosmosDBAccountCorsPolicy>(),
                networkAclBypass,
                networkAclBypassResourceIds ?? new ChangeTrackingList<ResourceIdentifier>(),
                diagnosticLogSettings,
                disableLocalAuth,
                capacity,
                capacityMode,
                capacityModeChangeTransitionState,
                enableMaterializedViews,
                keysMetadata,
                enablePartitionMerge,
                enableBurstCapacity,
                minimalTlsVersion,
                customerManagedKeyStatus,
                enablePriorityBasedExecution,
                defaultPriorityLevel,
                enablePerRegionPerPartitionAutoscale,
                identity,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Kind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Kind))
                {
                    builder.Append("  kind: ");
                    builder.AppendLine($"'{Kind.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Identity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Identity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Identity, options, 2, false, "  identity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    if (ProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DocumentEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    documentEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DocumentEndpoint))
                {
                    builder.Append("    documentEndpoint: ");
                    if (DocumentEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DocumentEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DocumentEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DatabaseAccountOfferType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    databaseAccountOfferType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DatabaseAccountOfferType))
                {
                    builder.Append("    databaseAccountOfferType: ");
                    builder.AppendLine($"'{DatabaseAccountOfferType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IPRules), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ipRules: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(IPRules))
                {
                    if (IPRules.Any())
                    {
                        builder.Append("    ipRules: ");
                        builder.AppendLine("[");
                        foreach (var item in IPRules)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    ipRules: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsVirtualNetworkFilterEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isVirtualNetworkFilterEnabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsVirtualNetworkFilterEnabled))
                {
                    builder.Append("    isVirtualNetworkFilterEnabled: ");
                    var boolValue = IsVirtualNetworkFilterEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableAutomaticFailover), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableAutomaticFailover: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableAutomaticFailover))
                {
                    builder.Append("    enableAutomaticFailover: ");
                    var boolValue = EnableAutomaticFailover.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConsistencyPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    consistencyPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConsistencyPolicy))
                {
                    builder.Append("    consistencyPolicy: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ConsistencyPolicy, options, 4, false, "    consistencyPolicy: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Capabilities), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    capabilities: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Capabilities))
                {
                    if (Capabilities.Any())
                    {
                        builder.Append("    capabilities: ");
                        builder.AppendLine("[");
                        foreach (var item in Capabilities)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    capabilities: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WriteLocations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    writeLocations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(WriteLocations))
                {
                    if (WriteLocations.Any())
                    {
                        builder.Append("    writeLocations: ");
                        builder.AppendLine("[");
                        foreach (var item in WriteLocations)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    writeLocations: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ReadLocations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    readLocations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ReadLocations))
                {
                    if (ReadLocations.Any())
                    {
                        builder.Append("    readLocations: ");
                        builder.AppendLine("[");
                        foreach (var item in ReadLocations)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    readLocations: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Locations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    locations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Locations))
                {
                    if (Locations.Any())
                    {
                        builder.Append("    locations: ");
                        builder.AppendLine("[");
                        foreach (var item in Locations)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    locations: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FailoverPolicies), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    failoverPolicies: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(FailoverPolicies))
                {
                    if (FailoverPolicies.Any())
                    {
                        builder.Append("    failoverPolicies: ");
                        builder.AppendLine("[");
                        foreach (var item in FailoverPolicies)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    failoverPolicies: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VirtualNetworkRules), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    virtualNetworkRules: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(VirtualNetworkRules))
                {
                    if (VirtualNetworkRules.Any())
                    {
                        builder.Append("    virtualNetworkRules: ");
                        builder.AppendLine("[");
                        foreach (var item in VirtualNetworkRules)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    virtualNetworkRules: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateEndpointConnections), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    privateEndpointConnections: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PrivateEndpointConnections))
                {
                    if (PrivateEndpointConnections.Any())
                    {
                        builder.Append("    privateEndpointConnections: ");
                        builder.AppendLine("[");
                        foreach (var item in PrivateEndpointConnections)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    privateEndpointConnections: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableMultipleWriteLocations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableMultipleWriteLocations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableMultipleWriteLocations))
                {
                    builder.Append("    enableMultipleWriteLocations: ");
                    var boolValue = EnableMultipleWriteLocations.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableCassandraConnector), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableCassandraConnector: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableCassandraConnector))
                {
                    builder.Append("    enableCassandraConnector: ");
                    var boolValue = EnableCassandraConnector.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectorOffer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    connectorOffer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConnectorOffer))
                {
                    builder.Append("    connectorOffer: ");
                    builder.AppendLine($"'{ConnectorOffer.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisableKeyBasedMetadataWriteAccess), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    disableKeyBasedMetadataWriteAccess: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisableKeyBasedMetadataWriteAccess))
                {
                    builder.Append("    disableKeyBasedMetadataWriteAccess: ");
                    var boolValue = DisableKeyBasedMetadataWriteAccess.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KeyVaultKeyUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    keyVaultKeyUri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KeyVaultKeyUri))
                {
                    builder.Append("    keyVaultKeyUri: ");
                    builder.AppendLine($"'{KeyVaultKeyUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultIdentity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    defaultIdentity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultIdentity))
                {
                    builder.Append("    defaultIdentity: ");
                    if (DefaultIdentity.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DefaultIdentity}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DefaultIdentity}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicNetworkAccess), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicNetworkAccess: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublicNetworkAccess))
                {
                    builder.Append("    publicNetworkAccess: ");
                    builder.AppendLine($"'{PublicNetworkAccess.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsFreeTierEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableFreeTier: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsFreeTierEnabled))
                {
                    builder.Append("    enableFreeTier: ");
                    var boolValue = IsFreeTierEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("ApiServerVersion", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    apiProperties: ");
                builder.AppendLine("{");
                builder.AppendLine("      apiProperties: {");
                builder.Append("        serverVersion: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(ApiProperties))
                {
                    builder.Append("    apiProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ApiProperties, options, 4, false, "    apiProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsAnalyticalStorageEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableAnalyticalStorage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsAnalyticalStorageEnabled))
                {
                    builder.Append("    enableAnalyticalStorage: ");
                    var boolValue = IsAnalyticalStorageEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("AnalyticalStorageSchemaType", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    analyticalStorageConfiguration: ");
                builder.AppendLine("{");
                builder.AppendLine("      analyticalStorageConfiguration: {");
                builder.Append("        schemaType: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(AnalyticalStorageConfiguration))
                {
                    builder.Append("    analyticalStorageConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AnalyticalStorageConfiguration, options, 4, false, "    analyticalStorageConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InstanceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    instanceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InstanceId))
                {
                    builder.Append("    instanceId: ");
                    builder.AppendLine($"'{InstanceId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreateMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    createMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreateMode))
                {
                    builder.Append("    createMode: ");
                    builder.AppendLine($"'{CreateMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RestoreParameters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    restoreParameters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RestoreParameters))
                {
                    builder.Append("    restoreParameters: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RestoreParameters, options, 4, false, "    restoreParameters: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BackupPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    backupPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BackupPolicy))
                {
                    builder.Append("    backupPolicy: ");
                    BicepSerializationHelpers.AppendChildObject(builder, BackupPolicy, options, 4, false, "    backupPolicy: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Cors), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    cors: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Cors))
                {
                    if (Cors.Any())
                    {
                        builder.Append("    cors: ");
                        builder.AppendLine("[");
                        foreach (var item in Cors)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    cors: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkAclBypass), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    networkAclBypass: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkAclBypass))
                {
                    builder.Append("    networkAclBypass: ");
                    builder.AppendLine($"'{NetworkAclBypass.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkAclBypassResourceIds), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    networkAclBypassResourceIds: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NetworkAclBypassResourceIds))
                {
                    if (NetworkAclBypassResourceIds.Any())
                    {
                        builder.Append("    networkAclBypassResourceIds: ");
                        builder.AppendLine("[");
                        foreach (var item in NetworkAclBypassResourceIds)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("DiagnosticLogEnableFullTextQuery", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    diagnosticLogSettings: ");
                builder.AppendLine("{");
                builder.AppendLine("      diagnosticLogSettings: {");
                builder.Append("        enableFullTextQuery: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(DiagnosticLogSettings))
                {
                    builder.Append("    diagnosticLogSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DiagnosticLogSettings, options, 4, false, "    diagnosticLogSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisableLocalAuth), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    disableLocalAuth: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisableLocalAuth))
                {
                    builder.Append("    disableLocalAuth: ");
                    var boolValue = DisableLocalAuth.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("CapacityTotalThroughputLimit", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    capacity: ");
                builder.AppendLine("{");
                builder.AppendLine("      capacity: {");
                builder.Append("        totalThroughputLimit: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(Capacity))
                {
                    builder.Append("    capacity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Capacity, options, 4, false, "    capacity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CapacityMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    capacityMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CapacityMode))
                {
                    builder.Append("    capacityMode: ");
                    builder.AppendLine($"'{CapacityMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CapacityModeChangeTransitionState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    capacityModeChangeTransitionState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CapacityModeChangeTransitionState))
                {
                    builder.Append("    capacityModeChangeTransitionState: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CapacityModeChangeTransitionState, options, 4, false, "    capacityModeChangeTransitionState: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableMaterializedViews), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableMaterializedViews: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableMaterializedViews))
                {
                    builder.Append("    enableMaterializedViews: ");
                    var boolValue = EnableMaterializedViews.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KeysMetadata), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    keysMetadata: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KeysMetadata))
                {
                    builder.Append("    keysMetadata: ");
                    BicepSerializationHelpers.AppendChildObject(builder, KeysMetadata, options, 4, false, "    keysMetadata: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnablePartitionMerge), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enablePartitionMerge: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnablePartitionMerge))
                {
                    builder.Append("    enablePartitionMerge: ");
                    var boolValue = EnablePartitionMerge.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableBurstCapacity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableBurstCapacity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableBurstCapacity))
                {
                    builder.Append("    enableBurstCapacity: ");
                    var boolValue = EnableBurstCapacity.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinimalTlsVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    minimalTlsVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinimalTlsVersion))
                {
                    builder.Append("    minimalTlsVersion: ");
                    builder.AppendLine($"'{MinimalTlsVersion.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomerManagedKeyStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customerManagedKeyStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomerManagedKeyStatus))
                {
                    builder.Append("    customerManagedKeyStatus: ");
                    if (CustomerManagedKeyStatus.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CustomerManagedKeyStatus}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CustomerManagedKeyStatus}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnablePriorityBasedExecution), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enablePriorityBasedExecution: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnablePriorityBasedExecution))
                {
                    builder.Append("    enablePriorityBasedExecution: ");
                    var boolValue = EnablePriorityBasedExecution.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultPriorityLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    defaultPriorityLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultPriorityLevel))
                {
                    builder.Append("    defaultPriorityLevel: ");
                    builder.AppendLine($"'{DefaultPriorityLevel.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnablePerRegionPerPartitionAutoscale), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enablePerRegionPerPartitionAutoscale: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnablePerRegionPerPartitionAutoscale))
                {
                    builder.Append("    enablePerRegionPerPartitionAutoscale: ");
                    var boolValue = EnablePerRegionPerPartitionAutoscale.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CosmosDBAccountData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CosmosDBAccountData)} does not support writing '{options.Format}' format.");
            }
        }

        CosmosDBAccountData IPersistableModel<CosmosDBAccountData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCosmosDBAccountData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CosmosDBAccountData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CosmosDBAccountData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
