// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmCosmosDBModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> Indicates the type of database account. This can only be set at database account creation. </param>
        /// <param name="provisioningState"> The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed. </param>
        /// <param name="documentEndpoint"> The connection endpoint for the Cosmos DB database account. </param>
        /// <param name="databaseAccountOfferType"> The offer type for the Cosmos DB database account. Default value: Standard. </param>
        /// <param name="ipRules"> List of IpRules. </param>
        /// <param name="isVirtualNetworkFilterEnabled"> Flag to indicate whether to enable/disable Virtual Network ACL rules. </param>
        /// <param name="enableAutomaticFailover"> Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account. </param>
        /// <param name="consistencyPolicy"> The consistency policy for the Cosmos DB database account. </param>
        /// <param name="capabilities"> List of Cosmos DB capabilities for the account. </param>
        /// <param name="writeLocations"> An array that contains the write location for the Cosmos DB account. </param>
        /// <param name="readLocations"> An array that contains of the read locations enabled for the Cosmos DB account. </param>
        /// <param name="locations"> An array that contains all of the locations enabled for the Cosmos DB account. </param>
        /// <param name="failoverPolicies"> An array that contains the regions ordered by their failover priorities. </param>
        /// <param name="virtualNetworkRules"> List of Virtual Network ACL rules configured for the Cosmos DB account. </param>
        /// <param name="privateEndpointConnections"> List of Private Endpoint Connections configured for the Cosmos DB account. </param>
        /// <param name="enableMultipleWriteLocations"> Enables the account to write in multiple locations. </param>
        /// <param name="enableCassandraConnector"> Enables the cassandra connector on the Cosmos DB C* account. </param>
        /// <param name="connectorOffer"> The cassandra connector offer type for the Cosmos DB database C* account. </param>
        /// <param name="disableKeyBasedMetadataWriteAccess"> Disable write operations on metadata resources (databases, containers, throughput) via account keys. </param>
        /// <param name="keyVaultKeyUri"> The URI of the key vault. </param>
        /// <param name="defaultIdentity"> The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more. </param>
        /// <param name="publicNetworkAccess"> Whether requests from Public Network are allowed. </param>
        /// <param name="isFreeTierEnabled"> Flag to indicate whether Free Tier is enabled. </param>
        /// <param name="apiServerVersion"> API specific properties. </param>
        /// <param name="isAnalyticalStorageEnabled"> Flag to indicate whether to enable storage analytics. </param>
        /// <param name="analyticalStorageSchemaType"> Analytical storage specific properties. </param>
        /// <param name="instanceId"> A unique identifier assigned to the database account. </param>
        /// <param name="createMode"> Enum to indicate the mode of account creation. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="backupPolicy">
        /// The object representing the policy for taking backups on an account.
        /// Please note <see cref="CosmosDBAccountBackupPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContinuousModeBackupPolicy"/> and <see cref="PeriodicModeBackupPolicy"/>.
        /// </param>
        /// <param name="cors"> The CORS policy for the Cosmos DB database account. </param>
        /// <param name="networkAclBypass"> Indicates what services are allowed to bypass firewall checks. </param>
        /// <param name="networkAclBypassResourceIds"> An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account. </param>
        /// <param name="diagnosticLogEnableFullTextQuery"> The Object representing the different Diagnostic log settings for the Cosmos DB Account. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </param>
        /// <param name="capacityTotalThroughputLimit"> The object that represents all properties related to capacity enforcement on an account. </param>
        /// <param name="capacityMode"> Indicates the capacityMode of the Cosmos DB account. </param>
        /// <param name="capacityModeChangeTransitionState"> The object that represents the migration state for the CapacityMode of the Cosmos DB account. </param>
        /// <param name="enableMaterializedViews"> Flag to indicate whether to enable MaterializedViews on the Cosmos DB account. </param>
        /// <param name="keysMetadata"> The object that represents the metadata for the Account Keys of the Cosmos DB account. </param>
        /// <param name="enablePartitionMerge"> Flag to indicate enabling/disabling of Partition Merge feature on the account. </param>
        /// <param name="enableBurstCapacity"> Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account. </param>
        /// <param name="minimalTlsVersion"> Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work with Tls 1.2. </param>
        /// <param name="customerManagedKeyStatus"> Indicates the status of the Customer Managed Key feature on the account. In case there are errors, the property provides troubleshooting guidance. </param>
        /// <param name="enablePriorityBasedExecution"> Flag to indicate enabling/disabling of Priority Based Execution Preview feature on the account. </param>
        /// <param name="defaultPriorityLevel"> Enum to indicate default Priority Level of request for Priority Based Execution. </param>
        /// <param name="enablePerRegionPerPartitionAutoscale"> Flag to indicate enabling/disabling of Per-Region Per-partition autoscale Preview feature on the account. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBAccountData"/> instance for mocking. </returns>
        public static CosmosDBAccountData CosmosDBAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBAccountKind? kind = null, string provisioningState = null, string documentEndpoint = null, CosmosDBAccountOfferType? databaseAccountOfferType = null, IEnumerable<CosmosDBIPAddressOrRange> ipRules = null, bool? isVirtualNetworkFilterEnabled = null, bool? enableAutomaticFailover = null, ConsistencyPolicy consistencyPolicy = null, IEnumerable<CosmosDBAccountCapability> capabilities = null, IEnumerable<CosmosDBAccountLocation> writeLocations = null, IEnumerable<CosmosDBAccountLocation> readLocations = null, IEnumerable<CosmosDBAccountLocation> locations = null, IEnumerable<CosmosDBFailoverPolicy> failoverPolicies = null, IEnumerable<CosmosDBVirtualNetworkRule> virtualNetworkRules = null, IEnumerable<CosmosDBPrivateEndpointConnectionData> privateEndpointConnections = null, bool? enableMultipleWriteLocations = null, bool? enableCassandraConnector = null, ConnectorOffer? connectorOffer = null, bool? disableKeyBasedMetadataWriteAccess = null, Uri keyVaultKeyUri = null, string defaultIdentity = null, CosmosDBPublicNetworkAccess? publicNetworkAccess = null, bool? isFreeTierEnabled = null, CosmosDBServerVersion? apiServerVersion = null, bool? isAnalyticalStorageEnabled = null, AnalyticalStorageSchemaType? analyticalStorageSchemaType = null, Guid? instanceId = null, CosmosDBAccountCreateMode? createMode = null, CosmosDBAccountRestoreParameters restoreParameters = null, CosmosDBAccountBackupPolicy backupPolicy = null, IEnumerable<CosmosDBAccountCorsPolicy> cors = null, NetworkAclBypass? networkAclBypass = null, IEnumerable<ResourceIdentifier> networkAclBypassResourceIds = null, EnableFullTextQuery? diagnosticLogEnableFullTextQuery = null, bool? disableLocalAuth = null, int? capacityTotalThroughputLimit = null, CapacityMode? capacityMode = null, CapacityModeChangeTransitionState capacityModeChangeTransitionState = null, bool? enableMaterializedViews = null, DatabaseAccountKeysMetadata keysMetadata = null, bool? enablePartitionMerge = null, bool? enableBurstCapacity = null, CosmosDBMinimalTlsVersion? minimalTlsVersion = null, string customerManagedKeyStatus = null, bool? enablePriorityBasedExecution = null, DefaultPriorityLevel? defaultPriorityLevel = null, bool? enablePerRegionPerPartitionAutoscale = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();
            ipRules ??= new List<CosmosDBIPAddressOrRange>();
            capabilities ??= new List<CosmosDBAccountCapability>();
            writeLocations ??= new List<CosmosDBAccountLocation>();
            readLocations ??= new List<CosmosDBAccountLocation>();
            locations ??= new List<CosmosDBAccountLocation>();
            failoverPolicies ??= new List<CosmosDBFailoverPolicy>();
            virtualNetworkRules ??= new List<CosmosDBVirtualNetworkRule>();
            privateEndpointConnections ??= new List<CosmosDBPrivateEndpointConnectionData>();
            cors ??= new List<CosmosDBAccountCorsPolicy>();
            networkAclBypassResourceIds ??= new List<ResourceIdentifier>();

            return new CosmosDBAccountData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                provisioningState,
                documentEndpoint,
                databaseAccountOfferType,
                ipRules?.ToList(),
                isVirtualNetworkFilterEnabled,
                enableAutomaticFailover,
                consistencyPolicy,
                capabilities?.ToList(),
                writeLocations?.ToList(),
                readLocations?.ToList(),
                locations?.ToList(),
                failoverPolicies?.ToList(),
                virtualNetworkRules?.ToList(),
                privateEndpointConnections?.ToList(),
                enableMultipleWriteLocations,
                enableCassandraConnector,
                connectorOffer,
                disableKeyBasedMetadataWriteAccess,
                keyVaultKeyUri,
                defaultIdentity,
                publicNetworkAccess,
                isFreeTierEnabled,
                apiServerVersion != null ? new ApiProperties(apiServerVersion, serializedAdditionalRawData: null) : null,
                isAnalyticalStorageEnabled,
                analyticalStorageSchemaType != null ? new AnalyticalStorageConfiguration(analyticalStorageSchemaType, serializedAdditionalRawData: null) : null,
                instanceId,
                createMode,
                restoreParameters,
                backupPolicy,
                cors?.ToList(),
                networkAclBypass,
                networkAclBypassResourceIds?.ToList(),
                diagnosticLogEnableFullTextQuery != null ? new DiagnosticLogSettings(diagnosticLogEnableFullTextQuery, serializedAdditionalRawData: null) : null,
                disableLocalAuth,
                capacityTotalThroughputLimit != null ? new CosmosDBAccountCapacity(capacityTotalThroughputLimit, serializedAdditionalRawData: null) : null,
                capacityMode,
                capacityModeChangeTransitionState,
                enableMaterializedViews,
                keysMetadata,
                enablePartitionMerge,
                enableBurstCapacity,
                minimalTlsVersion,
                customerManagedKeyStatus,
                enablePriorityBasedExecution,
                defaultPriorityLevel,
                enablePerRegionPerPartitionAutoscale,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBAccountLocation"/>. </summary>
        /// <param name="id"> The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;. </param>
        /// <param name="locationName"> The name of the region. </param>
        /// <param name="documentEndpoint"> The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/. </param>
        /// <param name="provisioningState"> The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed. </param>
        /// <param name="failoverPriority"> The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. </param>
        /// <param name="isZoneRedundant"> Flag to indicate whether or not this region is an AvailabilityZone region. </param>
        /// <returns> A new <see cref="Models.CosmosDBAccountLocation"/> instance for mocking. </returns>
        public static CosmosDBAccountLocation CosmosDBAccountLocation(string id = null, AzureLocation? locationName = null, string documentEndpoint = null, string provisioningState = null, int? failoverPriority = null, bool? isZoneRedundant = null)
        {
            return new CosmosDBAccountLocation(
                id,
                locationName,
                documentEndpoint,
                provisioningState,
                failoverPriority,
                isZoneRedundant,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBFailoverPolicy"/>. </summary>
        /// <param name="id"> The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;. </param>
        /// <param name="locationName"> The name of the region in which the database account exists. </param>
        /// <param name="failoverPriority"> The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. </param>
        /// <returns> A new <see cref="Models.CosmosDBFailoverPolicy"/> instance for mocking. </returns>
        public static CosmosDBFailoverPolicy CosmosDBFailoverPolicy(string id = null, AzureLocation? locationName = null, int? failoverPriority = null)
        {
            return new CosmosDBFailoverPolicy(id, locationName, failoverPriority, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> Private endpoint which the connection belongs to. </param>
        /// <param name="connectionState"> Connection State of the Private Endpoint Connection. </param>
        /// <param name="groupId"> Group id of the private endpoint. </param>
        /// <param name="provisioningState"> Provisioning state of the private endpoint. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static CosmosDBPrivateEndpointConnectionData CosmosDBPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, CosmosDBPrivateLinkServiceConnectionStateProperty connectionState = null, string groupId = null, string provisioningState = null)
        {
            return new CosmosDBPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? new PrivateEndpointProperty(privateEndpointId, serializedAdditionalRawData: null) : null,
                connectionState,
                groupId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBPrivateLinkServiceConnectionStateProperty"/>. </summary>
        /// <param name="status"> The private link service connection status. </param>
        /// <param name="description"> The private link service connection description. </param>
        /// <param name="actionsRequired"> Any action that is required beyond basic workflow (approve/ reject/ disconnect). </param>
        /// <returns> A new <see cref="Models.CosmosDBPrivateLinkServiceConnectionStateProperty"/> instance for mocking. </returns>
        public static CosmosDBPrivateLinkServiceConnectionStateProperty CosmosDBPrivateLinkServiceConnectionStateProperty(string status = null, string description = null, string actionsRequired = null)
        {
            return new CosmosDBPrivateLinkServiceConnectionStateProperty(status, description, actionsRequired, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CapacityModeChangeTransitionState"/>. </summary>
        /// <param name="capacityModeTransitionStatus"> The transition status of capacity mode. </param>
        /// <param name="currentCapacityMode"> Indicates the current capacity mode of the account. </param>
        /// <param name="previousCapacityMode"> Indicates the previous capacity mode of the account before successful transition. </param>
        /// <param name="capacityModeTransitionBeginTimestamp"> Begin time in UTC of the capacity mode change. </param>
        /// <param name="capacityModeTransitionEndTimestamp"> End time in UTC of the capacity mode change. </param>
        /// <param name="capacityModeLastSuccessfulTransitionEndTimestamp"> End time in UTC of the last successful capacity mode change. </param>
        /// <returns> A new <see cref="Models.CapacityModeChangeTransitionState"/> instance for mocking. </returns>
        public static CapacityModeChangeTransitionState CapacityModeChangeTransitionState(CapacityModeTransitionStatus? capacityModeTransitionStatus = null, CapacityMode? currentCapacityMode = null, CapacityMode? previousCapacityMode = null, DateTimeOffset? capacityModeTransitionBeginTimestamp = null, DateTimeOffset? capacityModeTransitionEndTimestamp = null, DateTimeOffset? capacityModeLastSuccessfulTransitionEndTimestamp = null)
        {
            return new CapacityModeChangeTransitionState(
                capacityModeTransitionStatus,
                currentCapacityMode,
                previousCapacityMode,
                capacityModeTransitionBeginTimestamp,
                capacityModeTransitionEndTimestamp,
                capacityModeLastSuccessfulTransitionEndTimestamp,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseAccountKeysMetadata"/>. </summary>
        /// <param name="primaryMasterKeyGeneratedOn"> The metadata related to the Primary Read-Write Key for the given Cosmos DB database account. </param>
        /// <param name="secondaryMasterKeyGeneratedOn"> The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account. </param>
        /// <param name="primaryReadonlyMasterKeyGeneratedOn"> The metadata related to the Primary Read-Only Key for the given Cosmos DB database account. </param>
        /// <param name="secondaryReadonlyMasterKeyGeneratedOn"> The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account. </param>
        /// <returns> A new <see cref="Models.DatabaseAccountKeysMetadata"/> instance for mocking. </returns>
        public static DatabaseAccountKeysMetadata DatabaseAccountKeysMetadata(DateTimeOffset? primaryMasterKeyGeneratedOn = null, DateTimeOffset? secondaryMasterKeyGeneratedOn = null, DateTimeOffset? primaryReadonlyMasterKeyGeneratedOn = null, DateTimeOffset? secondaryReadonlyMasterKeyGeneratedOn = null)
        {
            return new DatabaseAccountKeysMetadata(primaryMasterKeyGeneratedOn != null ? new AccountKeyMetadata(primaryMasterKeyGeneratedOn, serializedAdditionalRawData: null) : null, secondaryMasterKeyGeneratedOn != null ? new AccountKeyMetadata(secondaryMasterKeyGeneratedOn, serializedAdditionalRawData: null) : null, primaryReadonlyMasterKeyGeneratedOn != null ? new AccountKeyMetadata(primaryReadonlyMasterKeyGeneratedOn, serializedAdditionalRawData: null) : null, secondaryReadonlyMasterKeyGeneratedOn != null ? new AccountKeyMetadata(secondaryReadonlyMasterKeyGeneratedOn, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBAccountPatch"/>. </summary>
        /// <param name="tags"> Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB". </param>
        /// <param name="location"> The location of the resource group to which the resource belongs. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <param name="consistencyPolicy"> The consistency policy for the Cosmos DB account. </param>
        /// <param name="locations"> An array that contains the georeplication locations enabled for the Cosmos DB account. </param>
        /// <param name="ipRules"> List of IpRules. </param>
        /// <param name="isVirtualNetworkFilterEnabled"> Flag to indicate whether to enable/disable Virtual Network ACL rules. </param>
        /// <param name="enableAutomaticFailover"> Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account. </param>
        /// <param name="capabilities"> List of Cosmos DB capabilities for the account. </param>
        /// <param name="virtualNetworkRules"> List of Virtual Network ACL rules configured for the Cosmos DB account. </param>
        /// <param name="enableMultipleWriteLocations"> Enables the account to write in multiple locations. </param>
        /// <param name="enableCassandraConnector"> Enables the cassandra connector on the Cosmos DB C* account. </param>
        /// <param name="connectorOffer"> The cassandra connector offer type for the Cosmos DB database C* account. </param>
        /// <param name="disableKeyBasedMetadataWriteAccess"> Disable write operations on metadata resources (databases, containers, throughput) via account keys. </param>
        /// <param name="keyVaultKeyUri"> The URI of the key vault. </param>
        /// <param name="defaultIdentity"> The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more. </param>
        /// <param name="publicNetworkAccess"> Whether requests from Public Network are allowed. </param>
        /// <param name="isFreeTierEnabled"> Flag to indicate whether Free Tier is enabled. </param>
        /// <param name="apiServerVersion"> API specific properties. Currently, supported only for MongoDB API. </param>
        /// <param name="isAnalyticalStorageEnabled"> Flag to indicate whether to enable storage analytics. </param>
        /// <param name="analyticalStorageSchemaType"> Analytical storage specific properties. </param>
        /// <param name="backupPolicy">
        /// The object representing the policy for taking backups on an account.
        /// Please note <see cref="CosmosDBAccountBackupPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContinuousModeBackupPolicy"/> and <see cref="PeriodicModeBackupPolicy"/>.
        /// </param>
        /// <param name="cors"> The CORS policy for the Cosmos DB database account. </param>
        /// <param name="networkAclBypass"> Indicates what services are allowed to bypass firewall checks. </param>
        /// <param name="networkAclBypassResourceIds"> An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account. </param>
        /// <param name="diagnosticLogEnableFullTextQuery"> The Object representing the different Diagnostic log settings for the Cosmos DB Account. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </param>
        /// <param name="capacityTotalThroughputLimit"> The object that represents all properties related to capacity enforcement on an account. </param>
        /// <param name="capacityMode"> Indicates the capacityMode of the Cosmos DB account. </param>
        /// <param name="enableMaterializedViews"> Flag to indicate whether to enable MaterializedViews on the Cosmos DB account. </param>
        /// <param name="keysMetadata"> This property is ignored during the update operation, as the metadata is read-only. The object represents the metadata for the Account Keys of the Cosmos DB account. </param>
        /// <param name="enablePartitionMerge"> Flag to indicate enabling/disabling of Partition Merge feature on the account. </param>
        /// <param name="enableBurstCapacity"> Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account. </param>
        /// <param name="minimalTlsVersion"> Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work with Tls 1.2. </param>
        /// <param name="customerManagedKeyStatus"> Indicates the status of the Customer Managed Key feature on the account. In case there are errors, the property provides troubleshooting guidance. </param>
        /// <param name="enablePriorityBasedExecution"> Flag to indicate enabling/disabling of Priority Based Execution Preview feature on the account. </param>
        /// <param name="defaultPriorityLevel"> Enum to indicate default Priority Level of request for Priority Based Execution. </param>
        /// <param name="enablePerRegionPerPartitionAutoscale"> Flag to indicate enabling/disabling of Per-Region Per-partition autoscale Preview feature on the account. </param>
        /// <returns> A new <see cref="Models.CosmosDBAccountPatch"/> instance for mocking. </returns>
        public static CosmosDBAccountPatch CosmosDBAccountPatch(IDictionary<string, string> tags = null, AzureLocation? location = null, ManagedServiceIdentity identity = null, ConsistencyPolicy consistencyPolicy = null, IEnumerable<CosmosDBAccountLocation> locations = null, IEnumerable<CosmosDBIPAddressOrRange> ipRules = null, bool? isVirtualNetworkFilterEnabled = null, bool? enableAutomaticFailover = null, IEnumerable<CosmosDBAccountCapability> capabilities = null, IEnumerable<CosmosDBVirtualNetworkRule> virtualNetworkRules = null, bool? enableMultipleWriteLocations = null, bool? enableCassandraConnector = null, ConnectorOffer? connectorOffer = null, bool? disableKeyBasedMetadataWriteAccess = null, Uri keyVaultKeyUri = null, string defaultIdentity = null, CosmosDBPublicNetworkAccess? publicNetworkAccess = null, bool? isFreeTierEnabled = null, CosmosDBServerVersion? apiServerVersion = null, bool? isAnalyticalStorageEnabled = null, AnalyticalStorageSchemaType? analyticalStorageSchemaType = null, CosmosDBAccountBackupPolicy backupPolicy = null, IEnumerable<CosmosDBAccountCorsPolicy> cors = null, NetworkAclBypass? networkAclBypass = null, IEnumerable<ResourceIdentifier> networkAclBypassResourceIds = null, EnableFullTextQuery? diagnosticLogEnableFullTextQuery = null, bool? disableLocalAuth = null, int? capacityTotalThroughputLimit = null, CapacityMode? capacityMode = null, bool? enableMaterializedViews = null, DatabaseAccountKeysMetadata keysMetadata = null, bool? enablePartitionMerge = null, bool? enableBurstCapacity = null, CosmosDBMinimalTlsVersion? minimalTlsVersion = null, string customerManagedKeyStatus = null, bool? enablePriorityBasedExecution = null, DefaultPriorityLevel? defaultPriorityLevel = null, bool? enablePerRegionPerPartitionAutoscale = null)
        {
            tags ??= new Dictionary<string, string>();
            locations ??= new List<CosmosDBAccountLocation>();
            ipRules ??= new List<CosmosDBIPAddressOrRange>();
            capabilities ??= new List<CosmosDBAccountCapability>();
            virtualNetworkRules ??= new List<CosmosDBVirtualNetworkRule>();
            cors ??= new List<CosmosDBAccountCorsPolicy>();
            networkAclBypassResourceIds ??= new List<ResourceIdentifier>();

            return new CosmosDBAccountPatch(
                tags,
                location,
                identity,
                consistencyPolicy,
                locations?.ToList(),
                ipRules?.ToList(),
                isVirtualNetworkFilterEnabled,
                enableAutomaticFailover,
                capabilities?.ToList(),
                virtualNetworkRules?.ToList(),
                enableMultipleWriteLocations,
                enableCassandraConnector,
                connectorOffer,
                disableKeyBasedMetadataWriteAccess,
                keyVaultKeyUri,
                defaultIdentity,
                publicNetworkAccess,
                isFreeTierEnabled,
                apiServerVersion != null ? new ApiProperties(apiServerVersion, serializedAdditionalRawData: null) : null,
                isAnalyticalStorageEnabled,
                analyticalStorageSchemaType != null ? new AnalyticalStorageConfiguration(analyticalStorageSchemaType, serializedAdditionalRawData: null) : null,
                backupPolicy,
                cors?.ToList(),
                networkAclBypass,
                networkAclBypassResourceIds?.ToList(),
                diagnosticLogEnableFullTextQuery != null ? new DiagnosticLogSettings(diagnosticLogEnableFullTextQuery, serializedAdditionalRawData: null) : null,
                disableLocalAuth,
                capacityTotalThroughputLimit != null ? new CosmosDBAccountCapacity(capacityTotalThroughputLimit, serializedAdditionalRawData: null) : null,
                capacityMode,
                enableMaterializedViews,
                keysMetadata,
                enablePartitionMerge,
                enableBurstCapacity,
                minimalTlsVersion,
                customerManagedKeyStatus,
                enablePriorityBasedExecution,
                defaultPriorityLevel,
                enablePerRegionPerPartitionAutoscale,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBAccountCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> Indicates the type of database account. This can only be set at database account creation. </param>
        /// <param name="consistencyPolicy"> The consistency policy for the Cosmos DB account. </param>
        /// <param name="locations"> An array that contains the georeplication locations enabled for the Cosmos DB account. </param>
        /// <param name="databaseAccountOfferType"> The offer type for the database. </param>
        /// <param name="ipRules"> List of IpRules. </param>
        /// <param name="isVirtualNetworkFilterEnabled"> Flag to indicate whether to enable/disable Virtual Network ACL rules. </param>
        /// <param name="enableAutomaticFailover"> Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account. </param>
        /// <param name="capabilities"> List of Cosmos DB capabilities for the account. </param>
        /// <param name="virtualNetworkRules"> List of Virtual Network ACL rules configured for the Cosmos DB account. </param>
        /// <param name="enableMultipleWriteLocations"> Enables the account to write in multiple locations. </param>
        /// <param name="enableCassandraConnector"> Enables the cassandra connector on the Cosmos DB C* account. </param>
        /// <param name="connectorOffer"> The cassandra connector offer type for the Cosmos DB database C* account. </param>
        /// <param name="disableKeyBasedMetadataWriteAccess"> Disable write operations on metadata resources (databases, containers, throughput) via account keys. </param>
        /// <param name="keyVaultKeyUri"> The URI of the key vault. </param>
        /// <param name="defaultIdentity"> The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more. </param>
        /// <param name="publicNetworkAccess"> Whether requests from Public Network are allowed. </param>
        /// <param name="isFreeTierEnabled"> Flag to indicate whether Free Tier is enabled. </param>
        /// <param name="apiServerVersion"> API specific properties. Currently, supported only for MongoDB API. </param>
        /// <param name="isAnalyticalStorageEnabled"> Flag to indicate whether to enable storage analytics. </param>
        /// <param name="analyticalStorageSchemaType"> Analytical storage specific properties. </param>
        /// <param name="createMode"> Enum to indicate the mode of account creation. </param>
        /// <param name="backupPolicy">
        /// The object representing the policy for taking backups on an account.
        /// Please note <see cref="CosmosDBAccountBackupPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ContinuousModeBackupPolicy"/> and <see cref="PeriodicModeBackupPolicy"/>.
        /// </param>
        /// <param name="cors"> The CORS policy for the Cosmos DB database account. </param>
        /// <param name="networkAclBypass"> Indicates what services are allowed to bypass firewall checks. </param>
        /// <param name="networkAclBypassResourceIds"> An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account. </param>
        /// <param name="diagnosticLogEnableFullTextQuery"> The Object representing the different Diagnostic log settings for the Cosmos DB Account. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="capacityTotalThroughputLimit"> The object that represents all properties related to capacity enforcement on an account. </param>
        /// <param name="capacityMode"> Indicates the capacityMode of the Cosmos DB account. </param>
        /// <param name="enableMaterializedViews"> Flag to indicate whether to enable MaterializedViews on the Cosmos DB account. </param>
        /// <param name="keysMetadata"> This property is ignored during the update/create operation, as the metadata is read-only. The object represents the metadata for the Account Keys of the Cosmos DB account. </param>
        /// <param name="enablePartitionMerge"> Flag to indicate enabling/disabling of Partition Merge feature on the account. </param>
        /// <param name="enableBurstCapacity"> Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account. </param>
        /// <param name="minimalTlsVersion"> Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work with Tls 1.2. </param>
        /// <param name="customerManagedKeyStatus"> Indicates the status of the Customer Managed Key feature on the account. In case there are errors, the property provides troubleshooting guidance. </param>
        /// <param name="enablePriorityBasedExecution"> Flag to indicate enabling/disabling of Priority Based Execution Preview feature on the account. </param>
        /// <param name="defaultPriorityLevel"> Enum to indicate default Priority Level of request for Priority Based Execution. </param>
        /// <param name="enablePerRegionPerPartitionAutoscale"> Flag to indicate enabling/disabling of Per-Region Per-partition autoscale Preview feature on the account. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBAccountCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBAccountCreateOrUpdateContent CosmosDBAccountCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBAccountKind? kind = null, ConsistencyPolicy consistencyPolicy = null, IEnumerable<CosmosDBAccountLocation> locations = null, CosmosDBAccountOfferType databaseAccountOfferType = default, IEnumerable<CosmosDBIPAddressOrRange> ipRules = null, bool? isVirtualNetworkFilterEnabled = null, bool? enableAutomaticFailover = null, IEnumerable<CosmosDBAccountCapability> capabilities = null, IEnumerable<CosmosDBVirtualNetworkRule> virtualNetworkRules = null, bool? enableMultipleWriteLocations = null, bool? enableCassandraConnector = null, ConnectorOffer? connectorOffer = null, bool? disableKeyBasedMetadataWriteAccess = null, Uri keyVaultKeyUri = null, string defaultIdentity = null, CosmosDBPublicNetworkAccess? publicNetworkAccess = null, bool? isFreeTierEnabled = null, CosmosDBServerVersion? apiServerVersion = null, bool? isAnalyticalStorageEnabled = null, AnalyticalStorageSchemaType? analyticalStorageSchemaType = null, CosmosDBAccountCreateMode? createMode = null, CosmosDBAccountBackupPolicy backupPolicy = null, IEnumerable<CosmosDBAccountCorsPolicy> cors = null, NetworkAclBypass? networkAclBypass = null, IEnumerable<ResourceIdentifier> networkAclBypassResourceIds = null, EnableFullTextQuery? diagnosticLogEnableFullTextQuery = null, bool? disableLocalAuth = null, CosmosDBAccountRestoreParameters restoreParameters = null, int? capacityTotalThroughputLimit = null, CapacityMode? capacityMode = null, bool? enableMaterializedViews = null, DatabaseAccountKeysMetadata keysMetadata = null, bool? enablePartitionMerge = null, bool? enableBurstCapacity = null, CosmosDBMinimalTlsVersion? minimalTlsVersion = null, string customerManagedKeyStatus = null, bool? enablePriorityBasedExecution = null, DefaultPriorityLevel? defaultPriorityLevel = null, bool? enablePerRegionPerPartitionAutoscale = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();
            locations ??= new List<CosmosDBAccountLocation>();
            ipRules ??= new List<CosmosDBIPAddressOrRange>();
            capabilities ??= new List<CosmosDBAccountCapability>();
            virtualNetworkRules ??= new List<CosmosDBVirtualNetworkRule>();
            cors ??= new List<CosmosDBAccountCorsPolicy>();
            networkAclBypassResourceIds ??= new List<ResourceIdentifier>();

            return new CosmosDBAccountCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                consistencyPolicy,
                locations?.ToList(),
                databaseAccountOfferType,
                ipRules?.ToList(),
                isVirtualNetworkFilterEnabled,
                enableAutomaticFailover,
                capabilities?.ToList(),
                virtualNetworkRules?.ToList(),
                enableMultipleWriteLocations,
                enableCassandraConnector,
                connectorOffer,
                disableKeyBasedMetadataWriteAccess,
                keyVaultKeyUri,
                defaultIdentity,
                publicNetworkAccess,
                isFreeTierEnabled,
                apiServerVersion != null ? new ApiProperties(apiServerVersion, serializedAdditionalRawData: null) : null,
                isAnalyticalStorageEnabled,
                analyticalStorageSchemaType != null ? new AnalyticalStorageConfiguration(analyticalStorageSchemaType, serializedAdditionalRawData: null) : null,
                createMode,
                backupPolicy,
                cors?.ToList(),
                networkAclBypass,
                networkAclBypassResourceIds?.ToList(),
                diagnosticLogEnableFullTextQuery != null ? new DiagnosticLogSettings(diagnosticLogEnableFullTextQuery, serializedAdditionalRawData: null) : null,
                disableLocalAuth,
                restoreParameters,
                capacityTotalThroughputLimit != null ? new CosmosDBAccountCapacity(capacityTotalThroughputLimit, serializedAdditionalRawData: null) : null,
                capacityMode,
                enableMaterializedViews,
                keysMetadata,
                enablePartitionMerge,
                enableBurstCapacity,
                minimalTlsVersion,
                customerManagedKeyStatus,
                enablePriorityBasedExecution,
                defaultPriorityLevel,
                enablePerRegionPerPartitionAutoscale,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBAccountKeyList"/>. </summary>
        /// <param name="primaryReadonlyMasterKey"> Base 64 encoded value of the primary read-only key. </param>
        /// <param name="secondaryReadonlyMasterKey"> Base 64 encoded value of the secondary read-only key. </param>
        /// <param name="primaryMasterKey"> Base 64 encoded value of the primary read-write key. </param>
        /// <param name="secondaryMasterKey"> Base 64 encoded value of the secondary read-write key. </param>
        /// <returns> A new <see cref="Models.CosmosDBAccountKeyList"/> instance for mocking. </returns>
        public static CosmosDBAccountKeyList CosmosDBAccountKeyList(string primaryReadonlyMasterKey = null, string secondaryReadonlyMasterKey = null, string primaryMasterKey = null, string secondaryMasterKey = null)
        {
            return new CosmosDBAccountKeyList(primaryReadonlyMasterKey, secondaryReadonlyMasterKey, serializedAdditionalRawData: null, primaryMasterKey, secondaryMasterKey);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBAccountReadOnlyKeyList"/>. </summary>
        /// <param name="primaryReadonlyMasterKey"> Base 64 encoded value of the primary read-only key. </param>
        /// <param name="secondaryReadonlyMasterKey"> Base 64 encoded value of the secondary read-only key. </param>
        /// <returns> A new <see cref="Models.CosmosDBAccountReadOnlyKeyList"/> instance for mocking. </returns>
        public static CosmosDBAccountReadOnlyKeyList CosmosDBAccountReadOnlyKeyList(string primaryReadonlyMasterKey = null, string secondaryReadonlyMasterKey = null)
        {
            return new CosmosDBAccountReadOnlyKeyList(primaryReadonlyMasterKey, secondaryReadonlyMasterKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBAccountConnectionString"/>. </summary>
        /// <param name="connectionString"> Value of the connection string. </param>
        /// <param name="description"> Description of the connection string. </param>
        /// <param name="keyKind"> Kind of the connection string key. </param>
        /// <param name="keyType"> Type of the connection string. </param>
        /// <returns> A new <see cref="Models.CosmosDBAccountConnectionString"/> instance for mocking. </returns>
        public static CosmosDBAccountConnectionString CosmosDBAccountConnectionString(string connectionString = null, string description = null, CosmosDBKind? keyKind = null, CosmosDBType? keyType = null)
        {
            return new CosmosDBAccountConnectionString(connectionString, description, keyKind, keyType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBErrorResult"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message indicating why the operation failed. </param>
        /// <returns> A new <see cref="Models.CosmosDBErrorResult"/> instance for mocking. </returns>
        public static CosmosDBErrorResult CosmosDBErrorResult(string code = null, string message = null)
        {
            return new CosmosDBErrorResult(code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBBaseMetric"/>. </summary>
        /// <param name="startOn"> The start time for the metric (ISO-8601 format). </param>
        /// <param name="endOn"> The end time for the metric (ISO-8601 format). </param>
        /// <param name="timeGrain"> The time grain to be used to summarize the metric values. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="metricValues"> The metric values for the specified time window and timestep. </param>
        /// <returns> A new <see cref="Models.CosmosDBBaseMetric"/> instance for mocking. </returns>
        public static CosmosDBBaseMetric CosmosDBBaseMetric(DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string timeGrain = null, CosmosDBMetricUnitType? unit = null, CosmosDBMetricName name = null, IEnumerable<CosmosDBMetricValue> metricValues = null)
        {
            metricValues ??= new List<CosmosDBMetricValue>();

            return new CosmosDBBaseMetric(
                startOn,
                endOn,
                timeGrain,
                unit,
                name,
                metricValues?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBMetricName"/>. </summary>
        /// <param name="value"> The name of the metric. </param>
        /// <param name="localizedValue"> The friendly name of the metric. </param>
        /// <returns> A new <see cref="Models.CosmosDBMetricName"/> instance for mocking. </returns>
        public static CosmosDBMetricName CosmosDBMetricName(string value = null, string localizedValue = null)
        {
            return new CosmosDBMetricName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBMetricValue"/>. </summary>
        /// <param name="count"> The number of values for the metric. </param>
        /// <param name="average"> The average value of the metric. </param>
        /// <param name="maximum"> The max value of the metric. </param>
        /// <param name="minimum"> The min value of the metric. </param>
        /// <param name="timestamp"> The metric timestamp (ISO-8601 format). </param>
        /// <param name="total"> The total value of the metric. </param>
        /// <returns> A new <see cref="Models.CosmosDBMetricValue"/> instance for mocking. </returns>
        public static CosmosDBMetricValue CosmosDBMetricValue(int? count = null, double? average = null, double? maximum = null, double? minimum = null, DateTimeOffset? timestamp = null, double? total = null)
        {
            return new CosmosDBMetricValue(
                count,
                average,
                maximum,
                minimum,
                timestamp,
                total,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBPercentileMetric"/>. </summary>
        /// <param name="startOn"> The start time for the metric (ISO-8601 format). </param>
        /// <param name="endOn"> The end time for the metric (ISO-8601 format). </param>
        /// <param name="timeGrain"> The time grain to be used to summarize the metric values. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="metricValues"> The percentile metric values for the specified time window and timestep. </param>
        /// <returns> A new <see cref="Models.CosmosDBPercentileMetric"/> instance for mocking. </returns>
        public static CosmosDBPercentileMetric CosmosDBPercentileMetric(DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string timeGrain = null, CosmosDBMetricUnitType? unit = null, CosmosDBMetricName name = null, IEnumerable<PercentileMetricValue> metricValues = null)
        {
            metricValues ??= new List<PercentileMetricValue>();

            return new CosmosDBPercentileMetric(
                startOn,
                endOn,
                timeGrain,
                unit,
                name,
                metricValues?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PercentileMetricValue"/>. </summary>
        /// <param name="count"> The number of values for the metric. </param>
        /// <param name="average"> The average value of the metric. </param>
        /// <param name="maximum"> The max value of the metric. </param>
        /// <param name="minimum"> The min value of the metric. </param>
        /// <param name="timestamp"> The metric timestamp (ISO-8601 format). </param>
        /// <param name="total"> The total value of the metric. </param>
        /// <param name="p10"> The 10th percentile value for the metric. </param>
        /// <param name="p25"> The 25th percentile value for the metric. </param>
        /// <param name="p50"> The 50th percentile value for the metric. </param>
        /// <param name="p75"> The 75th percentile value for the metric. </param>
        /// <param name="p90"> The 90th percentile value for the metric. </param>
        /// <param name="p95"> The 95th percentile value for the metric. </param>
        /// <param name="p99"> The 99th percentile value for the metric. </param>
        /// <returns> A new <see cref="Models.PercentileMetricValue"/> instance for mocking. </returns>
        public static PercentileMetricValue PercentileMetricValue(int? count = null, double? average = null, double? maximum = null, double? minimum = null, DateTimeOffset? timestamp = null, double? total = null, double? p10 = null, double? p25 = null, double? p50 = null, double? p75 = null, double? p90 = null, double? p95 = null, double? p99 = null)
        {
            return new PercentileMetricValue(
                count,
                average,
                maximum,
                minimum,
                timestamp,
                total,
                serializedAdditionalRawData: null,
                p10,
                p25,
                p50,
                p75,
                p90,
                p95,
                p99);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PartitionMetric"/>. </summary>
        /// <param name="startOn"> The start time for the metric (ISO-8601 format). </param>
        /// <param name="endOn"> The end time for the metric (ISO-8601 format). </param>
        /// <param name="timeGrain"> The time grain to be used to summarize the metric values. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="metricValues"> The metric values for the specified time window and timestep. </param>
        /// <param name="partitionId"> The partition id (GUID identifier) of the metric values. </param>
        /// <param name="partitionKeyRangeId"> The partition key range id (integer identifier) of the metric values. </param>
        /// <returns> A new <see cref="Models.PartitionMetric"/> instance for mocking. </returns>
        public static PartitionMetric PartitionMetric(DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string timeGrain = null, CosmosDBMetricUnitType? unit = null, CosmosDBMetricName name = null, IEnumerable<CosmosDBMetricValue> metricValues = null, Guid? partitionId = null, string partitionKeyRangeId = null)
        {
            metricValues ??= new List<CosmosDBMetricValue>();

            return new PartitionMetric(
                startOn,
                endOn,
                timeGrain,
                unit,
                name,
                metricValues?.ToList(),
                serializedAdditionalRawData: null,
                partitionId,
                partitionKeyRangeId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBBaseUsage"/>. </summary>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="quotaPeriod"> The quota period used to summarize the usage values. </param>
        /// <param name="limit"> Maximum value for this metric. </param>
        /// <param name="currentValue"> Current value for this metric. </param>
        /// <returns> A new <see cref="Models.CosmosDBBaseUsage"/> instance for mocking. </returns>
        public static CosmosDBBaseUsage CosmosDBBaseUsage(CosmosDBMetricUnitType? unit = null, CosmosDBMetricName name = null, string quotaPeriod = null, long? limit = null, long? currentValue = null)
        {
            return new CosmosDBBaseUsage(
                unit,
                name,
                quotaPeriod,
                limit,
                currentValue,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PartitionUsage"/>. </summary>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="quotaPeriod"> The quota period used to summarize the usage values. </param>
        /// <param name="limit"> Maximum value for this metric. </param>
        /// <param name="currentValue"> Current value for this metric. </param>
        /// <param name="partitionId"> The partition id (GUID identifier) of the usages. </param>
        /// <param name="partitionKeyRangeId"> The partition key range id (integer identifier) of the usages. </param>
        /// <returns> A new <see cref="Models.PartitionUsage"/> instance for mocking. </returns>
        public static PartitionUsage PartitionUsage(CosmosDBMetricUnitType? unit = null, CosmosDBMetricName name = null, string quotaPeriod = null, long? limit = null, long? currentValue = null, Guid? partitionId = null, string partitionKeyRangeId = null)
        {
            return new PartitionUsage(
                unit,
                name,
                quotaPeriod,
                limit,
                currentValue,
                serializedAdditionalRawData: null,
                partitionId,
                partitionKeyRangeId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBMetricDefinition"/>. </summary>
        /// <param name="metricAvailabilities"> The list of metric availabilities for the account. </param>
        /// <param name="primaryAggregationType"> The primary aggregation type of the metric. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="resourceId"> The resource uri of the database. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <returns> A new <see cref="Models.CosmosDBMetricDefinition"/> instance for mocking. </returns>
        public static CosmosDBMetricDefinition CosmosDBMetricDefinition(IEnumerable<CosmosDBMetricAvailability> metricAvailabilities = null, CosmosDBMetricPrimaryAggregationType? primaryAggregationType = null, CosmosDBMetricUnitType? unit = null, ResourceIdentifier resourceId = null, CosmosDBMetricName name = null)
        {
            metricAvailabilities ??= new List<CosmosDBMetricAvailability>();

            return new CosmosDBMetricDefinition(
                metricAvailabilities?.ToList(),
                primaryAggregationType,
                unit,
                resourceId,
                name,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBMetricAvailability"/>. </summary>
        /// <param name="timeGrain"> The time grain to be used to summarize the metric values. </param>
        /// <param name="retention"> The retention for the metric values. </param>
        /// <returns> A new <see cref="Models.CosmosDBMetricAvailability"/> instance for mocking. </returns>
        public static CosmosDBMetricAvailability CosmosDBMetricAvailability(string timeGrain = null, string retention = null)
        {
            return new CosmosDBMetricAvailability(timeGrain, retention, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.GraphResourceGetResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resourceId"> Gets or sets the resource. </param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.GraphResourceGetResultData"/> instance for mocking. </returns>
        public static GraphResourceGetResultData GraphResourceGetResultData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ResourceIdentifier resourceId = null, GraphResourceGetPropertiesOptions options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GraphResourceGetResultData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resourceId != null ? ResourceManagerModelFactory.WritableSubResource(resourceId) : null,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GraphResourceGetResultCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resourceId"> The standard JSON format of a Graph resource. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.GraphResourceGetResultCreateOrUpdateContent"/> instance for mocking. </returns>
        public static GraphResourceGetResultCreateOrUpdateContent GraphResourceGetResultCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ResourceIdentifier resourceId = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GraphResourceGetResultCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resourceId != null ? ResourceManagerModelFactory.WritableSubResource(resourceId) : null,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlDatabaseData"/> instance for mocking. </returns>
        public static CosmosDBSqlDatabaseData CosmosDBSqlDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCosmosDBSqlDatabaseResourceInfo resource = null, CosmosDBSqlDatabasePropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCosmosDBSqlDatabaseResourceInfo"/>. </summary>
        /// <param name="databaseName"> Name of the Cosmos DB SQL database. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="colls"> A system generated property that specified the addressable path of the collections resource. </param>
        /// <param name="users"> A system generated property that specifies the addressable path of the users resource. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCosmosDBSqlDatabaseResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCosmosDBSqlDatabaseResourceInfo ExtendedCosmosDBSqlDatabaseResourceInfo(string databaseName = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string colls = null, string users = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedCosmosDBSqlDatabaseResourceInfo(
                databaseName,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                colls,
                users,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBSqlDatabaseCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a SQL database. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBSqlDatabaseCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBSqlDatabaseCreateOrUpdateContent CosmosDBSqlDatabaseCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBSqlDatabaseResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlDatabaseCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.ThroughputSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.ThroughputSettingData"/> instance for mocking. </returns>
        public static ThroughputSettingData ThroughputSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedThroughputSettingsResourceInfo resource = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ThroughputSettingData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedThroughputSettingsResourceInfo"/>. </summary>
        /// <param name="throughput"> Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both. </param>
        /// <param name="autoscaleSettings"> Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both. </param>
        /// <param name="minimumThroughput"> The minimum throughput of the resource. </param>
        /// <param name="offerReplacePending"> The throughput replace is pending. </param>
        /// <param name="instantMaximumThroughput"> The offer throughput value to instantly scale up without triggering splits. </param>
        /// <param name="softAllowedMaximumThroughput"> The maximum throughput value or the maximum maxThroughput value (for autoscale) that can be specified. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedThroughputSettingsResourceInfo"/> instance for mocking. </returns>
        public static ExtendedThroughputSettingsResourceInfo ExtendedThroughputSettingsResourceInfo(int? throughput = null, AutoscaleSettingsResourceInfo autoscaleSettings = null, string minimumThroughput = null, string offerReplacePending = null, string instantMaximumThroughput = null, string softAllowedMaximumThroughput = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedThroughputSettingsResourceInfo(
                throughput,
                autoscaleSettings,
                minimumThroughput,
                offerReplacePending,
                instantMaximumThroughput,
                softAllowedMaximumThroughput,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ThroughputSettingsResourceInfo"/>. </summary>
        /// <param name="throughput"> Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both. </param>
        /// <param name="autoscaleSettings"> Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both. </param>
        /// <param name="minimumThroughput"> The minimum throughput of the resource. </param>
        /// <param name="offerReplacePending"> The throughput replace is pending. </param>
        /// <param name="instantMaximumThroughput"> The offer throughput value to instantly scale up without triggering splits. </param>
        /// <param name="softAllowedMaximumThroughput"> The maximum throughput value or the maximum maxThroughput value (for autoscale) that can be specified. </param>
        /// <returns> A new <see cref="Models.ThroughputSettingsResourceInfo"/> instance for mocking. </returns>
        public static ThroughputSettingsResourceInfo ThroughputSettingsResourceInfo(int? throughput = null, AutoscaleSettingsResourceInfo autoscaleSettings = null, string minimumThroughput = null, string offerReplacePending = null, string instantMaximumThroughput = null, string softAllowedMaximumThroughput = null)
        {
            return new ThroughputSettingsResourceInfo(
                throughput,
                autoscaleSettings,
                minimumThroughput,
                offerReplacePending,
                instantMaximumThroughput,
                softAllowedMaximumThroughput,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutoscaleSettingsResourceInfo"/>. </summary>
        /// <param name="maxThroughput"> Represents maximum throughput container can scale up to. </param>
        /// <param name="autoUpgradeThroughputPolicy"> Cosmos DB resource auto-upgrade policy. </param>
        /// <param name="targetMaxThroughput"> Represents target maximum throughput container can scale up to once offer is no longer in pending state. </param>
        /// <returns> A new <see cref="Models.AutoscaleSettingsResourceInfo"/> instance for mocking. </returns>
        public static AutoscaleSettingsResourceInfo AutoscaleSettingsResourceInfo(int maxThroughput = default, ThroughputPolicyResourceInfo autoUpgradeThroughputPolicy = null, int? targetMaxThroughput = null)
        {
            return new AutoscaleSettingsResourceInfo(maxThroughput, autoUpgradeThroughputPolicy != null ? new AutoUpgradePolicyResourceInfo(autoUpgradeThroughputPolicy, serializedAdditionalRawData: null) : null, targetMaxThroughput, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ThroughputSettingsUpdateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a resource throughput. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.ThroughputSettingsUpdateData"/> instance for mocking. </returns>
        public static ThroughputSettingsUpdateData ThroughputSettingsUpdateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ThroughputSettingsResourceInfo resource = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ThroughputSettingsUpdateData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlClientEncryptionKeyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"></param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlClientEncryptionKeyData"/> instance for mocking. </returns>
        public static CosmosDBSqlClientEncryptionKeyData CosmosDBSqlClientEncryptionKeyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CosmosDBSqlClientEncryptionKeyProperties resource = null)
        {
            return new CosmosDBSqlClientEncryptionKeyData(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBSqlClientEncryptionKeyProperties"/>. </summary>
        /// <param name="id"> Name of the ClientEncryptionKey. </param>
        /// <param name="encryptionAlgorithm"> Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data. </param>
        /// <param name="wrappedDataEncryptionKey"> Wrapped (encrypted) form of the key represented as a byte array. </param>
        /// <param name="keyWrapMetadata"> Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.CosmosDBSqlClientEncryptionKeyProperties"/> instance for mocking. </returns>
        public static CosmosDBSqlClientEncryptionKeyProperties CosmosDBSqlClientEncryptionKeyProperties(string id = null, string encryptionAlgorithm = null, byte[] wrappedDataEncryptionKey = null, CosmosDBKeyWrapMetadata keyWrapMetadata = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new CosmosDBSqlClientEncryptionKeyProperties(
                id,
                encryptionAlgorithm,
                wrappedDataEncryptionKey,
                keyWrapMetadata,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlContainerData"/> instance for mocking. </returns>
        public static CosmosDBSqlContainerData CosmosDBSqlContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCosmosDBSqlContainerResourceInfo resource = null, CosmosDBSqlContainerPropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlContainerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCosmosDBSqlContainerResourceInfo"/>. </summary>
        /// <param name="containerName"> Name of the Cosmos DB SQL container. </param>
        /// <param name="indexingPolicy"> The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container. </param>
        /// <param name="partitionKey"> The configuration of the partition key to be used for partitioning data into multiple partitions. </param>
        /// <param name="defaultTtl"> Default time to live. </param>
        /// <param name="uniqueKeys"> The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service. </param>
        /// <param name="conflictResolutionPolicy"> The conflict resolution policy for the container. </param>
        /// <param name="clientEncryptionPolicy"> The client encryption policy for the container. </param>
        /// <param name="analyticalStorageTtl"> Analytical TTL. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="materializedViewDefinition"> The configuration for defining Materialized Views. This must be specified only for creating a Materialized View container. </param>
        /// <param name="computedProperties"> List of computed properties. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCosmosDBSqlContainerResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCosmosDBSqlContainerResourceInfo ExtendedCosmosDBSqlContainerResourceInfo(string containerName = null, CosmosDBIndexingPolicy indexingPolicy = null, CosmosDBContainerPartitionKey partitionKey = null, int? defaultTtl = null, IEnumerable<CosmosDBUniqueKey> uniqueKeys = null, ConflictResolutionPolicy conflictResolutionPolicy = null, CosmosDBClientEncryptionPolicy clientEncryptionPolicy = null, long? analyticalStorageTtl = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, MaterializedViewDefinition materializedViewDefinition = null, IEnumerable<ComputedProperty> computedProperties = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            uniqueKeys ??= new List<CosmosDBUniqueKey>();
            computedProperties ??= new List<ComputedProperty>();

            return new ExtendedCosmosDBSqlContainerResourceInfo(
                containerName,
                indexingPolicy,
                partitionKey,
                defaultTtl,
                uniqueKeys != null ? new CosmosDBUniqueKeyPolicy(uniqueKeys?.ToList(), serializedAdditionalRawData: null) : null,
                conflictResolutionPolicy,
                clientEncryptionPolicy,
                analyticalStorageTtl,
                restoreParameters,
                createMode,
                materializedViewDefinition,
                computedProperties?.ToList(),
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBContainerPartitionKey"/>. </summary>
        /// <param name="paths"> List of paths using which data within the container can be partitioned. </param>
        /// <param name="kind"> Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create. </param>
        /// <param name="version"> Indicates the version of the partition key definition. </param>
        /// <param name="isSystemKey"> Indicates if the container is using a system generated partition key. </param>
        /// <returns> A new <see cref="Models.CosmosDBContainerPartitionKey"/> instance for mocking. </returns>
        public static CosmosDBContainerPartitionKey CosmosDBContainerPartitionKey(IEnumerable<string> paths = null, CosmosDBPartitionKind? kind = null, int? version = null, bool? isSystemKey = null)
        {
            paths ??= new List<string>();

            return new CosmosDBContainerPartitionKey(paths?.ToList(), kind, version, isSystemKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MaterializedViewDefinition"/>. </summary>
        /// <param name="sourceCollectionRid"> An unique identifier for the source collection. This is a system generated property. </param>
        /// <param name="sourceCollectionId"> The name of the source container on which the Materialized View will be created. </param>
        /// <param name="definition"> The definition should be an SQL query which would be used to fetch data from the source container to populate into the Materialized View container. </param>
        /// <returns> A new <see cref="Models.MaterializedViewDefinition"/> instance for mocking. </returns>
        public static MaterializedViewDefinition MaterializedViewDefinition(string sourceCollectionRid = null, string sourceCollectionId = null, string definition = null)
        {
            return new MaterializedViewDefinition(sourceCollectionRid, sourceCollectionId, definition, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBSqlContainerCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a container. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBSqlContainerCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBSqlContainerCreateOrUpdateContent CosmosDBSqlContainerCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBSqlContainerResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlContainerCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PhysicalPartitionStorageInfoCollection"/>. </summary>
        /// <param name="physicalPartitionStorageInfoCollectionValue"> List of physical partitions and their properties. </param>
        /// <returns> A new <see cref="Models.PhysicalPartitionStorageInfoCollection"/> instance for mocking. </returns>
        public static PhysicalPartitionStorageInfoCollection PhysicalPartitionStorageInfoCollection(IEnumerable<PhysicalPartitionStorageInfo> physicalPartitionStorageInfoCollectionValue = null)
        {
            physicalPartitionStorageInfoCollectionValue ??= new List<PhysicalPartitionStorageInfo>();

            return new PhysicalPartitionStorageInfoCollection(physicalPartitionStorageInfoCollectionValue?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PhysicalPartitionStorageInfo"/>. </summary>
        /// <param name="id"> The unique identifier of the partition. </param>
        /// <param name="storageInKB"> The storage in KB for the physical partition. </param>
        /// <returns> A new <see cref="Models.PhysicalPartitionStorageInfo"/> instance for mocking. </returns>
        public static PhysicalPartitionStorageInfo PhysicalPartitionStorageInfo(string id = null, double? storageInKB = null)
        {
            return new PhysicalPartitionStorageInfo(id, storageInKB, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RetrieveThroughputParameters"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resourcePhysicalPartitionIds"> The standard JSON format of a resource throughput. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.RetrieveThroughputParameters"/> instance for mocking. </returns>
        public static RetrieveThroughputParameters RetrieveThroughputParameters(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<WritableSubResource> resourcePhysicalPartitionIds = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();
            resourcePhysicalPartitionIds ??= new List<WritableSubResource>();

            return new RetrieveThroughputParameters(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resourcePhysicalPartitionIds != null ? new RetrieveThroughputPropertiesResource(resourcePhysicalPartitionIds?.ToList(), serializedAdditionalRawData: null) : null,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PhysicalPartitionThroughputInfoResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resourcePhysicalPartitionThroughputInfo"> properties of physical partition throughput info. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.PhysicalPartitionThroughputInfoResult"/> instance for mocking. </returns>
        public static PhysicalPartitionThroughputInfoResult PhysicalPartitionThroughputInfoResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<PhysicalPartitionThroughputInfoResource> resourcePhysicalPartitionThroughputInfo = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();
            resourcePhysicalPartitionThroughputInfo ??= new List<PhysicalPartitionThroughputInfoResource>();

            return new PhysicalPartitionThroughputInfoResult(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resourcePhysicalPartitionThroughputInfo != null ? new PhysicalPartitionThroughputInfoResultPropertiesResource(resourcePhysicalPartitionThroughputInfo?.ToList(), serializedAdditionalRawData: null) : null,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedistributeThroughputParameters"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a resource throughput. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.RedistributeThroughputParameters"/> instance for mocking. </returns>
        public static RedistributeThroughputParameters RedistributeThroughputParameters(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, RedistributeThroughputPropertiesResource resource = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new RedistributeThroughputParameters(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlStoredProcedureData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlStoredProcedureData"/> instance for mocking. </returns>
        public static CosmosDBSqlStoredProcedureData CosmosDBSqlStoredProcedureData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCosmosDBSqlStoredProcedureResourceInfo resource = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlStoredProcedureData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCosmosDBSqlStoredProcedureResourceInfo"/>. </summary>
        /// <param name="storedProcedureName"> Name of the Cosmos DB SQL storedProcedure. </param>
        /// <param name="body"> Body of the Stored Procedure. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCosmosDBSqlStoredProcedureResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCosmosDBSqlStoredProcedureResourceInfo ExtendedCosmosDBSqlStoredProcedureResourceInfo(string storedProcedureName = null, string body = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedCosmosDBSqlStoredProcedureResourceInfo(
                storedProcedureName,
                body,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBSqlStoredProcedureCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a storedProcedure. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBSqlStoredProcedureCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBSqlStoredProcedureCreateOrUpdateContent CosmosDBSqlStoredProcedureCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBSqlStoredProcedureResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlStoredProcedureCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlUserDefinedFunctionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlUserDefinedFunctionData"/> instance for mocking. </returns>
        public static CosmosDBSqlUserDefinedFunctionData CosmosDBSqlUserDefinedFunctionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCosmosDBSqlUserDefinedFunctionResourceInfo resource = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlUserDefinedFunctionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCosmosDBSqlUserDefinedFunctionResourceInfo"/>. </summary>
        /// <param name="functionName"> Name of the Cosmos DB SQL userDefinedFunction. </param>
        /// <param name="body"> Body of the User Defined Function. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCosmosDBSqlUserDefinedFunctionResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCosmosDBSqlUserDefinedFunctionResourceInfo ExtendedCosmosDBSqlUserDefinedFunctionResourceInfo(string functionName = null, string body = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedCosmosDBSqlUserDefinedFunctionResourceInfo(
                functionName,
                body,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBSqlUserDefinedFunctionCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a userDefinedFunction. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBSqlUserDefinedFunctionCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBSqlUserDefinedFunctionCreateOrUpdateContent CosmosDBSqlUserDefinedFunctionCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBSqlUserDefinedFunctionResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlUserDefinedFunctionCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlTriggerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlTriggerData"/> instance for mocking. </returns>
        public static CosmosDBSqlTriggerData CosmosDBSqlTriggerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCosmosDBSqlTriggerResourceInfo resource = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlTriggerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCosmosDBSqlTriggerResourceInfo"/>. </summary>
        /// <param name="triggerName"> Name of the Cosmos DB SQL trigger. </param>
        /// <param name="body"> Body of the Trigger. </param>
        /// <param name="triggerType"> Type of the Trigger. </param>
        /// <param name="triggerOperation"> The operation the trigger is associated with. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCosmosDBSqlTriggerResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCosmosDBSqlTriggerResourceInfo ExtendedCosmosDBSqlTriggerResourceInfo(string triggerName = null, string body = null, CosmosDBSqlTriggerType? triggerType = null, CosmosDBSqlTriggerOperation? triggerOperation = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedCosmosDBSqlTriggerResourceInfo(
                triggerName,
                body,
                triggerType,
                triggerOperation,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBSqlTriggerCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a trigger. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBSqlTriggerCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBSqlTriggerCreateOrUpdateContent CosmosDBSqlTriggerCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBSqlTriggerResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBSqlTriggerCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.MongoDBDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.MongoDBDatabaseData"/> instance for mocking. </returns>
        public static MongoDBDatabaseData MongoDBDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedMongoDBDatabaseResourceInfo resource = null, MongoDBDatabasePropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MongoDBDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedMongoDBDatabaseResourceInfo"/>. </summary>
        /// <param name="databaseName"> Name of the Cosmos DB MongoDB database. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedMongoDBDatabaseResourceInfo"/> instance for mocking. </returns>
        public static ExtendedMongoDBDatabaseResourceInfo ExtendedMongoDBDatabaseResourceInfo(string databaseName = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedMongoDBDatabaseResourceInfo(
                databaseName,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBDatabaseCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a MongoDB database. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.MongoDBDatabaseCreateOrUpdateContent"/> instance for mocking. </returns>
        public static MongoDBDatabaseCreateOrUpdateContent MongoDBDatabaseCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MongoDBDatabaseResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MongoDBDatabaseCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.MongoDBCollectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.MongoDBCollectionData"/> instance for mocking. </returns>
        public static MongoDBCollectionData MongoDBCollectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedMongoDBCollectionResourceInfo resource = null, MongoDBCollectionPropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MongoDBCollectionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedMongoDBCollectionResourceInfo"/>. </summary>
        /// <param name="collectionName"> Name of the Cosmos DB MongoDB collection. </param>
        /// <param name="shardKey"> A key-value pair of shard keys to be applied for the request. </param>
        /// <param name="indexes"> List of index keys. </param>
        /// <param name="analyticalStorageTtl"> Analytical TTL. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedMongoDBCollectionResourceInfo"/> instance for mocking. </returns>
        public static ExtendedMongoDBCollectionResourceInfo ExtendedMongoDBCollectionResourceInfo(string collectionName = null, IDictionary<string, string> shardKey = null, IEnumerable<MongoDBIndex> indexes = null, int? analyticalStorageTtl = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            shardKey ??= new Dictionary<string, string>();
            indexes ??= new List<MongoDBIndex>();

            return new ExtendedMongoDBCollectionResourceInfo(
                collectionName,
                shardKey,
                indexes?.ToList(),
                analyticalStorageTtl,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBCollectionCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a MongoDB collection. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.MongoDBCollectionCreateOrUpdateContent"/> instance for mocking. </returns>
        public static MongoDBCollectionCreateOrUpdateContent MongoDBCollectionCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MongoDBCollectionResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MongoDBCollectionCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBTableData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBTableData"/> instance for mocking. </returns>
        public static CosmosDBTableData CosmosDBTableData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBTablePropertiesResource resource = null, CosmosDBTablePropertiesOptions options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBTableData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBTablePropertiesResource"/>. </summary>
        /// <param name="tableName"> Name of the Cosmos DB table. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.CosmosDBTablePropertiesResource"/> instance for mocking. </returns>
        public static CosmosDBTablePropertiesResource CosmosDBTablePropertiesResource(string tableName = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new CosmosDBTablePropertiesResource(
                tableName,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBTableCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a Table. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CosmosDBTableCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CosmosDBTableCreateOrUpdateContent CosmosDBTableCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBTableResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBTableCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CassandraKeyspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CassandraKeyspaceData"/> instance for mocking. </returns>
        public static CassandraKeyspaceData CassandraKeyspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCassandraKeyspaceResourceInfo resource = null, CassandraKeyspacePropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraKeyspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCassandraKeyspaceResourceInfo"/>. </summary>
        /// <param name="keyspaceName"> Name of the Cosmos DB Cassandra keyspace. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCassandraKeyspaceResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCassandraKeyspaceResourceInfo ExtendedCassandraKeyspaceResourceInfo(string keyspaceName = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedCassandraKeyspaceResourceInfo(keyspaceName, serializedAdditionalRawData: null, rid, timestamp, etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraKeyspaceCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resourceKeyspaceName"> The standard JSON format of a Cassandra keyspace. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CassandraKeyspaceCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CassandraKeyspaceCreateOrUpdateContent CassandraKeyspaceCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string resourceKeyspaceName = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraKeyspaceCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resourceKeyspaceName != null ? new CassandraKeyspaceResourceInfo(resourceKeyspaceName, serializedAdditionalRawData: null) : null,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CassandraTableData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CassandraTableData"/> instance for mocking. </returns>
        public static CassandraTableData CassandraTableData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedCassandraTableResourceInfo resource = null, CassandraTablePropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraTableData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedCassandraTableResourceInfo"/>. </summary>
        /// <param name="tableName"> Name of the Cosmos DB Cassandra table. </param>
        /// <param name="defaultTtl"> Time to live of the Cosmos DB Cassandra table. </param>
        /// <param name="schema"> Schema of the Cosmos DB Cassandra table. </param>
        /// <param name="analyticalStorageTtl"> Analytical TTL. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedCassandraTableResourceInfo"/> instance for mocking. </returns>
        public static ExtendedCassandraTableResourceInfo ExtendedCassandraTableResourceInfo(string tableName = null, int? defaultTtl = null, CassandraSchema schema = null, int? analyticalStorageTtl = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedCassandraTableResourceInfo(
                tableName,
                defaultTtl,
                schema,
                analyticalStorageTtl,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraTableCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a Cassandra table. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CassandraTableCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CassandraTableCreateOrUpdateContent CassandraTableCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CassandraTableResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraTableCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.GremlinDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.GremlinDatabaseData"/> instance for mocking. </returns>
        public static GremlinDatabaseData GremlinDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedGremlinDatabaseResourceInfo resource = null, GremlinDatabasePropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GremlinDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedGremlinDatabaseResourceInfo"/>. </summary>
        /// <param name="databaseName"> Name of the Cosmos DB Gremlin database. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedGremlinDatabaseResourceInfo"/> instance for mocking. </returns>
        public static ExtendedGremlinDatabaseResourceInfo ExtendedGremlinDatabaseResourceInfo(string databaseName = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new ExtendedGremlinDatabaseResourceInfo(
                databaseName,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GremlinDatabaseCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a Gremlin database. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.GremlinDatabaseCreateOrUpdateContent"/> instance for mocking. </returns>
        public static GremlinDatabaseCreateOrUpdateContent GremlinDatabaseCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, GremlinDatabaseResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GremlinDatabaseCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.GremlinGraphData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.GremlinGraphData"/> instance for mocking. </returns>
        public static GremlinGraphData GremlinGraphData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedGremlinGraphResourceInfo resource = null, GremlinGraphPropertiesConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GremlinGraphData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedGremlinGraphResourceInfo"/>. </summary>
        /// <param name="graphName"> Name of the Cosmos DB Gremlin graph. </param>
        /// <param name="indexingPolicy"> The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph. </param>
        /// <param name="partitionKey"> The configuration of the partition key to be used for partitioning data into multiple partitions. </param>
        /// <param name="defaultTtl"> Default time to live. </param>
        /// <param name="uniqueKeys"> The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service. </param>
        /// <param name="conflictResolutionPolicy"> The conflict resolution policy for the graph. </param>
        /// <param name="analyticalStorageTtl"> Analytical TTL. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.ExtendedGremlinGraphResourceInfo"/> instance for mocking. </returns>
        public static ExtendedGremlinGraphResourceInfo ExtendedGremlinGraphResourceInfo(string graphName = null, CosmosDBIndexingPolicy indexingPolicy = null, CosmosDBContainerPartitionKey partitionKey = null, int? defaultTtl = null, IEnumerable<CosmosDBUniqueKey> uniqueKeys = null, ConflictResolutionPolicy conflictResolutionPolicy = null, long? analyticalStorageTtl = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            uniqueKeys ??= new List<CosmosDBUniqueKey>();

            return new ExtendedGremlinGraphResourceInfo(
                graphName,
                indexingPolicy,
                partitionKey,
                defaultTtl,
                uniqueKeys != null ? new CosmosDBUniqueKeyPolicy(uniqueKeys?.ToList(), serializedAdditionalRawData: null) : null,
                conflictResolutionPolicy,
                analyticalStorageTtl,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GremlinGraphCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a Gremlin graph. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.GremlinGraphCreateOrUpdateContent"/> instance for mocking. </returns>
        public static GremlinGraphCreateOrUpdateContent GremlinGraphCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, GremlinGraphResourceInfo resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GremlinGraphCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBLocationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Cosmos DB location metadata. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBLocationData"/> instance for mocking. </returns>
        public static CosmosDBLocationData CosmosDBLocationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CosmosDBLocationProperties properties = null)
        {
            return new CosmosDBLocationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBLocationProperties"/>. </summary>
        /// <param name="doesSupportAvailabilityZone"> Flag indicating whether the location supports availability zones or not. </param>
        /// <param name="isResidencyRestricted"> Flag indicating whether the location is residency sensitive. </param>
        /// <param name="backupStorageRedundancies"> The properties of available backup storage redundancies. </param>
        /// <param name="isSubscriptionRegionAccessAllowedForRegular"> Flag indicating whether the subscription have access in region for Non-Availability Zones. </param>
        /// <param name="isSubscriptionRegionAccessAllowedForAz"> Flag indicating whether the subscription have access in region for Availability Zones(Az). </param>
        /// <param name="status"> Enum to indicate current buildout status of the region. </param>
        /// <returns> A new <see cref="Models.CosmosDBLocationProperties"/> instance for mocking. </returns>
        public static CosmosDBLocationProperties CosmosDBLocationProperties(bool? doesSupportAvailabilityZone = null, bool? isResidencyRestricted = null, IEnumerable<CosmosDBBackupStorageRedundancy> backupStorageRedundancies = null, bool? isSubscriptionRegionAccessAllowedForRegular = null, bool? isSubscriptionRegionAccessAllowedForAz = null, CosmosDBStatus? status = null)
        {
            backupStorageRedundancies ??= new List<CosmosDBBackupStorageRedundancy>();

            return new CosmosDBLocationProperties(
                doesSupportAvailabilityZone,
                isResidencyRestricted,
                backupStorageRedundancies?.ToList(),
                isSubscriptionRegionAccessAllowedForRegular,
                isSubscriptionRegionAccessAllowedForAz,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CassandraViewGetResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"></param>
        /// <param name="options"></param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="CosmosDB.CassandraViewGetResultData"/> instance for mocking. </returns>
        public static CassandraViewGetResultData CassandraViewGetResultData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CassandraViewGetPropertiesResource resource = null, CassandraViewGetPropertiesOptions options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraViewGetResultData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraViewGetPropertiesResource"/>. </summary>
        /// <param name="id"> Name of the Cosmos DB Cassandra view. </param>
        /// <param name="viewDefinition"> View Definition of the Cosmos DB Cassandra view. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.CassandraViewGetPropertiesResource"/> instance for mocking. </returns>
        public static CassandraViewGetPropertiesResource CassandraViewGetPropertiesResource(string id = null, string viewDefinition = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new CassandraViewGetPropertiesResource(
                id,
                viewDefinition,
                serializedAdditionalRawData: null,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraViewGetResultCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resource"> The standard JSON format of a Cassandra view. </param>
        /// <param name="options"> A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <returns> A new <see cref="Models.CassandraViewGetResultCreateOrUpdateContent"/> instance for mocking. </returns>
        public static CassandraViewGetResultCreateOrUpdateContent CassandraViewGetResultCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CassandraViewResource resource = null, CosmosDBCreateUpdateConfig options = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraViewGetResultCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resource,
                options,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataTransferJobGetResultCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Data Transfer Create Job Properties. </param>
        /// <returns> A new <see cref="Models.DataTransferJobGetResultCreateOrUpdateContent"/> instance for mocking. </returns>
        public static DataTransferJobGetResultCreateOrUpdateContent DataTransferJobGetResultCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataTransferJobProperties properties = null)
        {
            return new DataTransferJobGetResultCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataTransferJobProperties"/>. </summary>
        /// <param name="jobName"> Job Name. </param>
        /// <param name="source">
        /// Source DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </param>
        /// <param name="destination">
        /// Destination DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </param>
        /// <param name="status"> Job Status. </param>
        /// <param name="processedCount"> Processed Count. </param>
        /// <param name="totalCount"> Total Count. </param>
        /// <param name="lastUpdatedUtcOn"> Last Updated Time (ISO-8601 format). </param>
        /// <param name="workerCount"> Worker count. </param>
        /// <param name="error"> Error response for Faulted job. </param>
        /// <param name="duration"> Total Duration of Job. </param>
        /// <param name="mode"> Mode of job execution. </param>
        /// <returns> A new <see cref="Models.DataTransferJobProperties"/> instance for mocking. </returns>
        public static DataTransferJobProperties DataTransferJobProperties(string jobName = null, DataTransferDataSourceSink source = null, DataTransferDataSourceSink destination = null, string status = null, long? processedCount = null, long? totalCount = null, DateTimeOffset? lastUpdatedUtcOn = null, int? workerCount = null, CosmosDBErrorResult error = null, TimeSpan? duration = null, DataTransferJobMode? mode = null)
        {
            return new DataTransferJobProperties(
                jobName,
                source,
                destination,
                status,
                processedCount,
                totalCount,
                lastUpdatedUtcOn,
                workerCount,
                error,
                duration,
                mode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.DataTransferJobGetResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="jobName"> Job Name. </param>
        /// <param name="source">
        /// Source DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </param>
        /// <param name="destination">
        /// Destination DataStore details
        /// Please note <see cref="DataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureBlobDataTransferDataSourceSink"/>, <see cref="BaseCosmosDataTransferDataSourceSink"/>, <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/>, <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
        /// </param>
        /// <param name="status"> Job Status. </param>
        /// <param name="processedCount"> Processed Count. </param>
        /// <param name="totalCount"> Total Count. </param>
        /// <param name="lastUpdatedUtcOn"> Last Updated Time (ISO-8601 format). </param>
        /// <param name="workerCount"> Worker count. </param>
        /// <param name="error"> Error response for Faulted job. </param>
        /// <param name="duration"> Total Duration of Job. </param>
        /// <param name="mode"> Mode of job execution. </param>
        /// <returns> A new <see cref="CosmosDB.DataTransferJobGetResultData"/> instance for mocking. </returns>
        public static DataTransferJobGetResultData DataTransferJobGetResultData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string jobName = null, DataTransferDataSourceSink source = null, DataTransferDataSourceSink destination = null, string status = null, long? processedCount = null, long? totalCount = null, DateTimeOffset? lastUpdatedUtcOn = null, int? workerCount = null, CosmosDBErrorResult error = null, TimeSpan? duration = null, DataTransferJobMode? mode = null)
        {
            return new DataTransferJobGetResultData(
                id,
                name,
                resourceType,
                systemData,
                jobName,
                source,
                destination,
                status,
                processedCount,
                totalCount,
                lastUpdatedUtcOn,
                workerCount,
                error,
                duration,
                mode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CassandraClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Properties of a managed Cassandra cluster. </param>
        /// <param name="identity"> Identity for the resource. Current supported identity types: SystemAssigned, None. </param>
        /// <returns> A new <see cref="CosmosDB.CassandraClusterData"/> instance for mocking. </returns>
        public static CassandraClusterData CassandraClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CassandraClusterProperties properties = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CassandraClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraClusterProperties"/>. </summary>
        /// <param name="provisioningState"> The status of the resource at the time the operation was called. </param>
        /// <param name="restoreFromBackupId"> To create an empty cluster, omit this field or set it to null. To restore a backup into a new cluster, set this field to the resource id of the backup. </param>
        /// <param name="delegatedManagementSubnetId"> Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/&lt;subscription id&gt;/resourceGroups/&lt;resource group&gt;/providers/Microsoft.Network/virtualNetworks/&lt;virtual network&gt;/subnets/&lt;subnet&gt;'. </param>
        /// <param name="cassandraVersion"> Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version. </param>
        /// <param name="clusterNameOverride"> If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property. </param>
        /// <param name="authenticationMethod"> Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'. </param>
        /// <param name="initialCassandraAdminPassword"> Initial password for clients connecting as admin to the cluster. Should be changed after cluster creation. Returns null on GET. This field only applies when the authenticationMethod field is 'Cassandra'. </param>
        /// <param name="prometheusEndpointIPAddress"> Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached. </param>
        /// <param name="isRepairEnabled"> Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs. </param>
        /// <param name="autoReplicate"> The form of AutoReplicate that is being used by this cluster. </param>
        /// <param name="clientCertificates"> List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property. </param>
        /// <param name="externalGossipCertificates"> List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property. </param>
        /// <param name="gossipCertificates"> List of TLS certificates that unmanaged nodes must trust for gossip with managed nodes. All managed nodes will present TLS client certificates that are verifiable using one of the certificates provided in this property. </param>
        /// <param name="externalSeedNodes"> List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes. </param>
        /// <param name="seedNodes"> List of IP addresses of seed nodes in the managed data centers. These should be added to the seed node lists of all unmanaged nodes. </param>
        /// <param name="externalDataCenters"> List of the data center names for unmanaged data centers in this cluster to be included in auto-replication. </param>
        /// <param name="hoursBetweenBackups"> (Deprecated) Number of hours to wait between taking a backup of the cluster. </param>
        /// <param name="isDeallocated"> Whether the cluster and associated data centers has been deallocated. </param>
        /// <param name="isCassandraAuditLoggingEnabled"> Whether Cassandra audit logging is enabled. </param>
        /// <param name="clusterType"> Type of the cluster. If set to Production, some operations might not be permitted on cluster. </param>
        /// <param name="provisionError"> Error related to resource provisioning. </param>
        /// <param name="extensions"> Extensions to be added or updated on cluster. </param>
        /// <param name="backupSchedules"> List of backup schedules that define when you want to back up your data. </param>
        /// <param name="scheduledEventStrategy"> How the nodes in the cluster react to scheduled events. </param>
        /// <param name="azureConnectionMethod"> How to connect to the azure services needed for running the cluster. </param>
        /// <param name="privateLinkResourceId"> If the Connection Method is Vpn, this is the Id of the private link resource that the datacenters need to connect to. </param>
        /// <returns> A new <see cref="Models.CassandraClusterProperties"/> instance for mocking. </returns>
        public static CassandraClusterProperties CassandraClusterProperties(CassandraProvisioningState? provisioningState = null, string restoreFromBackupId = null, ResourceIdentifier delegatedManagementSubnetId = null, string cassandraVersion = null, string clusterNameOverride = null, CassandraAuthenticationMethod? authenticationMethod = null, string initialCassandraAdminPassword = null, string prometheusEndpointIPAddress = null, bool? isRepairEnabled = null, CassandraAutoReplicateForm? autoReplicate = null, IEnumerable<CassandraCertificate> clientCertificates = null, IEnumerable<CassandraCertificate> externalGossipCertificates = null, IEnumerable<CassandraCertificate> gossipCertificates = null, IEnumerable<CassandraDataCenterSeedNode> externalSeedNodes = null, IEnumerable<CassandraDataCenterSeedNode> seedNodes = null, IEnumerable<string> externalDataCenters = null, int? hoursBetweenBackups = null, bool? isDeallocated = null, bool? isCassandraAuditLoggingEnabled = null, CassandraClusterType? clusterType = null, CassandraError provisionError = null, IEnumerable<string> extensions = null, IEnumerable<CassandraClusterBackupSchedule> backupSchedules = null, ScheduledEventStrategy? scheduledEventStrategy = null, ServiceConnectionType? azureConnectionMethod = null, ResourceIdentifier privateLinkResourceId = null)
        {
            clientCertificates ??= new List<CassandraCertificate>();
            externalGossipCertificates ??= new List<CassandraCertificate>();
            gossipCertificates ??= new List<CassandraCertificate>();
            externalSeedNodes ??= new List<CassandraDataCenterSeedNode>();
            seedNodes ??= new List<CassandraDataCenterSeedNode>();
            externalDataCenters ??= new List<string>();
            extensions ??= new List<string>();
            backupSchedules ??= new List<CassandraClusterBackupSchedule>();

            return new CassandraClusterProperties(
                provisioningState,
                restoreFromBackupId,
                delegatedManagementSubnetId,
                cassandraVersion,
                clusterNameOverride,
                authenticationMethod,
                initialCassandraAdminPassword,
                prometheusEndpointIPAddress != null ? new CassandraDataCenterSeedNode(prometheusEndpointIPAddress, serializedAdditionalRawData: null) : null,
                isRepairEnabled,
                autoReplicate,
                clientCertificates?.ToList(),
                externalGossipCertificates?.ToList(),
                gossipCertificates?.ToList(),
                externalSeedNodes?.ToList(),
                seedNodes?.ToList(),
                externalDataCenters?.ToList(),
                hoursBetweenBackups,
                isDeallocated,
                isCassandraAuditLoggingEnabled,
                clusterType,
                provisionError,
                extensions?.ToList(),
                backupSchedules?.ToList(),
                scheduledEventStrategy,
                azureConnectionMethod,
                privateLinkResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraCommandPostBody"/>. </summary>
        /// <param name="command"> The command which should be run. </param>
        /// <param name="arguments"> The arguments for the command to be run. </param>
        /// <param name="host"> IP address of the cassandra host to run the command on. </param>
        /// <param name="cassandraStopStart"> If true, stops cassandra before executing the command and then start it again. </param>
        /// <param name="allowWrite"> If true, allows the command to *write* to the cassandra directory, otherwise read-only. </param>
        /// <returns> A new <see cref="Models.CassandraCommandPostBody"/> instance for mocking. </returns>
        public static CassandraCommandPostBody CassandraCommandPostBody(string command = null, IDictionary<string, string> arguments = null, string host = null, bool? cassandraStopStart = null, bool? allowWrite = null)
        {
            arguments ??= new Dictionary<string, string>();

            return new CassandraCommandPostBody(
                command,
                arguments,
                host,
                cassandraStopStart,
                allowWrite,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraCommandOutput"/>. </summary>
        /// <param name="commandOutput"> Output of the command. </param>
        /// <returns> A new <see cref="Models.CassandraCommandOutput"/> instance for mocking. </returns>
        public static CassandraCommandOutput CassandraCommandOutput(string commandOutput = null)
        {
            return new CassandraCommandOutput(commandOutput, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraClusterCommand"/>. </summary>
        /// <param name="command"> The command which should be run. </param>
        /// <param name="commandId"> The unique id of command. </param>
        /// <param name="arguments"> The arguments for the command to be run. </param>
        /// <param name="host"> IP address of the cassandra host to run the command on. </param>
        /// <param name="isAdmin"> Whether command has admin privileges. </param>
        /// <param name="shouldStopCassandraBeforeStart"> If true, stops cassandra before executing the command and then start it again. </param>
        /// <param name="isReadWrite"> If true, allows the command to *write* to the cassandra directory, otherwise read-only. </param>
        /// <param name="result"> Result output of the command. </param>
        /// <param name="status"> Status of the command. </param>
        /// <param name="outputFile"> The name of the file where the result is written. </param>
        /// <returns> A new <see cref="Models.CassandraClusterCommand"/> instance for mocking. </returns>
        public static CassandraClusterCommand CassandraClusterCommand(string command = null, string commandId = null, BinaryData arguments = null, string host = null, bool? isAdmin = null, bool? shouldStopCassandraBeforeStart = null, bool? isReadWrite = null, string result = null, CassandraClusterCommandStatus? status = null, string outputFile = null)
        {
            return new CassandraClusterCommand(
                command,
                commandId,
                arguments,
                host,
                isAdmin,
                shouldStopCassandraBeforeStart,
                isReadWrite,
                result,
                status,
                outputFile,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraClusterBackupResourceInfo"/>. </summary>
        /// <param name="backupId"> The unique identifier of backup. </param>
        /// <param name="backupState"> The current state of the backup. </param>
        /// <param name="backupStartTimestamp"> The time at which the backup process begins. </param>
        /// <param name="backupStopTimestamp"> The time at which the backup process ends. </param>
        /// <param name="backupExpiryTimestamp"> The time at which the backup will expire. </param>
        /// <returns> A new <see cref="Models.CassandraClusterBackupResourceInfo"/> instance for mocking. </returns>
        public static CassandraClusterBackupResourceInfo CassandraClusterBackupResourceInfo(string backupId = null, CassandraClusterBackupState? backupState = null, DateTimeOffset? backupStartTimestamp = null, DateTimeOffset? backupStopTimestamp = null, DateTimeOffset? backupExpiryTimestamp = null)
        {
            return new CassandraClusterBackupResourceInfo(
                backupId,
                backupState,
                backupStartTimestamp,
                backupStopTimestamp,
                backupExpiryTimestamp,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CassandraDataCenterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of a managed Cassandra data center. </param>
        /// <returns> A new <see cref="CosmosDB.CassandraDataCenterData"/> instance for mocking. </returns>
        public static CassandraDataCenterData CassandraDataCenterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CassandraDataCenterProperties properties = null)
        {
            return new CassandraDataCenterData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraDataCenterProperties"/>. </summary>
        /// <param name="provisioningState"> The status of the resource at the time the operation was called. </param>
        /// <param name="dataCenterLocation"> The region this data center should be created in. </param>
        /// <param name="delegatedSubnetId"> Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/&lt;subscription id&gt;/resourceGroups/&lt;resource group&gt;/providers/Microsoft.Network/virtualNetworks/&lt;virtual network&gt;/subnets/&lt;subnet&gt;'. </param>
        /// <param name="nodeCount"> The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster. </param>
        /// <param name="seedNodes"> IP addresses for seed nodes in this data center. This is for reference. Generally you will want to use the seedNodes property on the cluster, which aggregates the seed nodes from all data centers in the cluster. </param>
        /// <param name="base64EncodedCassandraYamlFragment"> A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed. </param>
        /// <param name="managedDiskCustomerKeyUri"> Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key. </param>
        /// <param name="backupStorageCustomerKeyUri"> Indicates the Key Uri of the customer key to use for encryption of the backup storage account. </param>
        /// <param name="sku"> Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2. </param>
        /// <param name="diskSku"> Disk SKU used for data centers. Default value is P30. </param>
        /// <param name="diskCapacity"> Number of disks attached to each node. Default is 4. </param>
        /// <param name="doesSupportAvailabilityZone"> If the data center has Availability Zone support, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines. </param>
        /// <param name="authenticationMethodLdapProperties"> Ldap authentication method properties. This feature is in preview. </param>
        /// <param name="deallocated"> Whether the data center has been deallocated. </param>
        /// <param name="provisionError"> Error related to resource provisioning. </param>
        /// <param name="privateEndpointIPAddress"> Ip of the VPN Endpoint for this data center. </param>
        /// <returns> A new <see cref="Models.CassandraDataCenterProperties"/> instance for mocking. </returns>
        public static CassandraDataCenterProperties CassandraDataCenterProperties(CassandraProvisioningState? provisioningState = null, AzureLocation? dataCenterLocation = null, ResourceIdentifier delegatedSubnetId = null, int? nodeCount = null, IEnumerable<CassandraDataCenterSeedNode> seedNodes = null, string base64EncodedCassandraYamlFragment = null, Uri managedDiskCustomerKeyUri = null, Uri backupStorageCustomerKeyUri = null, string sku = null, string diskSku = null, int? diskCapacity = null, bool? doesSupportAvailabilityZone = null, AuthenticationMethodLdapProperties authenticationMethodLdapProperties = null, bool? deallocated = null, CassandraError provisionError = null, string privateEndpointIPAddress = null)
        {
            seedNodes ??= new List<CassandraDataCenterSeedNode>();

            return new CassandraDataCenterProperties(
                provisioningState,
                dataCenterLocation,
                delegatedSubnetId,
                nodeCount,
                seedNodes?.ToList(),
                base64EncodedCassandraYamlFragment,
                managedDiskCustomerKeyUri,
                backupStorageCustomerKeyUri,
                sku,
                diskSku,
                diskCapacity,
                doesSupportAvailabilityZone,
                authenticationMethodLdapProperties,
                deallocated,
                provisionError,
                privateEndpointIPAddress,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraClusterPublicStatus"/>. </summary>
        /// <param name="etag"></param>
        /// <param name="reaperStatus"></param>
        /// <param name="connectionErrors"> List relevant information about any connection errors to the Datacenters. </param>
        /// <param name="errors"> List relevant information about any errors about cluster, data center and connection error. </param>
        /// <param name="dataCenters"> List of the status of each datacenter in this cluster. </param>
        /// <returns> A new <see cref="Models.CassandraClusterPublicStatus"/> instance for mocking. </returns>
        public static CassandraClusterPublicStatus CassandraClusterPublicStatus(ETag? etag = null, CassandraReaperStatus reaperStatus = null, IEnumerable<CassandraConnectionError> connectionErrors = null, IEnumerable<CassandraError> errors = null, IEnumerable<CassandraClusterPublicStatusDataCentersItem> dataCenters = null)
        {
            connectionErrors ??= new List<CassandraConnectionError>();
            errors ??= new List<CassandraError>();
            dataCenters ??= new List<CassandraClusterPublicStatusDataCentersItem>();

            return new CassandraClusterPublicStatus(
                etag,
                reaperStatus,
                connectionErrors?.ToList(),
                errors?.ToList(),
                dataCenters?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraReaperStatus"/>. </summary>
        /// <param name="isHealthy"></param>
        /// <param name="repairRunIds"> Dictionary of &lt;string&gt;. </param>
        /// <param name="repairSchedules"> Dictionary of &lt;string&gt;. </param>
        /// <returns> A new <see cref="Models.CassandraReaperStatus"/> instance for mocking. </returns>
        public static CassandraReaperStatus CassandraReaperStatus(bool? isHealthy = null, IReadOnlyDictionary<string, string> repairRunIds = null, IReadOnlyDictionary<string, string> repairSchedules = null)
        {
            repairRunIds ??= new Dictionary<string, string>();
            repairSchedules ??= new Dictionary<string, string>();

            return new CassandraReaperStatus(isHealthy, repairRunIds, repairSchedules, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraConnectionError"/>. </summary>
        /// <param name="connectionState"> The kind of connection error that occurred. </param>
        /// <param name="ipFrom"> The IP of host that originated the failed connection. </param>
        /// <param name="ipTo"> The IP that the connection attempted to reach. </param>
        /// <param name="port"> The TCP port the connection was attempted on. </param>
        /// <param name="exception"> Detailed error message about the failed connection. </param>
        /// <returns> A new <see cref="Models.CassandraConnectionError"/> instance for mocking. </returns>
        public static CassandraConnectionError CassandraConnectionError(CassandraConnectionState? connectionState = null, string ipFrom = null, string ipTo = null, int? port = null, string exception = null)
        {
            return new CassandraConnectionError(
                connectionState,
                ipFrom,
                ipTo,
                port,
                exception,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraClusterPublicStatusDataCentersItem"/>. </summary>
        /// <param name="name"> The name of this Datacenter. </param>
        /// <param name="seedNodes"> A list of all seed nodes in the cluster, managed and unmanaged. </param>
        /// <param name="nodes"></param>
        /// <returns> A new <see cref="Models.CassandraClusterPublicStatusDataCentersItem"/> instance for mocking. </returns>
        public static CassandraClusterPublicStatusDataCentersItem CassandraClusterPublicStatusDataCentersItem(string name = null, IEnumerable<string> seedNodes = null, IEnumerable<CassandraClusterDataCenterNodeItem> nodes = null)
        {
            seedNodes ??= new List<string>();
            nodes ??= new List<CassandraClusterDataCenterNodeItem>();

            return new CassandraClusterPublicStatusDataCentersItem(name, seedNodes?.ToList(), nodes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CassandraClusterDataCenterNodeItem"/>. </summary>
        /// <param name="address"> The node's IP address. </param>
        /// <param name="state"> The state of the node in Cassandra ring. </param>
        /// <param name="status"></param>
        /// <param name="cassandraProcessStatus"> Cassandra service status on this node. </param>
        /// <param name="load"> The amount of file system data in the data directory (e.g., 47.66 kB), excluding all content in the snapshots subdirectories. Because all SSTable data files are included, any data that is not cleaned up (such as TTL-expired cells or tombstones) is counted. </param>
        /// <param name="tokens"> List of tokens this node covers. </param>
        /// <param name="size"></param>
        /// <param name="hostId"> The network ID of the node. </param>
        /// <param name="rack"> The rack this node is part of. </param>
        /// <param name="timestamp"> The timestamp when these statistics were captured. </param>
        /// <param name="diskUsedKB"> The amount of disk used, in kB, of the directory /var/lib/cassandra. </param>
        /// <param name="diskFreeKB"> The amount of disk free, in kB, of the directory /var/lib/cassandra. </param>
        /// <param name="memoryUsedKB"> Used memory (calculated as total - free - buffers - cache), in kB. </param>
        /// <param name="memoryBuffersAndCachedKB"> Memory used by kernel buffers (Buffers in /proc/meminfo) and page cache and slabs (Cached and SReclaimable in /proc/meminfo), in kB. </param>
        /// <param name="memoryFreeKB"> Unused memory (MemFree and SwapFree in /proc/meminfo), in kB. </param>
        /// <param name="memoryTotalKB"> Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in kB. </param>
        /// <param name="cpuUsage"> A float representing the current system-wide CPU utilization as a percentage. </param>
        /// <param name="isLatestModel"> If node has been updated to latest model. </param>
        /// <returns> A new <see cref="Models.CassandraClusterDataCenterNodeItem"/> instance for mocking. </returns>
        public static CassandraClusterDataCenterNodeItem CassandraClusterDataCenterNodeItem(string address = null, CassandraNodeState? state = null, string status = null, string cassandraProcessStatus = null, string load = null, IEnumerable<string> tokens = null, int? size = null, Guid? hostId = null, string rack = null, string timestamp = null, long? diskUsedKB = null, long? diskFreeKB = null, long? memoryUsedKB = null, long? memoryBuffersAndCachedKB = null, long? memoryFreeKB = null, long? memoryTotalKB = null, double? cpuUsage = null, bool? isLatestModel = null)
        {
            tokens ??= new List<string>();

            return new CassandraClusterDataCenterNodeItem(
                address,
                state,
                status,
                cassandraProcessStatus,
                load,
                tokens?.ToList(),
                size,
                hostId,
                rack,
                timestamp,
                diskUsedKB,
                diskFreeKB,
                memoryUsedKB,
                memoryBuffersAndCachedKB,
                memoryFreeKB,
                memoryTotalKB,
                cpuUsage,
                isLatestModel,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.MongoDBRoleDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="roleName"> A user-friendly name for the Role Definition. Must be unique for the database account. </param>
        /// <param name="roleDefinitionType"> Indicates whether the Role Definition was built-in or user created. </param>
        /// <param name="databaseName"> The database name for which access is being granted for this Role Definition. </param>
        /// <param name="privileges"> A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege. </param>
        /// <param name="roles"> The set of roles inherited by this Role Definition. </param>
        /// <returns> A new <see cref="CosmosDB.MongoDBRoleDefinitionData"/> instance for mocking. </returns>
        public static MongoDBRoleDefinitionData MongoDBRoleDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string roleName = null, MongoDBRoleDefinitionType? roleDefinitionType = null, string databaseName = null, IEnumerable<MongoDBPrivilege> privileges = null, IEnumerable<MongoDBRole> roles = null)
        {
            privileges ??= new List<MongoDBPrivilege>();
            roles ??= new List<MongoDBRole>();

            return new MongoDBRoleDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                roleName,
                roleDefinitionType,
                databaseName,
                privileges?.ToList(),
                roles?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.MongoDBUserDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="userName"> The user name for User Definition. </param>
        /// <param name="password"> The password for User Definition. Response does not contain user password. </param>
        /// <param name="databaseName"> The database name for which access is being granted for this User Definition. </param>
        /// <param name="customData"> A custom definition for the USer Definition. </param>
        /// <param name="roles"> The set of roles inherited by the User Definition. </param>
        /// <param name="mechanisms"> The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256. </param>
        /// <returns> A new <see cref="CosmosDB.MongoDBUserDefinitionData"/> instance for mocking. </returns>
        public static MongoDBUserDefinitionData MongoDBUserDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string userName = null, string password = null, string databaseName = null, string customData = null, IEnumerable<MongoDBRole> roles = null, string mechanisms = null)
        {
            roles ??= new List<MongoDBRole>();

            return new MongoDBUserDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                userName,
                password,
                databaseName,
                customData,
                roles?.ToList(),
                mechanisms,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.NetworkSecurityPerimeterConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Network security configuration properties. </param>
        /// <returns> A new <see cref="CosmosDB.NetworkSecurityPerimeterConfigurationData"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeterConfigurationData NetworkSecurityPerimeterConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NetworkSecurityPerimeterConfigurationProperties properties = null)
        {
            return new NetworkSecurityPerimeterConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkSecurityPerimeterConfigurationProperties"/>. </summary>
        /// <param name="provisioningState"> Provisioning state of a network security perimeter configuration that is being created or updated. </param>
        /// <param name="provisioningIssues"> List of provisioning issues, if any. </param>
        /// <param name="networkSecurityPerimeter"> Information about a network security perimeter (NSP). </param>
        /// <param name="resourceAssociation"> Information about resource association. </param>
        /// <param name="profile"> Network security perimeter configuration profile. </param>
        /// <returns> A new <see cref="Models.NetworkSecurityPerimeterConfigurationProperties"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeterConfigurationProperties NetworkSecurityPerimeterConfigurationProperties(NetworkSecurityPerimeterConfigurationProvisioningState? provisioningState = null, IEnumerable<ProvisioningIssue> provisioningIssues = null, NetworkSecurityPerimeter networkSecurityPerimeter = null, ResourceAssociation resourceAssociation = null, NetworkSecurityProfile profile = null)
        {
            provisioningIssues ??= new List<ProvisioningIssue>();

            return new NetworkSecurityPerimeterConfigurationProperties(
                provisioningState,
                provisioningIssues?.ToList(),
                networkSecurityPerimeter,
                resourceAssociation,
                profile,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProvisioningIssue"/>. </summary>
        /// <param name="name"> Name of the issue. </param>
        /// <param name="properties"> Details of a provisioning issue for a network security perimeter (NSP) configuration. Resource providers should generate separate provisioning issue elements for each separate issue detected, and include a meaningful and distinctive description, as well as any appropriate suggestedResourceIds and suggestedAccessRules. </param>
        /// <returns> A new <see cref="Models.ProvisioningIssue"/> instance for mocking. </returns>
        public static ProvisioningIssue ProvisioningIssue(string name = null, ProvisioningIssueProperties properties = null)
        {
            return new ProvisioningIssue(name, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProvisioningIssueProperties"/>. </summary>
        /// <param name="issueType"> Type of issue. </param>
        /// <param name="severity"> Severity of the issue. </param>
        /// <param name="description"> Description of the issue. </param>
        /// <param name="suggestedResourceIds"> Fully qualified resource IDs of suggested resources that can be associated to the network security perimeter (NSP) to remediate the issue. </param>
        /// <param name="suggestedAccessRules"> Access rules that can be added to the network security profile (NSP) to remediate the issue. </param>
        /// <returns> A new <see cref="Models.ProvisioningIssueProperties"/> instance for mocking. </returns>
        public static ProvisioningIssueProperties ProvisioningIssueProperties(IssueType? issueType = null, Severity? severity = null, string description = null, IEnumerable<ResourceIdentifier> suggestedResourceIds = null, IEnumerable<AccessRule> suggestedAccessRules = null)
        {
            suggestedResourceIds ??= new List<ResourceIdentifier>();
            suggestedAccessRules ??= new List<AccessRule>();

            return new ProvisioningIssueProperties(
                issueType,
                severity,
                description,
                suggestedResourceIds?.ToList(),
                suggestedAccessRules?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource required zone names. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBPrivateLinkResourceData"/> instance for mocking. </returns>
        public static CosmosDBPrivateLinkResourceData CosmosDBPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new CosmosDBPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlRoleDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="roleName"> A user-friendly name for the Role Definition. Must be unique for the database account. </param>
        /// <param name="roleDefinitionType"> Indicates whether the Role Definition was built-in or user created. </param>
        /// <param name="assignableScopes"> A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist. </param>
        /// <param name="permissions"> The set of operations allowed through this Role Definition. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlRoleDefinitionData"/> instance for mocking. </returns>
        public static CosmosDBSqlRoleDefinitionData CosmosDBSqlRoleDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string roleName = null, CosmosDBSqlRoleDefinitionType? roleDefinitionType = null, IEnumerable<string> assignableScopes = null, IEnumerable<CosmosDBSqlRolePermission> permissions = null)
        {
            assignableScopes ??= new List<string>();
            permissions ??= new List<CosmosDBSqlRolePermission>();

            return new CosmosDBSqlRoleDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                roleName,
                roleDefinitionType,
                assignableScopes?.ToList(),
                permissions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBSqlRoleAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="roleDefinitionId"> The unique identifier for the associated Role Definition. </param>
        /// <param name="scope"> The data plane resource path for which access is being granted through this Role Assignment. </param>
        /// <param name="principalId"> The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBSqlRoleAssignmentData"/> instance for mocking. </returns>
        public static CosmosDBSqlRoleAssignmentData CosmosDBSqlRoleAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier roleDefinitionId = null, string scope = null, Guid? principalId = null)
        {
            return new CosmosDBSqlRoleAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                roleDefinitionId,
                scope,
                principalId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.RestorableCosmosDBAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the resource group to which the resource belongs. </param>
        /// <param name="accountName"> The name of the global database account. </param>
        /// <param name="createdOn"> The creation time of the restorable database account (ISO-8601 format). </param>
        /// <param name="oldestRestorableOn"> The least recent time at which the database account can be restored to (ISO-8601 format). </param>
        /// <param name="deletedOn"> The time at which the restorable database account has been deleted (ISO-8601 format). </param>
        /// <param name="apiType"> The API type of the restorable database account. </param>
        /// <param name="restorableLocations"> List of regions where the of the database account can be restored from. </param>
        /// <returns> A new <see cref="CosmosDB.RestorableCosmosDBAccountData"/> instance for mocking. </returns>
        public static RestorableCosmosDBAccountData RestorableCosmosDBAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string accountName = null, DateTimeOffset? createdOn = null, DateTimeOffset? oldestRestorableOn = null, DateTimeOffset? deletedOn = null, CosmosDBApiType? apiType = null, IEnumerable<RestorableLocationResourceInfo> restorableLocations = null)
        {
            restorableLocations ??= new List<RestorableLocationResourceInfo>();

            return new RestorableCosmosDBAccountData(
                id,
                name,
                resourceType,
                systemData,
                location,
                accountName,
                createdOn,
                oldestRestorableOn,
                deletedOn,
                apiType,
                restorableLocations?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableLocationResourceInfo"/>. </summary>
        /// <param name="locationName"> The location of the regional restorable account. </param>
        /// <param name="regionalDatabaseAccountInstanceId"> The instance id of the regional restorable account. </param>
        /// <param name="createdOn"> The creation time of the regional restorable database account (ISO-8601 format). </param>
        /// <param name="deletedOn"> The time at which the regional restorable database account has been deleted (ISO-8601 format). </param>
        /// <returns> A new <see cref="Models.RestorableLocationResourceInfo"/> instance for mocking. </returns>
        public static RestorableLocationResourceInfo RestorableLocationResourceInfo(AzureLocation? locationName = null, string regionalDatabaseAccountInstanceId = null, DateTimeOffset? createdOn = null, DateTimeOffset? deletedOn = null)
        {
            return new RestorableLocationResourceInfo(locationName, regionalDatabaseAccountInstanceId, createdOn, deletedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBBackupInformation"/>. </summary>
        /// <param name="continuousBackupInformationLatestRestorableTimestamp"> Information about the status of continuous backups. </param>
        /// <returns> A new <see cref="Models.CosmosDBBackupInformation"/> instance for mocking. </returns>
        public static CosmosDBBackupInformation CosmosDBBackupInformation(DateTimeOffset? continuousBackupInformationLatestRestorableTimestamp = null)
        {
            return new CosmosDBBackupInformation(continuousBackupInformationLatestRestorableTimestamp != null ? new ContinuousBackupInformation(continuousBackupInformationLatestRestorableTimestamp, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableSqlDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB SQL database event. </param>
        /// <returns> A new <see cref="Models.RestorableSqlDatabase"/> instance for mocking. </returns>
        public static RestorableSqlDatabase RestorableSqlDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableSqlDatabaseResourceInfo resource = null)
        {
            return new RestorableSqlDatabase(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableSqlDatabaseResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this database event. </param>
        /// <param name="canUndelete"> A state of this database to identify if this database is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this database can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The time when this database event happened. </param>
        /// <param name="databaseName"> The name of the SQL database. </param>
        /// <param name="databaseId"> The resource ID of the SQL database. </param>
        /// <param name="database"> Cosmos DB SQL database resource object. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableSqlDatabaseResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableSqlDatabaseResourceInfo ExtendedRestorableSqlDatabaseResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string databaseName = null, string databaseId = null, RestorableSqlDatabasePropertiesResourceDatabase database = null)
        {
            return new ExtendedRestorableSqlDatabaseResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                databaseName,
                databaseId,
                database,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableSqlDatabasePropertiesResourceDatabase"/>. </summary>
        /// <param name="databaseName"> Name of the Cosmos DB SQL database. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="colls"> A system generated property that specified the addressable path of the collections resource. </param>
        /// <param name="users"> A system generated property that specifies the addressable path of the users resource. </param>
        /// <param name="self"> A system generated property that specifies the addressable path of the database resource. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.RestorableSqlDatabasePropertiesResourceDatabase"/> instance for mocking. </returns>
        public static RestorableSqlDatabasePropertiesResourceDatabase RestorableSqlDatabasePropertiesResourceDatabase(string databaseName = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, string colls = null, string users = null, string self = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            return new RestorableSqlDatabasePropertiesResourceDatabase(
                databaseName,
                restoreParameters,
                createMode,
                serializedAdditionalRawData: null,
                colls,
                users,
                self,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableSqlContainer"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB SQL container event. </param>
        /// <returns> A new <see cref="Models.RestorableSqlContainer"/> instance for mocking. </returns>
        public static RestorableSqlContainer RestorableSqlContainer(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableSqlContainerResourceInfo resource = null)
        {
            return new RestorableSqlContainer(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableSqlContainerResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this container event. </param>
        /// <param name="canUndelete"> A state of this container to identify if this container is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this container can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The when this container event happened. </param>
        /// <param name="containerName"> The name of this SQL container. </param>
        /// <param name="containerId"> The resource ID of this SQL container. </param>
        /// <param name="container"> Cosmos DB SQL container resource object. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableSqlContainerResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableSqlContainerResourceInfo ExtendedRestorableSqlContainerResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string containerName = null, string containerId = null, RestorableSqlContainerPropertiesResourceContainer container = null)
        {
            return new ExtendedRestorableSqlContainerResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                containerName,
                containerId,
                container,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableSqlContainerPropertiesResourceContainer"/>. </summary>
        /// <param name="containerName"> Name of the Cosmos DB SQL container. </param>
        /// <param name="indexingPolicy"> The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container. </param>
        /// <param name="partitionKey"> The configuration of the partition key to be used for partitioning data into multiple partitions. </param>
        /// <param name="defaultTtl"> Default time to live. </param>
        /// <param name="uniqueKeys"> The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service. </param>
        /// <param name="conflictResolutionPolicy"> The conflict resolution policy for the container. </param>
        /// <param name="clientEncryptionPolicy"> The client encryption policy for the container. </param>
        /// <param name="analyticalStorageTtl"> Analytical TTL. </param>
        /// <param name="restoreParameters"> Parameters to indicate the information about the restore. </param>
        /// <param name="createMode"> Enum to indicate the mode of resource creation. </param>
        /// <param name="materializedViewDefinition"> The configuration for defining Materialized Views. This must be specified only for creating a Materialized View container. </param>
        /// <param name="computedProperties"> List of computed properties. </param>
        /// <param name="self"> A system generated property that specifies the addressable path of the container resource. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        /// <returns> A new <see cref="Models.RestorableSqlContainerPropertiesResourceContainer"/> instance for mocking. </returns>
        public static RestorableSqlContainerPropertiesResourceContainer RestorableSqlContainerPropertiesResourceContainer(string containerName = null, CosmosDBIndexingPolicy indexingPolicy = null, CosmosDBContainerPartitionKey partitionKey = null, int? defaultTtl = null, IEnumerable<CosmosDBUniqueKey> uniqueKeys = null, ConflictResolutionPolicy conflictResolutionPolicy = null, CosmosDBClientEncryptionPolicy clientEncryptionPolicy = null, long? analyticalStorageTtl = null, ResourceRestoreParameters restoreParameters = null, CosmosDBAccountCreateMode? createMode = null, MaterializedViewDefinition materializedViewDefinition = null, IEnumerable<ComputedProperty> computedProperties = null, string self = null, string rid = null, float? timestamp = null, ETag? etag = null)
        {
            uniqueKeys ??= new List<CosmosDBUniqueKey>();
            computedProperties ??= new List<ComputedProperty>();

            return new RestorableSqlContainerPropertiesResourceContainer(
                containerName,
                indexingPolicy,
                partitionKey,
                defaultTtl,
                uniqueKeys != null ? new CosmosDBUniqueKeyPolicy(uniqueKeys?.ToList(), serializedAdditionalRawData: null) : null,
                conflictResolutionPolicy,
                clientEncryptionPolicy,
                analyticalStorageTtl,
                restoreParameters,
                createMode,
                materializedViewDefinition,
                computedProperties?.ToList(),
                serializedAdditionalRawData: null,
                self,
                rid,
                timestamp,
                etag);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableSqlResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databaseName"> The name of the database available for restore. </param>
        /// <param name="collectionNames"> The names of the collections available for restore. </param>
        /// <returns> A new <see cref="Models.RestorableSqlResourceData"/> instance for mocking. </returns>
        public static RestorableSqlResourceData RestorableSqlResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string databaseName = null, IEnumerable<string> collectionNames = null)
        {
            collectionNames ??= new List<string>();

            return new RestorableSqlResourceData(
                id,
                name,
                resourceType,
                systemData,
                databaseName,
                collectionNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableMongoDBDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB MongoDB database event. </param>
        /// <returns> A new <see cref="Models.RestorableMongoDBDatabase"/> instance for mocking. </returns>
        public static RestorableMongoDBDatabase RestorableMongoDBDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableMongoDBDatabaseResourceInfo resource = null)
        {
            return new RestorableMongoDBDatabase(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableMongoDBDatabaseResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this database event. </param>
        /// <param name="canUndelete"> A state of this database to identify if this database is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this database can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The time when this database event happened. </param>
        /// <param name="databaseName"> The name of this MongoDB database. </param>
        /// <param name="databaseId"> The resource ID of this MongoDB database. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableMongoDBDatabaseResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableMongoDBDatabaseResourceInfo ExtendedRestorableMongoDBDatabaseResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string databaseName = null, string databaseId = null)
        {
            return new ExtendedRestorableMongoDBDatabaseResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                databaseName,
                databaseId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableMongoDBCollection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB MongoDB collection event. </param>
        /// <returns> A new <see cref="Models.RestorableMongoDBCollection"/> instance for mocking. </returns>
        public static RestorableMongoDBCollection RestorableMongoDBCollection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableMongoDBCollectionResourceInfo resource = null)
        {
            return new RestorableMongoDBCollection(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableMongoDBCollectionResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this collection event. </param>
        /// <param name="canUndelete"> A state of this collection to identify if this container is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this collection can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The time when this collection event happened. </param>
        /// <param name="collectionName"> The name of this MongoDB collection. </param>
        /// <param name="collectionId"> The resource ID of this MongoDB collection. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableMongoDBCollectionResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableMongoDBCollectionResourceInfo ExtendedRestorableMongoDBCollectionResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string collectionName = null, string collectionId = null)
        {
            return new ExtendedRestorableMongoDBCollectionResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                collectionName,
                collectionId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableMongoDBResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databaseName"> The name of the database available for restore. </param>
        /// <param name="collectionNames"> The names of the collections available for restore. </param>
        /// <returns> A new <see cref="Models.RestorableMongoDBResourceData"/> instance for mocking. </returns>
        public static RestorableMongoDBResourceData RestorableMongoDBResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string databaseName = null, IEnumerable<string> collectionNames = null)
        {
            collectionNames ??= new List<string>();

            return new RestorableMongoDBResourceData(
                id,
                name,
                resourceType,
                systemData,
                databaseName,
                collectionNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableGremlinDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB Gremlin database event. </param>
        /// <returns> A new <see cref="Models.RestorableGremlinDatabase"/> instance for mocking. </returns>
        public static RestorableGremlinDatabase RestorableGremlinDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableGremlinDatabaseResourceInfo resource = null)
        {
            return new RestorableGremlinDatabase(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableGremlinDatabaseResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this database event. </param>
        /// <param name="canUndelete"> A state of this database to identify if this database is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this database can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The time when this database event happened. </param>
        /// <param name="databaseName"> The name of this Gremlin database. </param>
        /// <param name="databaseId"> The resource ID of this Gremlin database. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableGremlinDatabaseResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableGremlinDatabaseResourceInfo ExtendedRestorableGremlinDatabaseResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string databaseName = null, string databaseId = null)
        {
            return new ExtendedRestorableGremlinDatabaseResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                databaseName,
                databaseId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableGremlinGraph"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB Gremlin graph event. </param>
        /// <returns> A new <see cref="Models.RestorableGremlinGraph"/> instance for mocking. </returns>
        public static RestorableGremlinGraph RestorableGremlinGraph(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableGremlinGraphResourceInfo resource = null)
        {
            return new RestorableGremlinGraph(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableGremlinGraphResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this graph event. </param>
        /// <param name="canUndelete"> A state of this graph to identify if this graph is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this graph can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The time when this graph event happened. </param>
        /// <param name="graphName"> The name of this Gremlin graph. </param>
        /// <param name="graphId"> The resource ID of this Gremlin graph. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableGremlinGraphResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableGremlinGraphResourceInfo ExtendedRestorableGremlinGraphResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string graphName = null, string graphId = null)
        {
            return new ExtendedRestorableGremlinGraphResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                graphName,
                graphId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableGremlinResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databaseName"> The name of the gremlin database available for restore. </param>
        /// <param name="graphNames"> The names of the graphs available for restore. </param>
        /// <returns> A new <see cref="Models.RestorableGremlinResourceData"/> instance for mocking. </returns>
        public static RestorableGremlinResourceData RestorableGremlinResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string databaseName = null, IEnumerable<string> graphNames = null)
        {
            graphNames ??= new List<string>();

            return new RestorableGremlinResourceData(
                id,
                name,
                resourceType,
                systemData,
                databaseName,
                graphNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableTable"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resource"> The resource of an Azure Cosmos DB Table event. </param>
        /// <returns> A new <see cref="Models.RestorableTable"/> instance for mocking. </returns>
        public static RestorableTable RestorableTable(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ExtendedRestorableTableResourceInfo resource = null)
        {
            return new RestorableTable(
                id,
                name,
                resourceType,
                systemData,
                resource,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExtendedRestorableTableResourceInfo"/>. </summary>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="operationType"> The operation type of this table event. </param>
        /// <param name="canUndelete"> A state of this table to identify if this table is restorable in same account. </param>
        /// <param name="canUndeleteReason"> The reason why this table can not be restored in same account. </param>
        /// <param name="eventTimestamp"> The time when this table event happened. </param>
        /// <param name="tableName"> The name of this Table. </param>
        /// <param name="tableId"> The resource ID of this Table. </param>
        /// <returns> A new <see cref="Models.ExtendedRestorableTableResourceInfo"/> instance for mocking. </returns>
        public static ExtendedRestorableTableResourceInfo ExtendedRestorableTableResourceInfo(string rid = null, CosmosDBOperationType? operationType = null, string canUndelete = null, string canUndeleteReason = null, string eventTimestamp = null, string tableName = null, string tableId = null)
        {
            return new ExtendedRestorableTableResourceInfo(
                rid,
                operationType,
                canUndelete,
                canUndeleteReason,
                eventTimestamp,
                tableName,
                tableId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RestorableTableResourceData"/>. </summary>
        /// <param name="id"> The unique resource identifier of the ARM resource. </param>
        /// <param name="name"> The name of the Table. </param>
        /// <param name="resourceType"> The type of Azure resource. </param>
        /// <returns> A new <see cref="Models.RestorableTableResourceData"/> instance for mocking. </returns>
        public static RestorableTableResourceData RestorableTableResourceData(string id = null, string name = null, string resourceType = null)
        {
            return new RestorableTableResourceData(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Services response resource.
        /// Please note <see cref="Models.CosmosDBServiceProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataTransferServiceProperties"/>, <see cref="Models.GraphApiComputeServiceProperties"/>, <see cref="Models.MaterializedViewsBuilderServiceProperties"/> and <see cref="Models.SqlDedicatedGatewayServiceProperties"/>.
        /// </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBServiceData"/> instance for mocking. </returns>
        public static CosmosDBServiceData CosmosDBServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CosmosDBServiceProperties properties = null)
        {
            return new CosmosDBServiceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="serviceType"> ServiceType for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.CosmosDBServiceProperties"/> instance for mocking. </returns>
        public static CosmosDBServiceProperties CosmosDBServiceProperties(DateTimeOffset? createdOn = null, CosmosDBServiceSize? instanceSize = null, int? instanceCount = null, string serviceType = null, CosmosDBServiceStatus? status = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new CosmosDBServiceProperties(
                createdOn,
                instanceSize,
                instanceCount,
                serviceType == null ? default : new CosmosDBServiceType(serviceType),
                status,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBThroughputPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> A provisioning state of the ThroughputPool. </param>
        /// <param name="maxThroughput"> Value for throughput to be shared among CosmosDB resources in the pool. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBThroughputPoolData"/> instance for mocking. </returns>
        public static CosmosDBThroughputPoolData CosmosDBThroughputPoolData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CosmosDBStatus? provisioningState = null, int? maxThroughput = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CosmosDBThroughputPoolData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                maxThroughput,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBThroughputPoolAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> A provisioning state of the ThroughputPool Account. </param>
        /// <param name="accountResourceIdentifier"> The resource identifier of global database account in the throughputPool. </param>
        /// <param name="accountLocation"> The location of  global database account in the throughputPool. </param>
        /// <param name="accountInstanceId"> The instance id of global database account in the throughputPool. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBThroughputPoolAccountData"/> instance for mocking. </returns>
        public static CosmosDBThroughputPoolAccountData CosmosDBThroughputPoolAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CosmosDBStatus? provisioningState = null, ResourceIdentifier accountResourceIdentifier = null, AzureLocation? accountLocation = null, string accountInstanceId = null)
        {
            return new CosmosDBThroughputPoolAccountData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                accountResourceIdentifier,
                accountLocation,
                accountInstanceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDB.CosmosDBChaosFaultResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cosmosDBChaosFaultSupportedActions"> Indicates whether what action to take for the Chaos Fault. </param>
        /// <param name="region"> Region of the account where the Chaos Fault is to be enabled/disabled. </param>
        /// <param name="databaseName"> Database name. </param>
        /// <param name="containerName"> Container name. </param>
        /// <param name="provisioningState"> A provisioning state of the Chaos Fault. </param>
        /// <returns> A new <see cref="CosmosDB.CosmosDBChaosFaultResourceData"/> instance for mocking. </returns>
        public static CosmosDBChaosFaultResourceData CosmosDBChaosFaultResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CosmosDBChaosFaultSupportedAction? cosmosDBChaosFaultSupportedActions = null, string region = null, string databaseName = null, string containerName = null, string provisioningState = null)
        {
            return new CosmosDBChaosFaultResourceData(
                id,
                name,
                resourceType,
                systemData,
                cosmosDBChaosFaultSupportedActions,
                region,
                databaseName,
                containerName,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataTransferServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="locations"> An array that contains all of the locations for the service. </param>
        /// <returns> A new <see cref="Models.DataTransferServiceProperties"/> instance for mocking. </returns>
        public static DataTransferServiceProperties DataTransferServiceProperties(DateTimeOffset? createdOn = null, CosmosDBServiceSize? instanceSize = null, int? instanceCount = null, CosmosDBServiceStatus? status = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<DataTransferRegionalService> locations = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            locations ??= new List<DataTransferRegionalService>();

            return new DataTransferServiceProperties(
                createdOn,
                instanceSize,
                instanceCount,
                CosmosDBServiceType.DataTransfer,
                status,
                additionalProperties,
                locations?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataTransferRegionalService"/>. </summary>
        /// <param name="name"> The regional service name. </param>
        /// <param name="location"> The location name. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <returns> A new <see cref="Models.DataTransferRegionalService"/> instance for mocking. </returns>
        public static DataTransferRegionalService DataTransferRegionalService(string name = null, AzureLocation? location = null, CosmosDBServiceStatus? status = null)
        {
            return new DataTransferRegionalService(name, location, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CosmosDBRegionalService"/>. </summary>
        /// <param name="name"> The regional service name. </param>
        /// <param name="location"> The location name. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <returns> A new <see cref="Models.CosmosDBRegionalService"/> instance for mocking. </returns>
        public static CosmosDBRegionalService CosmosDBRegionalService(string name = null, AzureLocation? location = null, CosmosDBServiceStatus? status = null)
        {
            return new CosmosDBRegionalService(name, location, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDedicatedGatewayServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="sqlDedicatedGatewayEndpoint"> SqlDedicatedGateway endpoint for the service. </param>
        /// <param name="dedicatedGatewayType"> DedicatedGatewayType for the service. </param>
        /// <param name="locations"> An array that contains all of the locations for the service. </param>
        /// <returns> A new <see cref="Models.SqlDedicatedGatewayServiceProperties"/> instance for mocking. </returns>
        public static SqlDedicatedGatewayServiceProperties SqlDedicatedGatewayServiceProperties(DateTimeOffset? createdOn = null, CosmosDBServiceSize? instanceSize = null, int? instanceCount = null, CosmosDBServiceStatus? status = null, IDictionary<string, BinaryData> additionalProperties = null, string sqlDedicatedGatewayEndpoint = null, DedicatedGatewayType? dedicatedGatewayType = null, IEnumerable<SqlDedicatedGatewayRegionalService> locations = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            locations ??= new List<SqlDedicatedGatewayRegionalService>();

            return new SqlDedicatedGatewayServiceProperties(
                createdOn,
                instanceSize,
                instanceCount,
                CosmosDBServiceType.SqlDedicatedGateway,
                status,
                additionalProperties,
                sqlDedicatedGatewayEndpoint,
                dedicatedGatewayType,
                locations?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDedicatedGatewayRegionalService"/>. </summary>
        /// <param name="name"> The regional service name. </param>
        /// <param name="location"> The location name. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="sqlDedicatedGatewayEndpoint"> The regional endpoint for SqlDedicatedGateway. </param>
        /// <returns> A new <see cref="Models.SqlDedicatedGatewayRegionalService"/> instance for mocking. </returns>
        public static SqlDedicatedGatewayRegionalService SqlDedicatedGatewayRegionalService(string name = null, AzureLocation? location = null, CosmosDBServiceStatus? status = null, string sqlDedicatedGatewayEndpoint = null)
        {
            return new SqlDedicatedGatewayRegionalService(name, location, status, serializedAdditionalRawData: null, sqlDedicatedGatewayEndpoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GraphApiComputeServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="graphApiComputeEndpoint"> GraphAPICompute endpoint for the service. </param>
        /// <param name="locations"> An array that contains all of the locations for the service. </param>
        /// <returns> A new <see cref="Models.GraphApiComputeServiceProperties"/> instance for mocking. </returns>
        public static GraphApiComputeServiceProperties GraphApiComputeServiceProperties(DateTimeOffset? createdOn = null, CosmosDBServiceSize? instanceSize = null, int? instanceCount = null, CosmosDBServiceStatus? status = null, IDictionary<string, BinaryData> additionalProperties = null, string graphApiComputeEndpoint = null, IEnumerable<GraphApiComputeRegionalService> locations = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            locations ??= new List<GraphApiComputeRegionalService>();

            return new GraphApiComputeServiceProperties(
                createdOn,
                instanceSize,
                instanceCount,
                CosmosDBServiceType.GraphApiCompute,
                status,
                additionalProperties,
                graphApiComputeEndpoint,
                locations?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.GraphApiComputeRegionalService"/>. </summary>
        /// <param name="name"> The regional service name. </param>
        /// <param name="location"> The location name. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="graphApiComputeEndpoint"> The regional endpoint for GraphAPICompute. </param>
        /// <returns> A new <see cref="Models.GraphApiComputeRegionalService"/> instance for mocking. </returns>
        public static GraphApiComputeRegionalService GraphApiComputeRegionalService(string name = null, AzureLocation? location = null, CosmosDBServiceStatus? status = null, string graphApiComputeEndpoint = null)
        {
            return new GraphApiComputeRegionalService(name, location, status, serializedAdditionalRawData: null, graphApiComputeEndpoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MaterializedViewsBuilderServiceProperties"/>. </summary>
        /// <param name="createdOn"> Time of the last state change (ISO-8601 format). </param>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="locations"> An array that contains all of the locations for the service. </param>
        /// <returns> A new <see cref="Models.MaterializedViewsBuilderServiceProperties"/> instance for mocking. </returns>
        public static MaterializedViewsBuilderServiceProperties MaterializedViewsBuilderServiceProperties(DateTimeOffset? createdOn = null, CosmosDBServiceSize? instanceSize = null, int? instanceCount = null, CosmosDBServiceStatus? status = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<MaterializedViewsBuilderRegionalService> locations = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            locations ??= new List<MaterializedViewsBuilderRegionalService>();

            return new MaterializedViewsBuilderServiceProperties(
                createdOn,
                instanceSize,
                instanceCount,
                CosmosDBServiceType.MaterializedViewsBuilder,
                status,
                additionalProperties,
                locations?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MaterializedViewsBuilderRegionalService"/>. </summary>
        /// <param name="name"> The regional service name. </param>
        /// <param name="location"> The location name. </param>
        /// <param name="status"> Describes the status of a service. </param>
        /// <returns> A new <see cref="Models.MaterializedViewsBuilderRegionalService"/> instance for mocking. </returns>
        public static MaterializedViewsBuilderRegionalService MaterializedViewsBuilderRegionalService(string name = null, AzureLocation? location = null, CosmosDBServiceStatus? status = null)
        {
            return new MaterializedViewsBuilderRegionalService(name, location, status, serializedAdditionalRawData: null);
        }
    }
}
