// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CosmosDB.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.CosmosDB.Samples
{
    public partial class Sample_MongoDBCollectionThroughputSettingResource
    {
        // CosmosDBMongoDBCollectionRetrieveThroughputDistribution
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MongoDBContainerRetrieveThroughputDistribution_CosmosDBMongoDBCollectionRetrieveThroughputDistribution()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBMongoDBCollectionRetrieveThroughputDistribution.json
            // this example is just showing the usage of "MongoDBResources_MongoDBContainerRetrieveThroughputDistribution" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoDBCollectionThroughputSettingResource created on azure
            // for more information of creating MongoDBCollectionThroughputSettingResource, please refer to the document of MongoDBCollectionThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string collectionName = "collectionName";
            ResourceIdentifier mongoDBCollectionThroughputSettingResourceId = MongoDBCollectionThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, collectionName);
            MongoDBCollectionThroughputSettingResource mongoDBCollectionThroughputSetting = client.GetMongoDBCollectionThroughputSettingResource(mongoDBCollectionThroughputSettingResourceId);

            // invoke the operation
            RetrieveThroughputParameters retrieveThroughputParameters = new RetrieveThroughputParameters(new AzureLocation("placeholder"), new RetrieveThroughputPropertiesResource(new WritableSubResource[]
            {
new WritableSubResource()
{
Id = new ResourceIdentifier("0"),
},new WritableSubResource()
{
Id = new ResourceIdentifier("1"),
}
            }));
            ArmOperation<PhysicalPartitionThroughputInfoResult> lro = await mongoDBCollectionThroughputSetting.MongoDBContainerRetrieveThroughputDistributionAsync(WaitUntil.Completed, retrieveThroughputParameters);
            PhysicalPartitionThroughputInfoResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // CosmosDBMongoDBCollectionRedistributeThroughput
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MongoDBContainerRedistributeThroughput_CosmosDBMongoDBCollectionRedistributeThroughput()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBMongoDBCollectionRedistributeThroughput.json
            // this example is just showing the usage of "MongoDBResources_MongoDBContainerRedistributeThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoDBCollectionThroughputSettingResource created on azure
            // for more information of creating MongoDBCollectionThroughputSettingResource, please refer to the document of MongoDBCollectionThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string collectionName = "collectionName";
            ResourceIdentifier mongoDBCollectionThroughputSettingResourceId = MongoDBCollectionThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, collectionName);
            MongoDBCollectionThroughputSettingResource mongoDBCollectionThroughputSetting = client.GetMongoDBCollectionThroughputSettingResource(mongoDBCollectionThroughputSettingResourceId);

            // invoke the operation
            RedistributeThroughputParameters redistributeThroughputParameters = new RedistributeThroughputParameters(new AzureLocation("placeholder"), new RedistributeThroughputPropertiesResource(ThroughputPolicyType.Custom, new PhysicalPartitionThroughputInfoResource[]
            {
new PhysicalPartitionThroughputInfoResource("0")
{
Throughput = 5000,
},new PhysicalPartitionThroughputInfoResource("1")
{
Throughput = 5000,
}
            }, new PhysicalPartitionThroughputInfoResource[]
            {
new PhysicalPartitionThroughputInfoResource("2")
{
Throughput = 5000,
},new PhysicalPartitionThroughputInfoResource("3")
            }));
            ArmOperation<PhysicalPartitionThroughputInfoResult> lro = await mongoDBCollectionThroughputSetting.MongoDBContainerRedistributeThroughputAsync(WaitUntil.Completed, redistributeThroughputParameters);
            PhysicalPartitionThroughputInfoResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // CosmosDBMongoDBCollectionThroughputGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CosmosDBMongoDBCollectionThroughputGet()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBMongoDBCollectionThroughputGet.json
            // this example is just showing the usage of "MongoDBResources_GetMongoDBCollectionThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoDBCollectionThroughputSettingResource created on azure
            // for more information of creating MongoDBCollectionThroughputSettingResource, please refer to the document of MongoDBCollectionThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string collectionName = "collectionName";
            ResourceIdentifier mongoDBCollectionThroughputSettingResourceId = MongoDBCollectionThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, collectionName);
            MongoDBCollectionThroughputSettingResource mongoDBCollectionThroughputSetting = client.GetMongoDBCollectionThroughputSettingResource(mongoDBCollectionThroughputSettingResourceId);

            // invoke the operation
            MongoDBCollectionThroughputSettingResource result = await mongoDBCollectionThroughputSetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBMongoDBCollectionThroughputUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CosmosDBMongoDBCollectionThroughputUpdate()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBMongoDBCollectionThroughputUpdate.json
            // this example is just showing the usage of "MongoDBResources_UpdateMongoDBCollectionThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoDBCollectionThroughputSettingResource created on azure
            // for more information of creating MongoDBCollectionThroughputSettingResource, please refer to the document of MongoDBCollectionThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string collectionName = "collectionName";
            ResourceIdentifier mongoDBCollectionThroughputSettingResourceId = MongoDBCollectionThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, collectionName);
            MongoDBCollectionThroughputSettingResource mongoDBCollectionThroughputSetting = client.GetMongoDBCollectionThroughputSettingResource(mongoDBCollectionThroughputSettingResourceId);

            // invoke the operation
            ThroughputSettingsUpdateData data = new ThroughputSettingsUpdateData(new AzureLocation("West US"), new ThroughputSettingsResourceInfo()
            {
                Throughput = 400,
            })
            {
                Tags =
{
},
            };
            ArmOperation<MongoDBCollectionThroughputSettingResource> lro = await mongoDBCollectionThroughputSetting.CreateOrUpdateAsync(WaitUntil.Completed, data);
            MongoDBCollectionThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBMongoDBCollectionMigrateToAutoscale
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MigrateMongoDBCollectionToAutoscale_CosmosDBMongoDBCollectionMigrateToAutoscale()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBMongoDBCollectionMigrateToAutoscale.json
            // this example is just showing the usage of "MongoDBResources_MigrateMongoDBCollectionToAutoscale" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoDBCollectionThroughputSettingResource created on azure
            // for more information of creating MongoDBCollectionThroughputSettingResource, please refer to the document of MongoDBCollectionThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string collectionName = "collectionName";
            ResourceIdentifier mongoDBCollectionThroughputSettingResourceId = MongoDBCollectionThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, collectionName);
            MongoDBCollectionThroughputSettingResource mongoDBCollectionThroughputSetting = client.GetMongoDBCollectionThroughputSettingResource(mongoDBCollectionThroughputSettingResourceId);

            // invoke the operation
            ArmOperation<MongoDBCollectionThroughputSettingResource> lro = await mongoDBCollectionThroughputSetting.MigrateMongoDBCollectionToAutoscaleAsync(WaitUntil.Completed);
            MongoDBCollectionThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBMongoDBCollectionMigrateToManualThroughput
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MigrateMongoDBCollectionToManualThroughput_CosmosDBMongoDBCollectionMigrateToManualThroughput()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBMongoDBCollectionMigrateToManualThroughput.json
            // this example is just showing the usage of "MongoDBResources_MigrateMongoDBCollectionToManualThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MongoDBCollectionThroughputSettingResource created on azure
            // for more information of creating MongoDBCollectionThroughputSettingResource, please refer to the document of MongoDBCollectionThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string collectionName = "collectionName";
            ResourceIdentifier mongoDBCollectionThroughputSettingResourceId = MongoDBCollectionThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, collectionName);
            MongoDBCollectionThroughputSettingResource mongoDBCollectionThroughputSetting = client.GetMongoDBCollectionThroughputSettingResource(mongoDBCollectionThroughputSettingResourceId);

            // invoke the operation
            ArmOperation<MongoDBCollectionThroughputSettingResource> lro = await mongoDBCollectionThroughputSetting.MigrateMongoDBCollectionToManualThroughputAsync(WaitUntil.Completed);
            MongoDBCollectionThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
