// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CosmosDB.Models;

namespace Azure.ResourceManager.CosmosDB.Samples
{
    public partial class Sample_GremlinGraphThroughputSettingResource
    {
        // CosmosDBGremlinGraphThroughputGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CosmosDBGremlinGraphThroughputGet()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBGremlinGraphThroughputGet.json
            // this example is just showing the usage of "GremlinResources_GetGremlinGraphThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GremlinGraphThroughputSettingResource created on azure
            // for more information of creating GremlinGraphThroughputSettingResource, please refer to the document of GremlinGraphThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string graphName = "graphName";
            ResourceIdentifier gremlinGraphThroughputSettingResourceId = GremlinGraphThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, graphName);
            GremlinGraphThroughputSettingResource gremlinGraphThroughputSetting = client.GetGremlinGraphThroughputSettingResource(gremlinGraphThroughputSettingResourceId);

            // invoke the operation
            GremlinGraphThroughputSettingResource result = await gremlinGraphThroughputSetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBGremlinGraphThroughputUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CosmosDBGremlinGraphThroughputUpdate()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBGremlinGraphThroughputUpdate.json
            // this example is just showing the usage of "GremlinResources_UpdateGremlinGraphThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GremlinGraphThroughputSettingResource created on azure
            // for more information of creating GremlinGraphThroughputSettingResource, please refer to the document of GremlinGraphThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string graphName = "graphName";
            ResourceIdentifier gremlinGraphThroughputSettingResourceId = GremlinGraphThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, graphName);
            GremlinGraphThroughputSettingResource gremlinGraphThroughputSetting = client.GetGremlinGraphThroughputSettingResource(gremlinGraphThroughputSettingResourceId);

            // invoke the operation
            ThroughputSettingsUpdateData data = new ThroughputSettingsUpdateData(new AzureLocation("West US"), new ThroughputSettingsResourceInfo()
            {
                Throughput = 400,
            })
            {
                Tags =
{
},
            };
            ArmOperation<GremlinGraphThroughputSettingResource> lro = await gremlinGraphThroughputSetting.CreateOrUpdateAsync(WaitUntil.Completed, data);
            GremlinGraphThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBGremlinGraphMigrateToAutoscale
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MigrateGremlinGraphToAutoscale_CosmosDBGremlinGraphMigrateToAutoscale()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBGremlinGraphMigrateToAutoscale.json
            // this example is just showing the usage of "GremlinResources_MigrateGremlinGraphToAutoscale" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GremlinGraphThroughputSettingResource created on azure
            // for more information of creating GremlinGraphThroughputSettingResource, please refer to the document of GremlinGraphThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string graphName = "graphName";
            ResourceIdentifier gremlinGraphThroughputSettingResourceId = GremlinGraphThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, graphName);
            GremlinGraphThroughputSettingResource gremlinGraphThroughputSetting = client.GetGremlinGraphThroughputSettingResource(gremlinGraphThroughputSettingResourceId);

            // invoke the operation
            ArmOperation<GremlinGraphThroughputSettingResource> lro = await gremlinGraphThroughputSetting.MigrateGremlinGraphToAutoscaleAsync(WaitUntil.Completed);
            GremlinGraphThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBGremlinGraphMigrateToManualThroughput
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MigrateGremlinGraphToManualThroughput_CosmosDBGremlinGraphMigrateToManualThroughput()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBGremlinGraphMigrateToManualThroughput.json
            // this example is just showing the usage of "GremlinResources_MigrateGremlinGraphToManualThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GremlinGraphThroughputSettingResource created on azure
            // for more information of creating GremlinGraphThroughputSettingResource, please refer to the document of GremlinGraphThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string databaseName = "databaseName";
            string graphName = "graphName";
            ResourceIdentifier gremlinGraphThroughputSettingResourceId = GremlinGraphThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, databaseName, graphName);
            GremlinGraphThroughputSettingResource gremlinGraphThroughputSetting = client.GetGremlinGraphThroughputSettingResource(gremlinGraphThroughputSettingResourceId);

            // invoke the operation
            ArmOperation<GremlinGraphThroughputSettingResource> lro = await gremlinGraphThroughputSetting.MigrateGremlinGraphToManualThroughputAsync(WaitUntil.Completed);
            GremlinGraphThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
