// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.CosmosDB.Samples
{
    public partial class Sample_CosmosDBThroughputPoolAccountResource
    {
        // CosmosDB ThroughputPool Account Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CosmosDBThroughputPoolAccountGet()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/throughputPool/CosmosDBThroughputPoolAccountGet.json
            // this example is just showing the usage of "ThroughputPoolAccount_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBThroughputPoolAccountResource created on azure
            // for more information of creating CosmosDBThroughputPoolAccountResource, please refer to the document of CosmosDBThroughputPoolAccountResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "rgName";
            string throughputPoolName = "tp1";
            string throughputPoolAccountName = "db1";
            ResourceIdentifier cosmosDBThroughputPoolAccountResourceId = CosmosDBThroughputPoolAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, throughputPoolName, throughputPoolAccountName);
            CosmosDBThroughputPoolAccountResource cosmosDBThroughputPoolAccount = client.GetCosmosDBThroughputPoolAccountResource(cosmosDBThroughputPoolAccountResourceId);

            // invoke the operation
            CosmosDBThroughputPoolAccountResource result = await cosmosDBThroughputPoolAccount.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBThroughputPoolAccountData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDB ThroughputPool Account Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CosmosDBThroughputPoolAccountCreate()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/throughputPool/CosmosDBThroughputPoolAccountCreate.json
            // this example is just showing the usage of "ThroughputPoolAccount_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBThroughputPoolAccountResource created on azure
            // for more information of creating CosmosDBThroughputPoolAccountResource, please refer to the document of CosmosDBThroughputPoolAccountResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "rg1";
            string throughputPoolName = "tp1";
            string throughputPoolAccountName = "db1";
            ResourceIdentifier cosmosDBThroughputPoolAccountResourceId = CosmosDBThroughputPoolAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, throughputPoolName, throughputPoolAccountName);
            CosmosDBThroughputPoolAccountResource cosmosDBThroughputPoolAccount = client.GetCosmosDBThroughputPoolAccountResource(cosmosDBThroughputPoolAccountResourceId);

            // invoke the operation
            CosmosDBThroughputPoolAccountData data = new CosmosDBThroughputPoolAccountData()
            {
                AccountResourceIdentifier = new ResourceIdentifier("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/"),
                AccountLocation = new AzureLocation("West US"),
            };
            ArmOperation<CosmosDBThroughputPoolAccountResource> lro = await cosmosDBThroughputPoolAccount.UpdateAsync(WaitUntil.Completed, data);
            CosmosDBThroughputPoolAccountResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBThroughputPoolAccountData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDB ThroughputPool Account Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_CosmosDBThroughputPoolAccountDelete()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/throughputPool/CosmosDBThroughputPoolAccountDelete.json
            // this example is just showing the usage of "ThroughputPoolAccount_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBThroughputPoolAccountResource created on azure
            // for more information of creating CosmosDBThroughputPoolAccountResource, please refer to the document of CosmosDBThroughputPoolAccountResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "rgName";
            string throughputPoolName = "tp1";
            string throughputPoolAccountName = "db1";
            ResourceIdentifier cosmosDBThroughputPoolAccountResourceId = CosmosDBThroughputPoolAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, throughputPoolName, throughputPoolAccountName);
            CosmosDBThroughputPoolAccountResource cosmosDBThroughputPoolAccount = client.GetCosmosDBThroughputPoolAccountResource(cosmosDBThroughputPoolAccountResourceId);

            // invoke the operation
            await cosmosDBThroughputPoolAccount.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
