// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CosmosDB.Models;

namespace Azure.ResourceManager.CosmosDB.Samples
{
    public partial class Sample_CosmosDBChaosFaultResource
    {
        // ChaosFaultEnableDisable
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ChaosFaultEnableDisable()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/ChaosFaultEnableDisable.json
            // this example is just showing the usage of "ChaosFault_EnableDisable" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBChaosFaultResource created on azure
            // for more information of creating CosmosDBChaosFaultResource, please refer to the document of CosmosDBChaosFaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroupName";
            string accountName = "myAccountName";
            string chaosFault = "ServiceUnavailability";
            ResourceIdentifier cosmosDBChaosFaultResourceId = CosmosDBChaosFaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, chaosFault);
            CosmosDBChaosFaultResource cosmosDBChaosFaultResource = client.GetCosmosDBChaosFaultResource(cosmosDBChaosFaultResourceId);

            // invoke the operation
            CosmosDBChaosFaultResourceData data = new CosmosDBChaosFaultResourceData()
            {
                CosmosDBChaosFaultSupportedActions = CosmosDBChaosFaultSupportedAction.Enable,
                Region = "EastUS",
                DatabaseName = "testDatabase",
                ContainerName = "testCollection",
            };
            ArmOperation<CosmosDBChaosFaultResource> lro = await cosmosDBChaosFaultResource.UpdateAsync(WaitUntil.Completed, data);
            CosmosDBChaosFaultResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBChaosFaultResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ChaosFaultGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ChaosFaultGet()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/ChaosFaultGet.json
            // this example is just showing the usage of "ChaosFault_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CosmosDBChaosFaultResource created on azure
            // for more information of creating CosmosDBChaosFaultResource, please refer to the document of CosmosDBChaosFaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string chaosFault = "ServiceUnavailability";
            ResourceIdentifier cosmosDBChaosFaultResourceId = CosmosDBChaosFaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, chaosFault);
            CosmosDBChaosFaultResource cosmosDBChaosFaultResource = client.GetCosmosDBChaosFaultResource(cosmosDBChaosFaultResourceId);

            // invoke the operation
            CosmosDBChaosFaultResource result = await cosmosDBChaosFaultResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CosmosDBChaosFaultResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
