// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.CosmosDB.Models;

namespace Azure.ResourceManager.CosmosDB.Samples
{
    public partial class Sample_CassandraTableThroughputSettingResource
    {
        // CosmosDBCassandraTableThroughputGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_CosmosDBCassandraTableThroughputGet()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBCassandraTableThroughputGet.json
            // this example is just showing the usage of "CassandraResources_GetCassandraTableThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CassandraTableThroughputSettingResource created on azure
            // for more information of creating CassandraTableThroughputSettingResource, please refer to the document of CassandraTableThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string keyspaceName = "keyspaceName";
            string tableName = "tableName";
            ResourceIdentifier cassandraTableThroughputSettingResourceId = CassandraTableThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, keyspaceName, tableName);
            CassandraTableThroughputSettingResource cassandraTableThroughputSetting = client.GetCassandraTableThroughputSettingResource(cassandraTableThroughputSettingResourceId);

            // invoke the operation
            CassandraTableThroughputSettingResource result = await cassandraTableThroughputSetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBCassandraTableThroughputUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CosmosDBCassandraTableThroughputUpdate()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBCassandraTableThroughputUpdate.json
            // this example is just showing the usage of "CassandraResources_UpdateCassandraTableThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CassandraTableThroughputSettingResource created on azure
            // for more information of creating CassandraTableThroughputSettingResource, please refer to the document of CassandraTableThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string keyspaceName = "keyspaceName";
            string tableName = "tableName";
            ResourceIdentifier cassandraTableThroughputSettingResourceId = CassandraTableThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, keyspaceName, tableName);
            CassandraTableThroughputSettingResource cassandraTableThroughputSetting = client.GetCassandraTableThroughputSettingResource(cassandraTableThroughputSettingResourceId);

            // invoke the operation
            ThroughputSettingsUpdateData data = new ThroughputSettingsUpdateData(new AzureLocation("West US"), new ThroughputSettingsResourceInfo()
            {
                Throughput = 400,
            })
            {
                Tags =
{
},
            };
            ArmOperation<CassandraTableThroughputSettingResource> lro = await cassandraTableThroughputSetting.CreateOrUpdateAsync(WaitUntil.Completed, data);
            CassandraTableThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBCassandraTableMigrateToAutoscale
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MigrateCassandraTableToAutoscale_CosmosDBCassandraTableMigrateToAutoscale()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBCassandraTableMigrateToAutoscale.json
            // this example is just showing the usage of "CassandraResources_MigrateCassandraTableToAutoscale" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CassandraTableThroughputSettingResource created on azure
            // for more information of creating CassandraTableThroughputSettingResource, please refer to the document of CassandraTableThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string keyspaceName = "keyspaceName";
            string tableName = "tableName";
            ResourceIdentifier cassandraTableThroughputSettingResourceId = CassandraTableThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, keyspaceName, tableName);
            CassandraTableThroughputSettingResource cassandraTableThroughputSetting = client.GetCassandraTableThroughputSettingResource(cassandraTableThroughputSettingResourceId);

            // invoke the operation
            ArmOperation<CassandraTableThroughputSettingResource> lro = await cassandraTableThroughputSetting.MigrateCassandraTableToAutoscaleAsync(WaitUntil.Completed);
            CassandraTableThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CosmosDBCassandraTableMigrateToManualThroughput
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task MigrateCassandraTableToManualThroughput_CosmosDBCassandraTableMigrateToManualThroughput()
        {
            // Generated from example definition: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-09-01-preview/examples/CosmosDBCassandraTableMigrateToManualThroughput.json
            // this example is just showing the usage of "CassandraResources_MigrateCassandraTableToManualThroughput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CassandraTableThroughputSettingResource created on azure
            // for more information of creating CassandraTableThroughputSettingResource, please refer to the document of CassandraTableThroughputSettingResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string accountName = "ddb1";
            string keyspaceName = "keyspaceName";
            string tableName = "tableName";
            ResourceIdentifier cassandraTableThroughputSettingResourceId = CassandraTableThroughputSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, keyspaceName, tableName);
            CassandraTableThroughputSettingResource cassandraTableThroughputSetting = client.GetCassandraTableThroughputSettingResource(cassandraTableThroughputSettingResourceId);

            // invoke the operation
            ArmOperation<CassandraTableThroughputSettingResource> lro = await cassandraTableThroughputSetting.MigrateCassandraTableToManualThroughputAsync(WaitUntil.Completed);
            CassandraTableThroughputSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ThroughputSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
