// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.ComponentModel;

namespace System.ClientModel.Tests.Client.Models.ResourceManager.Resources
{
    /// <summary> The attributes of the token that the alias path is referring to. </summary>
    public readonly partial struct ResourceTypeAliasPathAttributes : IEquatable<ResourceTypeAliasPathAttributes>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeAliasPathAttributes"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceTypeAliasPathAttributes(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ModifiableValue = "Modifiable";

        /// <summary> The token that the alias path is referring to has no attributes. </summary>
        public static ResourceTypeAliasPathAttributes None { get; } = new ResourceTypeAliasPathAttributes(NoneValue);
        /// <summary> The token that the alias path is referring to is modifiable by policies with 'modify' effect. </summary>
        public static ResourceTypeAliasPathAttributes Modifiable { get; } = new ResourceTypeAliasPathAttributes(ModifiableValue);
        /// <summary> Determines if two <see cref="ResourceTypeAliasPathAttributes"/> values are the same. </summary>
        public static bool operator ==(ResourceTypeAliasPathAttributes left, ResourceTypeAliasPathAttributes right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceTypeAliasPathAttributes"/> values are not the same. </summary>
        public static bool operator !=(ResourceTypeAliasPathAttributes left, ResourceTypeAliasPathAttributes right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="ResourceTypeAliasPathAttributes"/>. </summary>
        public static implicit operator ResourceTypeAliasPathAttributes(string value) => new ResourceTypeAliasPathAttributes(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceTypeAliasPathAttributes other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceTypeAliasPathAttributes other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
