// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Core.TestFramework.Models
{
    /// <summary> Sanitizer for a request URI. </summary>
    public partial class UriRegexSanitizer
    {
        /// <summary> Initializes a new instance of UriRegexSanitizer. </summary>
        /// <param name="regex"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="regex"/> is null. </exception>
        public UriRegexSanitizer(string regex)
        {
            Argument.AssertNotNull(regex, nameof(regex));

            Regex = regex;
        }

        /// <summary> Gets the regex. </summary>
        public string Regex { get; }
        /// <summary> Gets or sets the value. </summary>
        public string Value { get; set; }
        /// <summary> Gets or sets the group for replace. </summary>
        public string GroupForReplace { get; set; }
    }
}
