// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Core.TestFramework.Models
{
    internal static partial class SanitizerTypeExtensions
    {
        public static string ToSerialString(this SanitizerType value) => value switch
        {
            SanitizerType.BodyKeySanitizer => "BodyKeySanitizer",
            SanitizerType.HeaderRegexSanitizer => "HeaderRegexSanitizer",
            SanitizerType.UriRegexSanitizer => "UriRegexSanitizer",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SanitizerType value.")
        };

        public static SanitizerType ToSanitizerType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BodyKeySanitizer")) return SanitizerType.BodyKeySanitizer;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "HeaderRegexSanitizer")) return SanitizerType.HeaderRegexSanitizer;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UriRegexSanitizer")) return SanitizerType.UriRegexSanitizer;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SanitizerType value.");
        }
    }
}
