// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Core.TestFramework.Models
{
    internal static partial class MatcherTypeExtensions
    {
        public static string ToSerialString(this MatcherType value) => value switch
        {
            MatcherType.BodilessMatcher => "BodilessMatcher",
            MatcherType.CustomDefaultMatcher => "CustomDefaultMatcher",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MatcherType value.")
        };

        public static MatcherType ToMatcherType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "BodilessMatcher")) return MatcherType.BodilessMatcher;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CustomDefaultMatcher")) return MatcherType.CustomDefaultMatcher;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MatcherType value.");
        }
    }
}
