// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Core.TestFramework.Models
{
    /// <summary> Sanitizer for a request header. </summary>
    public partial class HeaderRegexSanitizer
    {
        /// <summary> Initializes a new instance of HeaderRegexSanitizer. </summary>
        /// <param name="key"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public HeaderRegexSanitizer(string key)
        {
            Argument.AssertNotNull(key, nameof(key));

            Key = key;
        }

        /// <summary> Gets the key. </summary>
        public string Key { get; }
        /// <summary> Gets or sets the value. </summary>
        public string Value { get; set; }
        /// <summary> Gets or sets the regex. </summary>
        public string Regex { get; set; }
        /// <summary> Gets or sets the group for replace. </summary>
        public string GroupForReplace { get; set; }
    }
}
