// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Core.TestFramework.Models
{
    /// <summary> Sanitizer for a request body. </summary>
    public partial class BodyRegexSanitizer
    {
        /// <summary> Initializes a new instance of BodyRegexSanitizer. </summary>
        /// <param name="regex"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="regex"/> is null. </exception>
        public BodyRegexSanitizer(string regex)
        {
            Argument.AssertNotNull(regex, nameof(regex));

            Regex = regex;
        }

        /// <summary> Gets the regex. </summary>
        public string Regex { get; }
        /// <summary> Gets or sets the value. </summary>
        public string Value { get; set; }
        /// <summary> Gets or sets the group for replace. </summary>
        public string GroupForReplace { get; set; }
        /// <summary> Condition to apply for the sanitization or transform. If the condition is not met, sanitization/transform is not performed. </summary>
        public Condition Condition { get; set; }
    }
}
