// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Core.TestFramework.Models
{
    /// <summary> Sanitizer for a request body. </summary>
    public partial class BodyKeySanitizer
    {
        /// <summary> Initializes a new instance of BodyKeySanitizer. </summary>
        /// <param name="jsonPath"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="jsonPath"/> is null. </exception>
        public BodyKeySanitizer(string jsonPath)
        {
            Argument.AssertNotNull(jsonPath, nameof(jsonPath));

            JsonPath = jsonPath;
        }

        /// <summary> Gets the json path. </summary>
        public string JsonPath { get; }
        /// <summary> Gets or sets the value. </summary>
        public string Value { get; set; }
        /// <summary> Gets or sets the regex. </summary>
        public string Regex { get; set; }
        /// <summary> Gets or sets the group for replace. </summary>
        public string GroupForReplace { get; set; }
    }
}
