// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Core.Expressions.DataFactory
{
    /// <summary> Azure Key Vault secret reference. </summary>
    [PropertyReferenceType(new string[0], new[]{ nameof(SecretBaseType)})]
    public partial class DataFactoryKeyVaultSecret : DataFactorySecret
    {
        /// <summary> Initializes a new instance of AzureKeyVaultSecretReference. </summary>
        /// <param name="store"> The Azure Key Vault linked service reference. </param>
        /// <param name="secretName"> The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="store"/> or <paramref name="secretName"/> is null. </exception>
        [InitializationConstructor]
        public DataFactoryKeyVaultSecret(DataFactoryLinkedServiceReference store, DataFactoryElement<string> secretName)
        {
            Argument.AssertNotNull(store, nameof(store));
            Argument.AssertNotNull(secretName, nameof(secretName));

            Store = store;
            SecretName = secretName;
            SecretBaseType = "AzureKeyVaultSecret";
        }

        /// <summary> Initializes a new instance of AzureKeyVaultSecretReference. </summary>
        /// <param name="secretBaseType"> Type of the secret. </param>
        /// <param name="store"> The Azure Key Vault linked service reference. </param>
        /// <param name="secretName"> The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string). </param>
        /// <param name="secretVersion"> The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string). </param>
        [SerializationConstructor]
        internal DataFactoryKeyVaultSecret(string secretBaseType, DataFactoryLinkedServiceReference store, DataFactoryElement<string> secretName, DataFactoryElement<string> secretVersion) : base(secretBaseType)
        {
            Store = store;
            SecretName = secretName;
            SecretVersion = secretVersion;
            SecretBaseType = secretBaseType ?? "AzureKeyVaultSecret";
        }

        /// <summary> The Azure Key Vault linked service reference. </summary>
        public DataFactoryLinkedServiceReference Store { get; set; }
        /// <summary> The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> SecretName { get; set; }
        /// <summary> The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> SecretVersion { get; set; }
    }
}
