// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.ContentSafety.Samples
{
    public partial class Samples_ContentSafetyClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ContentSafetyClient_AnalyzeText_AnalyzeText()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                text = "This is text example",
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categoriesAnalysis")[0].GetProperty("category").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ContentSafetyClient_AnalyzeText_AnalyzeText_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                text = "This is text example",
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categoriesAnalysis")[0].GetProperty("category").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ContentSafetyClient_AnalyzeText_AnalyzeText_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            AnalyzeTextOptions options = new AnalyzeTextOptions("This is text example");
            Response<AnalyzeTextResult> response = client.AnalyzeText(options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ContentSafetyClient_AnalyzeText_AnalyzeText_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            AnalyzeTextOptions options = new AnalyzeTextOptions("This is text example");
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ContentSafetyClient_AnalyzeImage_AnalyzeImage()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                image = new
                {
                    content = "Y29udGVudDE=",
                },
            });
            Response response = client.AnalyzeImage(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categoriesAnalysis")[0].GetProperty("category").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ContentSafetyClient_AnalyzeImage_AnalyzeImage_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                image = new
                {
                    content = "Y29udGVudDE=",
                },
            });
            Response response = await client.AnalyzeImageAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("categoriesAnalysis")[0].GetProperty("category").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ContentSafetyClient_AnalyzeImage_AnalyzeImage_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            AnalyzeImageOptions options = new AnalyzeImageOptions(new ContentSafetyImageData());
            Response<AnalyzeImageResult> response = client.AnalyzeImage(options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ContentSafetyClient_AnalyzeImage_AnalyzeImage_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ContentSafetyClient client = new ContentSafetyClient(endpoint, credential);

            AnalyzeImageOptions options = new AnalyzeImageOptions(new ContentSafetyImageData());
            Response<AnalyzeImageResult> response = await client.AnalyzeImageAsync(options);
        }
    }
}
