// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.ContentSafety.Samples
{
    public partial class Samples_BlocklistClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_BlocklistClient_AddOrUpdateBlocklistItems_AddOrUpdateBlocklistItemsToTextBlocklist()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                blocklistItems = new object[]
            {
new
{
description = "Hate word",
text = "hate",
}
            },
            });
            Response response = client.AddOrUpdateBlocklistItems("TestBlocklist", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistItems")[0].GetProperty("blocklistItemId").ToString());
            Console.WriteLine(result.GetProperty("blocklistItems")[0].GetProperty("text").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_BlocklistClient_AddOrUpdateBlocklistItems_AddOrUpdateBlocklistItemsToTextBlocklist_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                blocklistItems = new object[]
            {
new
{
description = "Hate word",
text = "hate",
}
            },
            });
            Response response = await client.AddOrUpdateBlocklistItemsAsync("TestBlocklist", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistItems")[0].GetProperty("blocklistItemId").ToString());
            Console.WriteLine(result.GetProperty("blocklistItems")[0].GetProperty("text").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_BlocklistClient_AddOrUpdateBlocklistItems_AddOrUpdateBlocklistItemsToTextBlocklist_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            AddOrUpdateTextBlocklistItemsOptions options = new AddOrUpdateTextBlocklistItemsOptions(new TextBlocklistItem[]
            {
new TextBlocklistItem("hate")
{
Description = "Hate word",
}
            });
            Response<AddOrUpdateTextBlocklistItemsResult> response = client.AddOrUpdateBlocklistItems("TestBlocklist", options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_BlocklistClient_AddOrUpdateBlocklistItems_AddOrUpdateBlocklistItemsToTextBlocklist_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            AddOrUpdateTextBlocklistItemsOptions options = new AddOrUpdateTextBlocklistItemsOptions(new TextBlocklistItem[]
            {
new TextBlocklistItem("hate")
{
Description = "Hate word",
}
            });
            Response<AddOrUpdateTextBlocklistItemsResult> response = await client.AddOrUpdateBlocklistItemsAsync("TestBlocklist", options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklist_CreateOrUpdateTextBlocklist_CreateOrUpdateTextBlocklist()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            using RequestContent content = null;
            Response response = client.CreateOrUpdateTextBlocklist("TestBlocklist", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklist_CreateOrUpdateTextBlocklist_CreateOrUpdateTextBlocklist_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            using RequestContent content = null;
            Response response = await client.CreateOrUpdateTextBlocklistAsync("TestBlocklist", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklist_DeleteTextBlocklist_DeleteTextBlocklistByBlocklistName()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response response = client.DeleteTextBlocklist("TestBlocklist");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklist_DeleteTextBlocklist_DeleteTextBlocklistByBlocklistName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response response = await client.DeleteTextBlocklistAsync("TestBlocklist");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklist_GetTextBlocklist_GetTextBlocklistByBlocklistName()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response response = client.GetTextBlocklist("TestBlocklist", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklist_GetTextBlocklist_GetTextBlocklistByBlocklistName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response response = await client.GetTextBlocklistAsync("TestBlocklist", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklist_GetTextBlocklist_GetTextBlocklistByBlocklistName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response<TextBlocklist> response = client.GetTextBlocklist("TestBlocklist");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklist_GetTextBlocklist_GetTextBlocklistByBlocklistName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response<TextBlocklist> response = await client.GetTextBlocklistAsync("TestBlocklist");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklistItem_GetTextBlocklistItem_GetBlockItemByBlocklistNameAndBlocklistItemId()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response response = client.GetTextBlocklistItem("TestBlocklist", "9511969e-f1e3-4604-9127-05ee16c509ec", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistItemId").ToString());
            Console.WriteLine(result.GetProperty("text").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklistItem_GetTextBlocklistItem_GetBlockItemByBlocklistNameAndBlocklistItemId_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response response = await client.GetTextBlocklistItemAsync("TestBlocklist", "9511969e-f1e3-4604-9127-05ee16c509ec", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("blocklistItemId").ToString());
            Console.WriteLine(result.GetProperty("text").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklistItem_GetTextBlocklistItem_GetBlockItemByBlocklistNameAndBlocklistItemId_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response<TextBlocklistItem> response = client.GetTextBlocklistItem("TestBlocklist", "9511969e-f1e3-4604-9127-05ee16c509ec");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklistItem_GetTextBlocklistItem_GetBlockItemByBlocklistNameAndBlocklistItemId_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            Response<TextBlocklistItem> response = await client.GetTextBlocklistItemAsync("TestBlocklist", "9511969e-f1e3-4604-9127-05ee16c509ec");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_BlocklistClient_RemoveBlocklistItems_RemoveBlockItemsFromTextBlocklist()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                blocklistItemIds = new object[]
            {
"9511969e-f1e3-4604-9127-05ee16c509ec"
            },
            });
            Response response = client.RemoveBlocklistItems("TestBlocklist", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_BlocklistClient_RemoveBlocklistItems_RemoveBlockItemsFromTextBlocklist_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                blocklistItemIds = new object[]
            {
"9511969e-f1e3-4604-9127-05ee16c509ec"
            },
            });
            Response response = await client.RemoveBlocklistItemsAsync("TestBlocklist", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_BlocklistClient_RemoveBlocklistItems_RemoveBlockItemsFromTextBlocklist_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            RemoveTextBlocklistItemsOptions options = new RemoveTextBlocklistItemsOptions(new string[] { "9511969e-f1e3-4604-9127-05ee16c509ec" });
            Response response = client.RemoveBlocklistItems("TestBlocklist", options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_BlocklistClient_RemoveBlocklistItems_RemoveBlockItemsFromTextBlocklist_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            RemoveTextBlocklistItemsOptions options = new RemoveTextBlocklistItemsOptions(new string[] { "9511969e-f1e3-4604-9127-05ee16c509ec" });
            Response response = await client.RemoveBlocklistItemsAsync("TestBlocklist", options);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklistItem_GetTextBlocklistItems_GetAllBlockItemsByBlocklistName()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            foreach (BinaryData item in client.GetTextBlocklistItems("TestBlocklist", null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("blocklistItemId").ToString());
                Console.WriteLine(result.GetProperty("text").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklistItem_GetTextBlocklistItems_GetAllBlockItemsByBlocklistName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            await foreach (BinaryData item in client.GetTextBlocklistItemsAsync("TestBlocklist", null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("blocklistItemId").ToString());
                Console.WriteLine(result.GetProperty("text").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklistItem_GetTextBlocklistItems_GetAllBlockItemsByBlocklistName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            foreach (TextBlocklistItem item in client.GetTextBlocklistItems("TestBlocklist"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklistItem_GetTextBlocklistItems_GetAllBlockItemsByBlocklistName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            await foreach (TextBlocklistItem item in client.GetTextBlocklistItemsAsync("TestBlocklist"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklist_GetTextBlocklists_GetAllTextBlocklists()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            foreach (BinaryData item in client.GetTextBlocklists(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("blocklistName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklist_GetTextBlocklists_GetAllTextBlocklists_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            await foreach (BinaryData item in client.GetTextBlocklistsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("blocklistName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TextBlocklist_GetTextBlocklists_GetAllTextBlocklists_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            foreach (TextBlocklist item in client.GetTextBlocklists())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TextBlocklist_GetTextBlocklists_GetAllTextBlocklists_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            BlocklistClient client = new BlocklistClient(endpoint, credential);

            await foreach (TextBlocklist item in client.GetTextBlocklistsAsync())
            {
            }
        }
    }
}
