// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.ContentSafety
{
    /// <summary> Text analyze category. </summary>
    public readonly partial struct TextCategory : IEquatable<TextCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TextCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TextCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HateValue = "Hate";
        private const string SelfHarmValue = "SelfHarm";
        private const string SexualValue = "Sexual";
        private const string ViolenceValue = "Violence";

        /// <summary> Hate. </summary>
        public static TextCategory Hate { get; } = new TextCategory(HateValue);
        /// <summary> SelfHarm. </summary>
        public static TextCategory SelfHarm { get; } = new TextCategory(SelfHarmValue);
        /// <summary> Sexual. </summary>
        public static TextCategory Sexual { get; } = new TextCategory(SexualValue);
        /// <summary> Violence. </summary>
        public static TextCategory Violence { get; } = new TextCategory(ViolenceValue);
        /// <summary> Determines if two <see cref="TextCategory"/> values are the same. </summary>
        public static bool operator ==(TextCategory left, TextCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TextCategory"/> values are not the same. </summary>
        public static bool operator !=(TextCategory left, TextCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TextCategory"/>. </summary>
        public static implicit operator TextCategory(string value) => new TextCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TextCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TextCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
