// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.ContentSafety
{
    /// <summary> The result of blocklist match. </summary>
    public partial class TextBlocklistMatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TextBlocklistMatch"/>. </summary>
        /// <param name="blocklistName"> The name of the matched blocklist. </param>
        /// <param name="blocklistItemId"> The ID of the matched item. </param>
        /// <param name="blocklistItemText"> The content of the matched item. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="blocklistName"/>, <paramref name="blocklistItemId"/> or <paramref name="blocklistItemText"/> is null. </exception>
        internal TextBlocklistMatch(string blocklistName, string blocklistItemId, string blocklistItemText)
        {
            Argument.AssertNotNull(blocklistName, nameof(blocklistName));
            Argument.AssertNotNull(blocklistItemId, nameof(blocklistItemId));
            Argument.AssertNotNull(blocklistItemText, nameof(blocklistItemText));

            BlocklistName = blocklistName;
            BlocklistItemId = blocklistItemId;
            BlocklistItemText = blocklistItemText;
        }

        /// <summary> Initializes a new instance of <see cref="TextBlocklistMatch"/>. </summary>
        /// <param name="blocklistName"> The name of the matched blocklist. </param>
        /// <param name="blocklistItemId"> The ID of the matched item. </param>
        /// <param name="blocklistItemText"> The content of the matched item. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TextBlocklistMatch(string blocklistName, string blocklistItemId, string blocklistItemText, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlocklistName = blocklistName;
            BlocklistItemId = blocklistItemId;
            BlocklistItemText = blocklistItemText;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TextBlocklistMatch"/> for deserialization. </summary>
        internal TextBlocklistMatch()
        {
        }

        /// <summary> The name of the matched blocklist. </summary>
        public string BlocklistName { get; }
        /// <summary> The ID of the matched item. </summary>
        public string BlocklistItemId { get; }
        /// <summary> The content of the matched item. </summary>
        public string BlocklistItemText { get; }
    }
}
