// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.ContentSafety
{
    /// <summary> Item in a TextBlocklist. </summary>
    public partial class TextBlocklistItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TextBlocklistItem"/>. </summary>
        /// <param name="text"> BlocklistItem content. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="text"/> is null. </exception>
        public TextBlocklistItem(string text)
        {
            Argument.AssertNotNull(text, nameof(text));

            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="TextBlocklistItem"/>. </summary>
        /// <param name="blocklistItemId"> The service will generate a BlocklistItemId, which will be a UUID. </param>
        /// <param name="description"> BlocklistItem description. </param>
        /// <param name="text"> BlocklistItem content. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TextBlocklistItem(string blocklistItemId, string description, string text, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlocklistItemId = blocklistItemId;
            Description = description;
            Text = text;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TextBlocklistItem"/> for deserialization. </summary>
        internal TextBlocklistItem()
        {
        }

        /// <summary> The service will generate a BlocklistItemId, which will be a UUID. </summary>
        public string BlocklistItemId { get; }
        /// <summary> BlocklistItem description. </summary>
        public string Description { get; set; }
        /// <summary> BlocklistItem content. </summary>
        public string Text { get; set; }
    }
}
