// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.ContentSafety
{
    public partial class AddOrUpdateTextBlocklistItemsResult : IUtf8JsonSerializable, IJsonModel<AddOrUpdateTextBlocklistItemsResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AddOrUpdateTextBlocklistItemsResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AddOrUpdateTextBlocklistItemsResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AddOrUpdateTextBlocklistItemsResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AddOrUpdateTextBlocklistItemsResult)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("blocklistItems"u8);
            writer.WriteStartArray();
            foreach (var item in BlocklistItems)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AddOrUpdateTextBlocklistItemsResult IJsonModel<AddOrUpdateTextBlocklistItemsResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AddOrUpdateTextBlocklistItemsResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AddOrUpdateTextBlocklistItemsResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAddOrUpdateTextBlocklistItemsResult(document.RootElement, options);
        }

        internal static AddOrUpdateTextBlocklistItemsResult DeserializeAddOrUpdateTextBlocklistItemsResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<TextBlocklistItem> blocklistItems = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("blocklistItems"u8))
                {
                    List<TextBlocklistItem> array = new List<TextBlocklistItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TextBlocklistItem.DeserializeTextBlocklistItem(item, options));
                    }
                    blocklistItems = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AddOrUpdateTextBlocklistItemsResult(blocklistItems, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AddOrUpdateTextBlocklistItemsResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AddOrUpdateTextBlocklistItemsResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AddOrUpdateTextBlocklistItemsResult)} does not support writing '{options.Format}' format.");
            }
        }

        AddOrUpdateTextBlocklistItemsResult IPersistableModel<AddOrUpdateTextBlocklistItemsResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AddOrUpdateTextBlocklistItemsResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAddOrUpdateTextBlocklistItemsResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AddOrUpdateTextBlocklistItemsResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AddOrUpdateTextBlocklistItemsResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AddOrUpdateTextBlocklistItemsResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAddOrUpdateTextBlocklistItemsResult(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
