---
page_type: sample
languages:
- csharp
products:
- azure
- azure-cognitive-services
name: Azure AI Content Safety samples for .NET
description: Samples for the Azure.AI.ContentSafety client library
---

# Azure AI Content Safety client SDK Samples

These code samples show common scenario operations with the Content Safety client library.

|**Sample Name**|**Description**|
|----------------|-------------|
|[Sample1_AnalyzeText](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/contentsafety/Azure.AI.ContentSafety/samples/Sample1_AnalyzeText.md) |Scans text for sexual content, violence, hate, and self harm with multi-severity levels.|
|[Sample2_AnalyzeImage](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/contentsafety/Azure.AI.ContentSafety/samples/Sample2_AnalyzeImage.md) |Scans images for sexual content, violence, hate, and self harm with multi-severity levels.|
|[Sample3_ManageTextBlocklist](https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/contentsafety/Azure.AI.ContentSafety/samples/Sample3_ManageTextBlocklist.md) |The default AI classifiers are sufficient for most content safety needs; however, you might need to screen for terms that are specific to your use case. You can create blocklists of terms to use with the Text API.|
