// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details. </summary>
    public readonly partial struct WindowsVmLicenseType : IEquatable<WindowsVmLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WindowsVmLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WindowsVmLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string WindowsServerValue = "Windows_Server";

        /// <summary> No additional licensing is applied. </summary>
        public static WindowsVmLicenseType None { get; } = new WindowsVmLicenseType(NoneValue);
        /// <summary> Enables Azure Hybrid User Benefits for Windows VMs. </summary>
        public static WindowsVmLicenseType WindowsServer { get; } = new WindowsVmLicenseType(WindowsServerValue);
        /// <summary> Determines if two <see cref="WindowsVmLicenseType"/> values are the same. </summary>
        public static bool operator ==(WindowsVmLicenseType left, WindowsVmLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WindowsVmLicenseType"/> values are not the same. </summary>
        public static bool operator !=(WindowsVmLicenseType left, WindowsVmLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WindowsVmLicenseType"/>. </summary>
        public static implicit operator WindowsVmLicenseType(string value) => new WindowsVmLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WindowsVmLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WindowsVmLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
