// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The type of a snapshot. The default is NodePool. </summary>
    public readonly partial struct SnapshotType : IEquatable<SnapshotType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SnapshotType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SnapshotType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NodePoolValue = "NodePool";

        /// <summary> The snapshot is a snapshot of a node pool. </summary>
        public static SnapshotType NodePool { get; } = new SnapshotType(NodePoolValue);
        /// <summary> Determines if two <see cref="SnapshotType"/> values are the same. </summary>
        public static bool operator ==(SnapshotType left, SnapshotType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SnapshotType"/> values are not the same. </summary>
        public static bool operator !=(SnapshotType left, SnapshotType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SnapshotType"/>. </summary>
        public static implicit operator SnapshotType(string value) => new SnapshotType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SnapshotType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SnapshotType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
