// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Service mesh profile for a managed cluster. </summary>
    public partial class ServiceMeshProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceMeshProfile"/>. </summary>
        /// <param name="mode"> Mode of the service mesh. </param>
        public ServiceMeshProfile(ServiceMeshMode mode)
        {
            Mode = mode;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceMeshProfile"/>. </summary>
        /// <param name="mode"> Mode of the service mesh. </param>
        /// <param name="istio"> Istio service mesh configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceMeshProfile(ServiceMeshMode mode, IstioServiceMesh istio, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mode = mode;
            Istio = istio;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceMeshProfile"/> for deserialization. </summary>
        internal ServiceMeshProfile()
        {
        }

        /// <summary> Mode of the service mesh. </summary>
        [WirePath("mode")]
        public ServiceMeshMode Mode { get; set; }
        /// <summary> Istio service mesh configuration. </summary>
        [WirePath("istio")]
        public IstioServiceMesh Istio { get; set; }
    }
}
